/*
 * Decompiled with CFR 0.152.
 */
package com.univ.objetspartages.dao.impl;

import com.jsbsoft.jtf.database.OMContext;
import com.jsbsoft.jtf.datasource.exceptions.AddToDataSourceException;
import com.jsbsoft.jtf.datasource.exceptions.DataSourceException;
import com.jsbsoft.jtf.datasource.exceptions.UpdateToDataSourceException;
import com.univ.objetspartages.bean.FicheAccueilBean;
import com.univ.objetspartages.dao.AbstractFicheDAO;
import com.univ.objetspartages.om.FicheAccueil;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.utils.Chaine;
import com.univ.utils.ContexteDao;
import com.univ.utils.sql.RequeteSQL;
import com.univ.utils.sql.clause.ClauseLimit;
import com.univ.utils.sql.clause.ClauseOrderBy;
import com.univ.utils.sql.clause.ClauseWhere;
import com.univ.utils.sql.criterespecifique.ConditionHelper;
import com.univ.utils.sql.criterespecifique.LimitHelper;
import com.univ.utils.sql.criterespecifique.RequeteSQLHelper;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class FicheAccueilDAO
extends AbstractFicheDAO<FicheAccueilBean> {
    public FicheAccueilDAO() {
        this.tableName = "FICHEACCUEIL";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FicheAccueilBean add(FicheAccueilBean fiche) throws AddToDataSourceException {
        ResultSet rs = null;
        try {
            try (Connection connection = this.dataSource.getConnection();
                 PreparedStatement stmt = connection.prepareStatement("insert into FICHEACCUEIL (TITRE, CODE, META_KEYWORDS, META_DESCRIPTION, CODE_RUBRIQUE, CODE_RATTACHEMENT, TITRE_ENCADRE, CONTENU_ENCADRE, DATE_ALERTE, MESSAGE_ALERTE, DATE_CREATION, DATE_PROPOSITION, DATE_VALIDATION, DATE_MODIFICATION, CODE_REDACTEUR, CODE_VALIDATION, DATE_ARCHIVAGE, LANGUE, ETAT_OBJET, NB_HITS, DIFFUSION_PUBLIC_VISE, DIFFUSION_MODE_RESTRICTION, DIFFUSION_PUBLIC_VISE_RESTRICTION) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)", 1);){
                stmt.setObject(1, (Object)fiche.getTitle(), -1);
                stmt.setObject(2, (Object)fiche.getCode(), 12);
                stmt.setObject(3, (Object)fiche.getMetaKeywords(), -1);
                stmt.setObject(4, (Object)fiche.getMetaDescription(), -1);
                stmt.setObject(5, (Object)fiche.getCodeRubrique(), 12);
                stmt.setObject(6, (Object)fiche.getCodeRattachement(), 12);
                stmt.setObject(7, (Object)fiche.getTitreEncadre(), 12);
                stmt.setObject(8, (Object)fiche.getContenuEncadre(), 12);
                stmt.setObject(9, (Object)fiche.getDateAlerte(), 91);
                stmt.setObject(10, (Object)fiche.getMessageAlerte(), -1);
                stmt.setObject(11, (Object)fiche.getDateCreation(), 93);
                stmt.setObject(12, (Object)fiche.getDateProposition(), 93);
                stmt.setObject(13, (Object)fiche.getDateValidation(), 93);
                stmt.setObject(14, (Object)fiche.getDateModification(), 93);
                stmt.setObject(15, (Object)fiche.getCodeRedacteur(), 12);
                stmt.setObject(16, (Object)fiche.getCodeValidation(), 12);
                stmt.setObject(17, (Object)fiche.getDateArchivage(), 91);
                stmt.setObject(18, (Object)fiche.getLangue(), 12);
                stmt.setObject(19, (Object)fiche.getEtatObjet(), 12);
                stmt.setObject(20, (Object)fiche.getNbHits(), -5);
                stmt.setObject(21, (Object)fiche.getDiffusionPublicVise(), 12);
                stmt.setObject(22, (Object)fiche.getDiffusionModeRestriction(), 12);
                stmt.setObject(23, (Object)fiche.getDiffusionPublicViseRestriction(), 12);
                int rowsAffected = stmt.executeUpdate();
                if (rowsAffected != 1) {
                    throw new AddToDataSourceException(String.format("Unable to add [%s] to table \"%s\" : %d row(s) affected", fiche.toString(), this.tableName, rowsAffected));
                }
                rs = stmt.getGeneratedKeys();
                rs.next();
                fiche.setId(rs.getLong(1));
            }
            if (rs == null) return fiche;
        }
        catch (SQLException e) {
            try {
                throw new AddToDataSourceException(String.format("Unable to add [%s] to table \"%s\"", fiche.toString(), this.tableName), (Throwable)e);
            }
            catch (Throwable throwable) {
                if (rs == null) throw throwable;
                try {
                    rs.close();
                    throw throwable;
                }
                catch (SQLException e2) {
                    LOG.error(String.format("An error occured closing Resultset during add() on table %s", this.tableName), (Throwable)e2);
                }
                throw throwable;
            }
        }
        try {
            rs.close();
            return fiche;
        }
        catch (SQLException e) {
            LOG.error(String.format("An error occured closing Resultset during add() on table %s", this.tableName), (Throwable)e);
            return fiche;
        }
    }

    public FicheAccueilBean update(FicheAccueilBean fiche) throws UpdateToDataSourceException {
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement stmt = connection.prepareStatement("update FICHEACCUEIL set TITRE = ?, CODE = ?, META_KEYWORDS = ?, META_DESCRIPTION = ?, CODE_RUBRIQUE = ?, CODE_RATTACHEMENT = ?, TITRE_ENCADRE = ?, CONTENU_ENCADRE = ?, DATE_ALERTE = ?, MESSAGE_ALERTE = ?, DATE_CREATION = ?, DATE_PROPOSITION = ?, DATE_VALIDATION = ?, DATE_MODIFICATION = ?, CODE_REDACTEUR = ?, CODE_VALIDATION = ?, DATE_ARCHIVAGE = ?, LANGUE = ?, ETAT_OBJET = ?, NB_HITS = ?, DIFFUSION_PUBLIC_VISE = ?, DIFFUSION_MODE_RESTRICTION = ?, DIFFUSION_PUBLIC_VISE_RESTRICTION = ? WHERE ID_FICHEACCUEIL = ?");){
            stmt.setObject(1, (Object)fiche.getTitle(), -1);
            stmt.setObject(2, (Object)fiche.getCode(), 12);
            stmt.setObject(3, (Object)fiche.getMetaKeywords(), -1);
            stmt.setObject(4, (Object)fiche.getMetaDescription(), -1);
            stmt.setObject(5, (Object)fiche.getCodeRubrique(), 12);
            stmt.setObject(6, (Object)fiche.getCodeRattachement(), 12);
            stmt.setObject(7, (Object)fiche.getTitreEncadre(), 12);
            stmt.setObject(8, (Object)fiche.getContenuEncadre(), 12);
            stmt.setObject(9, (Object)fiche.getDateAlerte(), 91);
            stmt.setObject(10, (Object)fiche.getMessageAlerte(), -1);
            stmt.setObject(11, (Object)fiche.getDateCreation(), 93);
            stmt.setObject(12, (Object)fiche.getDateProposition(), 93);
            stmt.setObject(13, (Object)fiche.getDateValidation(), 93);
            stmt.setObject(14, (Object)fiche.getDateModification(), 93);
            stmt.setObject(15, (Object)fiche.getCodeRedacteur(), 12);
            stmt.setObject(16, (Object)fiche.getCodeValidation(), 12);
            stmt.setObject(17, (Object)fiche.getDateArchivage(), 91);
            stmt.setObject(18, (Object)fiche.getLangue(), 12);
            stmt.setObject(19, (Object)fiche.getEtatObjet(), 12);
            stmt.setObject(20, (Object)fiche.getNbHits(), -5);
            stmt.setObject(21, (Object)fiche.getDiffusionPublicVise(), 12);
            stmt.setObject(22, (Object)fiche.getDiffusionModeRestriction(), 12);
            stmt.setObject(23, (Object)fiche.getDiffusionPublicViseRestriction(), 12);
            stmt.setObject(24, (Object)fiche.getId(), -5);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            throw new UpdateToDataSourceException(String.format("Unable to update [%s] from table \"%s\"", fiche.toString(), this.tableName), (Throwable)e);
        }
        return fiche;
    }

    protected FicheAccueilBean fill(ResultSet rs) throws DataSourceException {
        FicheAccueilBean ficheAccueil = new FicheAccueilBean();
        try {
            ficheAccueil.setId(rs.getLong("ID_FICHEACCUEIL"));
            ficheAccueil.setTitle(rs.getString("TITRE"));
            ficheAccueil.setCode(rs.getString("CODE"));
            ficheAccueil.setCodeRubrique(rs.getString("CODE_RUBRIQUE"));
            ficheAccueil.setCodeRattachement(rs.getString("CODE_RATTACHEMENT"));
            ficheAccueil.setTitreEncadre(rs.getString("TITRE_ENCADRE"));
            ficheAccueil.setContenuEncadre(rs.getString("CONTENU_ENCADRE"));
            ficheAccueil.setMetaKeywords(rs.getString("META_KEYWORDS"));
            ficheAccueil.setMetaDescription(rs.getString("META_DESCRIPTION"));
            ficheAccueil.setTitreEncadre(rs.getString("TITRE_ENCADRE"));
            ficheAccueil.setContenuEncadre(rs.getString("CONTENU_ENCADRE"));
            ficheAccueil.setEncadreRecherche(rs.getString("ENCADRE_RECHERCHE"));
            ficheAccueil.setEncadreRechercheBis(rs.getString("ENCADRE_RECHERCHE_BIS"));
            ficheAccueil.setDateAlerte(rs.getDate("DATE_ALERTE"));
            ficheAccueil.setMessageAlerte(rs.getString("MESSAGE_ALERTE"));
            ficheAccueil.setDateCreation(new Date(rs.getTimestamp("DATE_CREATION").getTime()));
            ficheAccueil.setDateProposition(new Date(rs.getTimestamp("DATE_PROPOSITION").getTime()));
            ficheAccueil.setDateValidation(new Date(rs.getTimestamp("DATE_VALIDATION").getTime()));
            ficheAccueil.setDateModification(new Date(rs.getTimestamp("DATE_MODIFICATION").getTime()));
            ficheAccueil.setCodeRedacteur(rs.getString("CODE_REDACTEUR"));
            ficheAccueil.setCodeValidation(rs.getString("CODE_VALIDATION"));
            ficheAccueil.setLangue(rs.getString("LANGUE"));
            ficheAccueil.setEtatObjet(rs.getString("ETAT_OBJET"));
            ficheAccueil.setNbHits(rs.getLong("NB_HITS"));
            ficheAccueil.setDiffusionModeRestriction(rs.getString("DIFFUSION_MODE_RESTRICTION"));
            ficheAccueil.setDiffusionPublicVise(rs.getString("DIFFUSION_PUBLIC_VISE"));
            ficheAccueil.setDiffusionPublicViseRestriction(rs.getString("DIFFUSION_PUBLIC_VISE_RESTRICTION"));
        }
        catch (SQLException e) {
            throw new DataSourceException("An error occured trying to map resultset to object", (Throwable)e);
        }
        return ficheAccueil;
    }

    public List<FicheAccueilBean> select(FicheAccueil ficheAccueil, String code, String titre, String codeRattachement, String codeRubrique, String langue, String codeRedacteur, String etatObjet, String nombre, String ids) throws Exception {
        ClauseWhere where = new ClauseWhere();
        if (StringUtils.isNotEmpty((CharSequence)titre)) {
            where.and(ConditionHelper.like((String)"TITRE", (String)titre, (String)"%", (String)"%"));
        }
        if (StringUtils.isNotEmpty((CharSequence)codeRattachement)) {
            where.and(ConditionHelper.getConditionStructure((String)"CODE_RATTACHEMENT", (String)codeRattachement));
        }
        if (StringUtils.isNotEmpty((CharSequence)langue) && !"0000".equals(langue)) {
            where.and(ConditionHelper.egalVarchar((String)"T1.LANGUE", (String)langue));
        }
        if (StringUtils.isNotEmpty((CharSequence)etatObjet) && !"0000".equals(etatObjet)) {
            where.and(ConditionHelper.egalVarchar((String)"T1.ETAT_OBJET", (String)etatObjet));
        }
        if (StringUtils.isNotEmpty((CharSequence)codeRedacteur)) {
            where.and(ConditionHelper.egalVarchar((String)"CODE_REDACTEUR", (String)codeRedacteur));
        }
        if (StringUtils.isNotEmpty((CharSequence)ids) && !"0000".equals(ids)) {
            where.and(ConditionHelper.in((String)"ID_FICHEACCUEIL", (Collection)Chaine.getVecteurPointsVirgules((String)ids)));
        }
        if (StringUtils.isNotEmpty((CharSequence)code)) {
            where.and(ConditionHelper.egalVarchar((String)"T1.CODE", (String)code));
        }
        try (ContexteDao ctx = new ContexteDao();){
            RequeteSQL requeteSelect = RequeteSQLHelper.getRequeteGenerique((ClauseWhere)where, (OMContext)ctx, (FicheUniv)ficheAccueil, (String)codeRubrique);
            ClauseOrderBy orderBy = new ClauseOrderBy();
            orderBy.orderBy("T1.TITRE", ClauseOrderBy.SensDeTri.ASC);
            requeteSelect.orderBy(orderBy);
            ClauseLimit limite = LimitHelper.ajouterCriteresLimitesEtOptimisation((OMContext)ctx, (String)nombre);
            requeteSelect.limit(limite);
            List list = this.select(requeteSelect.formaterRequete());
            return list;
        }
    }
}

