/*
 * Decompiled with CFR 0.152.
 */
package com.univ.objetspartages.processus;

import com.jsbsoft.jtf.core.InfoBean;
import com.jsbsoft.jtf.database.OMContext;
import com.jsbsoft.jtf.exception.ErreurDonneeNonTrouve;
import com.univ.objetspartages.om.AutorisationBean;
import com.univ.objetspartages.om.FicheAccueil;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.Rubrique;
import com.univ.objetspartages.om.Structure;
import com.univ.objetspartages.processus.ControleurUniv;
import com.univ.objetspartages.processus.SaisieFiche;
import com.univ.utils.json.CamelCaseNamingStrategy;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.PropertyNamingStrategy;
import org.codehaus.jackson.map.SerializationConfig;

public class SaisieFicheAccueil
extends SaisieFiche {
    private final ObjectMapper mapper = new ObjectMapper();
    private FicheAccueil ficheAccueil = null;

    public SaisieFicheAccueil(InfoBean ciu) {
        super(ciu);
        this.mapper.configure(SerializationConfig.Feature.FAIL_ON_EMPTY_BEANS, false);
        this.mapper.setPropertyNamingStrategy((PropertyNamingStrategy)new CamelCaseNamingStrategy());
    }

    protected void preparerPRINCIPAL() throws Exception {
        this.ecranLogique = "PRINCIPAL";
        this.infoBean.set("ID", (Object)this.ficheAccueil.getIdFiche().toString());
        this.infoBean.set("ID_FICHEACCUEIL", (Object)this.ficheAccueil.getIdFiche().toString());
        this.infoBean.set("TITLE", (Object)this.ficheAccueil.getTitle());
        this.infoBean.set("CODE", (Object)this.ficheAccueil.getCode());
        this.infoBean.set("CODE_RUBRIQUE", (Object)this.ficheAccueil.getCodeRubrique());
        this.infoBean.set("LIBELLE_CODE_RUBRIQUE", (Object)Rubrique.renvoyerItemRubrique((String)this.ficheAccueil.getCodeRubrique()).getLibelleAffichable());
        this.infoBean.set("CODE_RATTACHEMENT", (Object)this.ficheAccueil.getCodeRattachement());
        this.infoBean.set("LIBELLE_CODE_RATTACHEMENT", (Object)Structure.renvoyerItemStructure((String)this.ficheAccueil.getCodeRattachement(), (String)this.ficheAccueil.getLangue()).getLibelleAffichable());
        this.infoBean.set("LIBELLE_AFFICHABLE", (Object)this.ficheAccueil.getLibelleAffichable());
        this.infoBean.set("SOUS_ONGLET", (Object)"PRINCIPAL");
        ControleurUniv.preparerPRINCIPAL((InfoBean)this.infoBean, (FicheUniv)this.ficheAccueil, (SaisieFiche)this);
    }

    protected void preparerRECHERCHE() throws Exception {
        this.ecranLogique = "RECHERCHE";
    }

    protected void traiterPRINCIPAL() throws Exception {
        if (this.infoBean.getEtatObjet().equals("CREATION")) {
            this.ficheAccueil.init();
        } else {
            this.ficheAccueil.setIdFiche(new Long(this.infoBean.getString("ID_FICHEACCUEIL")));
            this.ficheAccueil.retrieve();
        }
        if (this.action.equals("ENREGISTRER")) {
            this.alimenteDonneesCreation((FicheUniv)this.ficheAccueil, false);
            String title = (String)this.infoBean.get("TITLE", String.class);
            if (!StringUtils.isNotBlank((CharSequence)title)) {
                throw new ErreurDonneeNonTrouve("Pas bien, manque le titre");
            }
            this.ficheAccueil.setTitle(title);
            this.ficheAccueil.setCodeRattachement(this.infoBean.getString("CODE_RATTACHEMENT"));
            if (!this.infoBean.getString("CODE_RUBRIQUE").equals("0000")) {
                this.ficheAccueil.setCodeRubrique(this.infoBean.getString("CODE_RUBRIQUE"));
            } else {
                this.ficheAccueil.setCodeRubrique("");
            }
        }
        this.ecranLogique = ControleurUniv.traiterPRINCIPAL((InfoBean)this.infoBean, (FicheUniv)this.ficheAccueil, (SaisieFiche)this);
        if (this.ecranLogique.length() == 0) {
            this.etat = 2;
        }
    }

    protected boolean traiterAction() throws Exception {
        this.infoBean.set("CODE_OBJET", (Object)"0111");
        this.ficheAccueil = new FicheAccueil();
        this.ficheAccueil.setCtx((OMContext)this);
        this.ficheAccueil.init();
        AutorisationBean autorisations = (AutorisationBean)this.getGp().getSessionUtilisateur().getInfos().get("AUTORISATIONS");
        if (autorisations != null) {
            this.getDatas().put("AUTORISATIONS", autorisations);
        }
        this.traiterActionParDefaut((FicheUniv)this.ficheAccueil);
        this.infoBean.set("NOM_ONGLET", (Object)"accueil");
        return this.etat == 2;
    }
}

