/**
 * Copyright (C) 2015 Kosmos contact@kosmos.fr
 *
 * Projet: accueil
 * Version: 1.02.03
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kosmos.accueil.util;

import com.jsbsoft.jtf.core.ApplicationContextManager;
import com.kosmos.layout.Layout;
import com.kosmos.layout.exception.DefaultLayoutNotFoundException;
import com.kosmos.layout.exception.LayoutNotFoundException;
import com.kosmos.layout.service.ServiceLayout;
import com.univ.objetspartages.om.FicheAccueil;
import com.univ.objetspartages.om.Service;
import com.univ.utils.ContexteUniv;
import com.univ.utils.ContexteUtil;
import org.apache.commons.lang3.StringUtils;

public class AccueilJspHelper {

    private static ServiceLayout serviceLayout;
    private static final String ID_EXTENSION = "accueil";

    static {
        serviceLayout = (ServiceLayout) ApplicationContextManager.getBean("core", ServiceLayout.ID_BEAN);
    }

    public static String getIdExtension() {
        return ID_EXTENSION;
    }

    public static FicheAccueil getFicheCourante() {
        final ContexteUniv ctx = ContexteUtil.getContexteUniv();
        if (ctx.getFicheCourante() instanceof FicheAccueil) {
            return (FicheAccueil) ctx.getFicheCourante();
        }
        return null;
    }

    public static boolean isApercu() {
        return ContexteUtil.getContexteUniv().isApercu();
    }

    public static boolean isPageContextActive() {
        final FicheAccueil fiche = getFicheCourante();
        if(fiche != null) {
            try {
                final Layout layout = serviceLayout.getLayout(fiche);
                if (layout != null) {
                    return layout.hasContext();
                }
                return false;
            } catch (LayoutNotFoundException | DefaultLayoutNotFoundException e) {
                return false;
            }
        }
        return false;
    }
}
