/**
 * Copyright (C) 2015 Kosmos contact@kosmos.fr
 *
 * Projet: accueil
 * Version: 1.02.03
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kosmos.accueil.util;

import com.kportal.core.config.MessageHelper;
import com.kportal.core.config.PropertyHelper;
import com.kportal.extension.ExtensionHelper;
import com.kportal.extension.IExtension;
import com.kportal.extension.module.IModule;
import com.kportal.extension.module.ModuleHelper;

public class AccueilUtil {

    public static final String ID_EXTENSION = "accueil";

    public static IExtension getExtension() {
        return ExtensionHelper.getExtensionManager().getExtension(ID_EXTENSION);
    }

    public static String getProperty(String key) {
        return PropertyHelper.getProperty(ID_EXTENSION, key);
    }

    public static String getMessage(String key) {
        return MessageHelper.getMessage(ID_EXTENSION, key);
    }

    public static IModule getModule(String idBean) {
        return ModuleHelper.getModule(ID_EXTENSION, idBean);
    }
}
