/**
 * Copyright (C) 2015 Kosmos contact@kosmos.fr
 *
 * Projet: accueil
 * Version: 1.02.03
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.objetspartages.bean;

import com.kportal.cms.objetspartages.annotation.GetterAnnotation;
import com.kportal.cms.objetspartages.annotation.SetterAnnotation;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

import java.sql.Date;

public class FicheAccueilBean extends AbstractFicheBean {

    /**
     *
     */
    private static final long serialVersionUID = 4816888462707189079L;

    protected String title;

    protected Date dateArchivage;

    /** The diffusion public vise. */
    protected String diffusionPublicVise;

    /** The diffusion mode restriction. */
    protected String diffusionModeRestriction;

    /** The diffusion public vise restriction. */
    protected String diffusionPublicViseRestriction;

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Date getDateArchivage() {
        return dateArchivage;
    }

    public void setDateArchivage(Date dateArchivage) {
        this.dateArchivage = dateArchivage;
    }

    /**
     * Gets the contenu encadre.
     *
     * @return the contenuEncadre
     */
    @GetterAnnotation(isToolbox = true)
    public String getContenuEncadre() {
        return contenuEncadre;
    }

    /**
     * Sets the contenu encadre.
     *
     * @param contenuEncadre
     *         the contenuEncadre to set
     */
    @SetterAnnotation(isToolbox = true)
    public void setContenuEncadre(String contenuEncadre) {
        this.contenuEncadre = contenuEncadre;
    }

    @Override
    public String toString() {
        return ReflectionToStringBuilder.toString(this);
    }

    public String getDiffusionPublicVise() {
        return diffusionPublicVise;
    }

    public void setDiffusionPublicVise(String diffusionPublicVise) {
        this.diffusionPublicVise = diffusionPublicVise;
    }

    public String getDiffusionModeRestriction() {
        return diffusionModeRestriction;
    }

    public void setDiffusionModeRestriction(String diffusionModeRestriction) {
        this.diffusionModeRestriction = diffusionModeRestriction;
    }

    public String getDiffusionPublicViseRestriction() {
        return diffusionPublicViseRestriction;
    }

    public void setDiffusionPublicViseRestriction(String diffusionPublicViseRestriction) {
        this.diffusionPublicViseRestriction = diffusionPublicViseRestriction;
    }
}
