/**
 * Copyright (C) 2015 Kosmos contact@kosmos.fr
 *
 * Projet: accueil
 * Version: 1.02.03
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.objetspartages.misc;

import com.jsbsoft.jtf.core.InfoBean;
import com.jsbsoft.jtf.database.OMContext;
import com.jsbsoft.jtf.exception.ErreurApplicative;
import com.kportal.cms.objetspartages.Objetpartage;
import com.univ.objetspartages.om.AbstractRechercheExterne;
import com.univ.objetspartages.om.ReferentielObjets;
import com.univ.objetspartages.util.CritereRecherche;
import com.univ.utils.RechercheFicheHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.List;

import static com.univ.objetspartages.util.CritereRechercheUtil.getCritereTexteNonVideFormater;

public class RechercheFicheAccueil extends AbstractRechercheExterne {

    @Override
    public List<String> getCriteresRequete(String arg0, boolean arg1) {
        List<String> criteres = new ArrayList<>();
        if (arg0.equals("FICHEACCUEIL")) {
            criteres.add("TITRE");
        }
        return criteres;
    }

    @Override
    public boolean preparerRECHERCHE(InfoBean infoBean, OMContext ctx) throws Exception {
        boolean rechercheEffectuee = false;
        String objet = StringUtils.defaultString(infoBean.getString("OBJET"), "").toUpperCase();
        if (objet.equals("FICHEACCUEIL")) {
            rechercheEffectuee = true;
        }
        return rechercheEffectuee;
    }

    @Override
    public boolean traiterRECHERCHE(InfoBean infoBean, OMContext ctx) throws Exception {
        boolean rechercheEffectuee = false;
        final String objet = infoBean.getString("OBJET").toUpperCase();
        final List<CritereRecherche> criteres = new ArrayList<>();
        criteres.add(new CritereRecherche("OBJET", objet, StringUtils.EMPTY));
        final Objetpartage module = ReferentielObjets.getObjetByNom(objet);
        if (objet.equals("FICHEACCUEIL")) {
            CollectionUtils.addIgnoreNull(criteres, getCritereTexteNonVideFormater(infoBean, "TITRE"));
            if ("0".equals(module.getProperty("fiche.FICHEACCUEIL.recherche_vide")) && criteres.size() <= 1) {
                throw new ErreurApplicative(module.getMessage(ctx.getLocale(), "ST_RECHERCHE_SAISIR_UN_CRITERE"));
            }
            rechercheEffectuee = true;
            // attribut commun à toute les fiches
            criteres.addAll(getCritereDefaut(infoBean));
            infoBean.set(RechercheFicheHelper.ATTRIBUT_INFOBEAN_CRITERES, criteres);
            gestionAncienFront(infoBean, criteres);
        }
        return rechercheEffectuee;
    }
}
