/**
 * Copyright (C) 2015 Kosmos contact@kosmos.fr
 *
 * Projet: accueil
 * Version: 1.02.03
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.objetspartages.om;

import java.sql.Date;

import org.apache.commons.lang3.StringUtils;

import com.kportal.cms.objetspartages.annotation.FicheAnnotation;
import com.univ.objetspartages.bean.FicheAccueilBean;
import com.univ.objetspartages.dao.impl.FicheAccueilDAO;
import com.univ.utils.RequeteUtil;

@FicheAnnotation(isContenuDuplicable = false)
public class FicheAccueil extends AbstractFiche<FicheAccueilBean> implements FicheArchivable, DiffusionSelective {

    public int select(String code, String titre, String codeRattachement, String codeRubrique, String langue, String codeRedacteur, String etatObjet, String nombre, String ids)
            throws Exception {
        currentSelect = ((FicheAccueilDAO) commonDao).select(this, code, titre, codeRattachement, codeRubrique, langue, codeRedacteur, etatObjet, nombre, ids);
        currentSelectIt = currentSelect.iterator();
        return currentSelect.size();
    }

    @Override
    public void init() {
        super.init();
        persistenceBean.setLangue("0");
        persistenceBean.setDateArchivage(new Date(0));
        persistenceBean.setTitle("");
    }

    @Override
    public String getLibelleAffichable() {
        return persistenceBean.getTitle();
    }

    @Override
    public String getFullTextString() throws Exception {
        return "";
    }

    @Override
    public String getReferences() {
        return "";
    }

    @Override
    public int traiterRequete(String requete) throws Exception {
        // Recuperation des parametres de la requete
        String code = RequeteUtil.renvoyerParametre(requete, "CODE");
        String titre = RequeteUtil.renvoyerParametre(requete, "TITRE");
        String ids = RequeteUtil.renvoyerParametre(requete, "IDS");
        String nombre = RequeteUtil.renvoyerParametre(requete, "NOMBRE");
        String codeRubrique = RequeteUtil.renvoyerParametre(requete, "CODE_RUBRIQUE");
        String codeRattachement = RequeteUtil.renvoyerParametre(requete, "CODE_RATTACHEMENT");
        String langue = RequeteUtil.renvoyerParametre(requete, "LANGUE");
        String etatObjet = StringUtils.defaultIfBlank(RequeteUtil.renvoyerParametre(requete, "ETAT_OBJET"), EtatFiche.EN_LIGNE.toString());
        String codeRedacteur = RequeteUtil.renvoyerParametre(requete, "CODE_REDACTEUR");
        return select(code, titre, codeRattachement, codeRubrique, langue, codeRedacteur, etatObjet, nombre, ids);
    }

    public Long getId() {
        return persistenceBean.getId();
    }

    @Override
    public Date getDateArchivage() {
        return persistenceBean.getDateArchivage();
    }

    public String getTitle() {
        return persistenceBean.getTitle();
    }

    public void setTitle(String title) {
        persistenceBean.setTitle(title);
    }

    @Override
    public String getDiffusionModeRestriction() {
        return persistenceBean.getDiffusionModeRestriction();
    }

    @Override
    public String getDiffusionPublicVise() {
        return persistenceBean.getDiffusionPublicVise();
    }

    @Override
    public String getDiffusionPublicViseRestriction() {
        return persistenceBean.getDiffusionPublicViseRestriction();
    }

    @Override
    public void setDiffusionModeRestriction(String _diffusionModeRestriction) {
        persistenceBean.setDiffusionModeRestriction(_diffusionModeRestriction);
    }

    @Override
    public void setDiffusionPublicVise(String _diffusionPublicVise) {
        persistenceBean.setDiffusionPublicVise(_diffusionPublicVise);
    }

    @Override
    public void setDiffusionPublicViseRestriction(String _diffusionPublicViseRestriction) {
        persistenceBean.setDiffusionPublicViseRestriction(_diffusionPublicViseRestriction);
    }
}
