/**
 * Copyright (C) 2015 Kosmos contact@kosmos.fr
 *
 * Projet: accueil
 * Version: 1.02.03
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.objetspartages.processus;

import com.jsbsoft.jtf.core.InfoBean;
import com.jsbsoft.jtf.exception.ErreurDonneeNonTrouve;
import com.jsbsoft.jtf.session.SessionUtilisateur;
import com.univ.objetspartages.om.AutorisationBean;
import com.univ.objetspartages.om.FicheAccueil;
import com.univ.objetspartages.om.Rubrique;
import com.univ.objetspartages.om.Structure;
import com.univ.utils.json.CamelCaseNamingStrategy;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;

public class SaisieFicheAccueil extends SaisieFiche {

    /** The actualite. */
    private final ObjectMapper mapper = new ObjectMapper();
    private FicheAccueil ficheAccueil = null;

    public SaisieFicheAccueil(final InfoBean ciu) {
        super(ciu);
        mapper.configure(SerializationConfig.Feature.FAIL_ON_EMPTY_BEANS, false);
        mapper.setPropertyNamingStrategy(new CamelCaseNamingStrategy());
    }

    @Override
    protected void preparerPRINCIPAL() throws Exception {
        ecranLogique = ECRAN_PRINCIPAL;
        infoBean.set("ID", ficheAccueil.getIdFiche().toString());
        infoBean.set("ID_FICHEACCUEIL", ficheAccueil.getIdFiche().toString());
        infoBean.set("TITLE", ficheAccueil.getTitle());
        infoBean.set("CODE", ficheAccueil.getCode());
        infoBean.set("CODE_RUBRIQUE", ficheAccueil.getCodeRubrique());
        infoBean.set("LIBELLE_CODE_RUBRIQUE", Rubrique.renvoyerItemRubrique(ficheAccueil.getCodeRubrique()).getLibelleAffichable());
        infoBean.set("CODE_RATTACHEMENT", ficheAccueil.getCodeRattachement());
        infoBean.set("LIBELLE_CODE_RATTACHEMENT", Structure.renvoyerItemStructure(ficheAccueil.getCodeRattachement(), ficheAccueil.getLangue()).getLibelleAffichable());
        infoBean.set("LIBELLE_AFFICHABLE", ficheAccueil.getLibelleAffichable());
        infoBean.set("SOUS_ONGLET", "PRINCIPAL");
        ControleurUniv.preparerPRINCIPAL(infoBean, ficheAccueil, this);
    }

    @Override
    protected void preparerRECHERCHE() throws Exception {
        ecranLogique = ECRAN_RECHERCHE;
    }

    @Override
    protected void traiterPRINCIPAL() throws Exception {
        // chargement de l'objet
        if (infoBean.getEtatObjet().equals(InfoBean.ETAT_OBJET_CREATION)) {
            ficheAccueil.init();
        } else {
            ficheAccueil.setIdFiche(new Long(infoBean.getString("ID_FICHEACCUEIL")));
            ficheAccueil.retrieve();
        }
        // validation de l'ecran
        if (action.equals(InfoBean.ACTION_ENREGISTRER)) {
            alimenteDonneesCreation(ficheAccueil, false);
            final String title = infoBean.get("TITLE", String.class);
            if(StringUtils.isNotBlank(title)) {
                ficheAccueil.setTitle(title);
            } else {
                throw new ErreurDonneeNonTrouve("Pas bien, manque le titre");
            }
            ficheAccueil.setCodeRattachement(infoBean.getString("CODE_RATTACHEMENT"));
            if (!infoBean.getString("CODE_RUBRIQUE").equals("0000")) {
                ficheAccueil.setCodeRubrique(infoBean.getString("CODE_RUBRIQUE"));
            } else {
                ficheAccueil.setCodeRubrique(StringUtils.EMPTY);
            }
        }
        // appel au traitement general
        ecranLogique = ControleurUniv.traiterPRINCIPAL(infoBean, ficheAccueil, this);
        if (ecranLogique.length() == 0) {
            etat = FIN;
        }
    }

    @Override
    protected boolean traiterAction() throws Exception {
        infoBean.set("CODE_OBJET", "0111");
        // chargement de l'objet
        ficheAccueil = new FicheAccueil();
        ficheAccueil.setCtx(this);
        ficheAccueil.init();
        final AutorisationBean autorisations = (AutorisationBean) getGp().getSessionUtilisateur().getInfos().get(SessionUtilisateur.AUTORISATIONS);
        if (autorisations != null) {
            this.getDatas().put("AUTORISATIONS", autorisations);
        }
        traiterActionParDefaut(ficheAccueil);
        infoBean.set("NOM_ONGLET", "accueil");
        // on continue si on n'est pas a la FIN !!!
        return (etat == FIN);
    }
}
