/**
 * Copyright (C) 2015 Kosmos contact@kosmos.fr
 *
 * Projet: actualite
 * Version: 1.02.07
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.objetspartages.bean;

import java.io.Serializable;
import java.sql.Date;

import com.kportal.cms.objetspartages.annotation.GetterAnnotation;
import com.kportal.cms.objetspartages.annotation.SetterAnnotation;

// TODO: Auto-generated Javadoc
/**
 * Classe d'acces aux donnees pour actualite.
 */
public class ActualiteBean implements Serializable {

	private static final long serialVersionUID = 4803968170869317538L;

	/** The id actualite. */
	protected Long idActualite = null;

	/** The titre. */
	protected String titre = null;

	/** The resume. */
	protected String resume = null;

	/** The date evenement. */
	protected Date dateEvenement = null;

	/** The lieu. */
	protected String lieu = null;

	/** The id plan acces. */
	protected Long idPlanAcces = null;

	/** The type evenement. */
	protected String typeEvenement = null;

	/** The thematique. */
	protected String thematique = null;

	/** The description. */
	protected String description = null;

	/** The responsable evenement. */
	protected String responsableEvenement = null;

	/** The email responsable evenement. */
	protected String emailResponsableEvenement = null;

	/** The rattachement bandeau. */
	protected String rattachementBandeau = null;

	/** The date suppression. */
	protected Date dateSuppression = null;

	/** The complement date. */
	protected String complementDate = null;

	/** The site evenement. */
	protected String siteEvenement = null;

	/** The date fin evenement. */
	protected Date dateFinEvenement = null;

	/** The date archivage. */
	protected Date dateArchivage = null;

	/** The id vignette. */
	protected Long idVignette = null;

	/** The date declenchement. */
	protected Date dateDeclenchement = null;

	/** The partenaires. */
	protected String partenaires = null;

	/** The insertion agenda. */
	protected String insertionAgenda = null;

	/** The code. */
	protected String code = null;

	/** The code rubrique. */
	protected String codeRubrique = null;

	/** The code rattachement. */
	protected String codeRattachement = null;

	/** The meta keywords. */
	protected String metaKeywords = null;

	/** The meta description. */
	protected String metaDescription = null;

	/** The titre encadre. */
	protected String titreEncadre = null;

	/** The contenu encadre. */
	protected String contenuEncadre = null;

	/** The encadre recherche. */
	protected String encadreRecherche = null;

	/** The encadre recherche bis. */
	protected String encadreRechercheBis = null;

	/** The date alerte. */
	protected Date dateAlerte = null;

	/** The message alerte. */
	protected String messageAlerte = null;

	/** The date creation. */
	protected Date dateCreation = null;

	/** The date proposition. */
	protected Date dateProposition = null;

	/** The date validation. */
	protected Date dateValidation = null;

	/** The date modification. */
	protected Date dateModification = null;

	/** The code redacteur. */
	protected String codeRedacteur = null;

	/** The code validation. */
	protected String codeValidation = null;

	/** The langue. */
	protected String langue = null;

	/** The etat objet. */
	protected String etatObjet = null;

	/** The nb hits. */
	protected Long nbHits = null;

	/** The diffusion public vise. */
	protected String diffusionPublicVise = null;

	/** The diffusion mode restriction. */
	protected String diffusionModeRestriction = null;

	/** The diffusion public vise restriction. */
	protected String diffusionPublicViseRestriction = null;

	/**
	 * Inits the.
	 * 
	 * @param bean
	 *            the bean
	 */
	public void init(ActualiteBean bean) {
		this.idActualite = bean.idActualite;
		this.titre = bean.titre;
		this.resume = bean.resume;
		this.dateEvenement = bean.dateEvenement;
		this.lieu = bean.lieu;
		this.idPlanAcces = bean.idPlanAcces;
		this.typeEvenement = bean.typeEvenement;
		this.thematique = bean.thematique;
		this.description = bean.description;
		this.responsableEvenement = bean.responsableEvenement;
		this.emailResponsableEvenement = bean.emailResponsableEvenement;
		this.rattachementBandeau = bean.rattachementBandeau;
		this.dateSuppression = bean.dateSuppression;
		this.complementDate = bean.complementDate;
		this.siteEvenement = bean.siteEvenement;
		this.dateFinEvenement = bean.dateFinEvenement;
		this.dateArchivage = bean.dateArchivage;
		this.idVignette = bean.idVignette;
		this.dateDeclenchement = bean.dateDeclenchement;
		this.partenaires = bean.partenaires;
		this.insertionAgenda = bean.insertionAgenda;
		this.code = bean.code;
		this.codeRubrique = bean.codeRubrique;
		this.codeRattachement = bean.codeRattachement;
		this.metaKeywords = bean.metaKeywords;
		this.metaDescription = bean.metaDescription;
		this.titreEncadre = bean.titreEncadre;
		this.contenuEncadre = bean.contenuEncadre;
		this.encadreRecherche = bean.encadreRecherche;
		this.encadreRechercheBis = bean.encadreRechercheBis;
		this.dateAlerte = bean.dateAlerte;
		this.messageAlerte = bean.messageAlerte;
		this.dateCreation = bean.dateCreation;
		this.dateProposition = bean.dateProposition;
		this.dateValidation = bean.dateValidation;
		this.dateModification = bean.dateModification;
		this.codeRedacteur = bean.codeRedacteur;
		this.codeValidation = bean.codeValidation;
		this.langue = bean.langue;
		this.etatObjet = bean.etatObjet;
		this.nbHits = bean.nbHits;
		this.diffusionPublicVise = bean.diffusionPublicVise;
		this.diffusionModeRestriction = bean.diffusionModeRestriction;
		this.diffusionPublicViseRestriction = bean.diffusionPublicViseRestriction;
	}

	/**
	 * Instantiates a new actualite bean.
	 */
	public ActualiteBean() {
		super();
		// TODO Auto-generated constructor stub
	}

	/**
	 * Gets the code.
	 * 
	 * @return the code
	 */
	public String getCode() {
		return code;
	}

	/**
	 * Sets the code.
	 * 
	 * @param code
	 *            the code to set
	 */
	public void setCode(String code) {
		this.code = code;
	}

	/**
	 * Gets the code rattachement.
	 * 
	 * @return the codeRattachement
	 */
	public String getCodeRattachement() {
		return codeRattachement;
	}

	/**
	 * Sets the code rattachement.
	 * 
	 * @param codeRattachement
	 *            the codeRattachement to set
	 */
	public void setCodeRattachement(String codeRattachement) {
		this.codeRattachement = codeRattachement;
	}

	/**
	 * Gets the code redacteur.
	 * 
	 * @return the codeRedacteur
	 */
	public String getCodeRedacteur() {
		return codeRedacteur;
	}

	/**
	 * Sets the code redacteur.
	 * 
	 * @param codeRedacteur
	 *            the codeRedacteur to set
	 */
	public void setCodeRedacteur(String codeRedacteur) {
		this.codeRedacteur = codeRedacteur;
	}

	/**
	 * Gets the code rubrique.
	 * 
	 * @return the codeRubrique
	 */
	public String getCodeRubrique() {
		return codeRubrique;
	}

	/**
	 * Sets the code rubrique.
	 * 
	 * @param codeRubrique
	 *            the codeRubrique to set
	 */
	public void setCodeRubrique(String codeRubrique) {
		this.codeRubrique = codeRubrique;
	}

	/**
	 * Gets the code validation.
	 * 
	 * @return the codeValidation
	 */
	public String getCodeValidation() {
		return codeValidation;
	}

	/**
	 * Sets the code validation.
	 * 
	 * @param codeValidation
	 *            the codeValidation to set
	 */
	public void setCodeValidation(String codeValidation) {
		this.codeValidation = codeValidation;
	}

	/**
	 * Gets the complement date.
	 * 
	 * @return the complementDate
	 */
	@GetterAnnotation(isToolbox = true)
	public String getComplementDate() {
		return complementDate;
	}

	/**
	 * Sets the complement date.
	 * 
	 * @param complementDate
	 *            the complementDate to set
	 */
	@SetterAnnotation(isToolbox = true)
	public void setComplementDate(String complementDate) {
		this.complementDate = complementDate;
	}

	/**
	 * Gets the contenu encadre.
	 * 
	 * @return the contenuEncadre
	 */
	@GetterAnnotation(isToolbox = true)
	public String getContenuEncadre() {
		return contenuEncadre;
	}

	/**
	 * Sets the contenu encadre.
	 * 
	 * @param contenuEncadre
	 *            the contenuEncadre to set
	 */
	@SetterAnnotation(isToolbox = true)
	public void setContenuEncadre(String contenuEncadre) {
		this.contenuEncadre = contenuEncadre;
	}

	/**
	 * Gets the date alerte.
	 * 
	 * @return the dateAlerte
	 */
	public Date getDateAlerte() {
		return dateAlerte;
	}

	/**
	 * Sets the date alerte.
	 * 
	 * @param dateAlerte
	 *            the dateAlerte to set
	 */
	public void setDateAlerte(Date dateAlerte) {
		this.dateAlerte = dateAlerte;
	}

	/**
	 * Gets the date archivage.
	 * 
	 * @return the dateArchivage
	 */
	public Date getDateArchivage() {
		return dateArchivage;
	}

	/**
	 * Sets the date archivage.
	 * 
	 * @param dateArchivage
	 *            the dateArchivage to set
	 */
	public void setDateArchivage(Date dateArchivage) {
		this.dateArchivage = dateArchivage;
	}

	/**
	 * Gets the date creation.
	 * 
	 * @return the dateCreation
	 */
	public Date getDateCreation() {
		return dateCreation;
	}

	/**
	 * Sets the date creation.
	 * 
	 * @param dateCreation
	 *            the dateCreation to set
	 */
	public void setDateCreation(Date dateCreation) {
		this.dateCreation = dateCreation;
	}

	/**
	 * Gets the date declenchement.
	 * 
	 * @return the dateDeclenchement
	 */
	public Date getDateDeclenchement() {
		return dateDeclenchement;
	}

	/**
	 * Sets the date declenchement.
	 * 
	 * @param dateDeclenchement
	 *            the dateDeclenchement to set
	 */
	public void setDateDeclenchement(Date dateDeclenchement) {
		this.dateDeclenchement = dateDeclenchement;
	}

	/**
	 * Gets the date evenement.
	 * 
	 * @return the dateEvenement
	 */
	public Date getDateEvenement() {
		return dateEvenement;
	}

	/**
	 * Sets the date evenement.
	 * 
	 * @param dateEvenement
	 *            the dateEvenement to set
	 */
	public void setDateEvenement(Date dateEvenement) {
		this.dateEvenement = dateEvenement;
	}

	/**
	 * Gets the date fin evenement.
	 * 
	 * @return the dateFinEvenement
	 */
	public Date getDateFinEvenement() {
		return dateFinEvenement;
	}

	/**
	 * Sets the date fin evenement.
	 * 
	 * @param dateFinEvenement
	 *            the dateFinEvenement to set
	 */
	public void setDateFinEvenement(Date dateFinEvenement) {
		this.dateFinEvenement = dateFinEvenement;
	}

	/**
	 * Gets the date modification.
	 * 
	 * @return the dateModification
	 */
	public Date getDateModification() {
		return dateModification;
	}

	/**
	 * Sets the date modification.
	 * 
	 * @param dateModification
	 *            the dateModification to set
	 */
	public void setDateModification(Date dateModification) {
		this.dateModification = dateModification;
	}

	/**
	 * Gets the date proposition.
	 * 
	 * @return the dateProposition
	 */
	public Date getDateProposition() {
		return dateProposition;
	}

	/**
	 * Sets the date proposition.
	 * 
	 * @param dateProposition
	 *            the dateProposition to set
	 */
	public void setDateProposition(Date dateProposition) {
		this.dateProposition = dateProposition;
	}

	/**
	 * Gets the date suppression.
	 * 
	 * @return the dateSuppression
	 */
	public Date getDateSuppression() {
		return dateSuppression;
	}

	/**
	 * Sets the date suppression.
	 * 
	 * @param dateSuppression
	 *            the dateSuppression to set
	 */
	public void setDateSuppression(Date dateSuppression) {
		this.dateSuppression = dateSuppression;
	}

	/**
	 * Gets the date validation.
	 * 
	 * @return the dateValidation
	 */
	public Date getDateValidation() {
		return dateValidation;
	}

	/**
	 * Sets the date validation.
	 * 
	 * @param dateValidation
	 *            the dateValidation to set
	 */
	public void setDateValidation(Date dateValidation) {
		this.dateValidation = dateValidation;
	}

	/**
	 * Gets the description.
	 * 
	 * @return the description
	 */
	@GetterAnnotation(isToolbox = true)
	public String getDescription() {
		return description;
	}

	/**
	 * Sets the description.
	 * 
	 * @param description
	 *            the description to set
	 */
	@SetterAnnotation(isToolbox = true)
	public void setDescription(String description) {
		this.description = description;
	}

	/**
	 * Gets the diffusion mode restriction.
	 * 
	 * @return the diffusionModeRestriction
	 */
	public String getDiffusionModeRestriction() {
		return diffusionModeRestriction;
	}

	/**
	 * Sets the diffusion mode restriction.
	 * 
	 * @param diffusionModeRestriction
	 *            the diffusionModeRestriction to set
	 */
	public void setDiffusionModeRestriction(String diffusionModeRestriction) {
		this.diffusionModeRestriction = diffusionModeRestriction;
	}

	/**
	 * Gets the diffusion public vise.
	 * 
	 * @return the diffusionPublicVise
	 */
	public String getDiffusionPublicVise() {
		return diffusionPublicVise;
	}

	/**
	 * Sets the diffusion public vise.
	 * 
	 * @param diffusionPublicVise
	 *            the diffusionPublicVise to set
	 */
	public void setDiffusionPublicVise(String diffusionPublicVise) {
		this.diffusionPublicVise = diffusionPublicVise;
	}

	/**
	 * Gets the diffusion public vise restriction.
	 * 
	 * @return the diffusionPublicViseRestriction
	 */
	public String getDiffusionPublicViseRestriction() {
		return diffusionPublicViseRestriction;
	}

	/**
	 * Sets the diffusion public vise restriction.
	 * 
	 * @param diffusionPublicViseRestriction
	 *            the diffusionPublicViseRestriction to set
	 */
	public void setDiffusionPublicViseRestriction(String diffusionPublicViseRestriction) {
		this.diffusionPublicViseRestriction = diffusionPublicViseRestriction;
	}

	/**
	 * Gets the email responsable evenement.
	 * 
	 * @return the emailResponsableEvenement
	 */
	public String getEmailResponsableEvenement() {
		return emailResponsableEvenement;
	}

	/**
	 * Sets the email responsable evenement.
	 * 
	 * @param emailResponsableEvenement
	 *            the emailResponsableEvenement to set
	 */
	public void setEmailResponsableEvenement(String emailResponsableEvenement) {
		this.emailResponsableEvenement = emailResponsableEvenement;
	}

	/**
	 * Gets the encadre recherche.
	 * 
	 * @return the encadreRecherche
	 */
	public String getEncadreRecherche() {
		return encadreRecherche;
	}

	/**
	 * Sets the encadre recherche.
	 * 
	 * @param encadreRecherche
	 *            the encadreRecherche to set
	 */
	public void setEncadreRecherche(String encadreRecherche) {
		this.encadreRecherche = encadreRecherche;
	}

	/**
	 * Gets the encadre recherche bis.
	 * 
	 * @return the encadreRechercheBis
	 */
	public String getEncadreRechercheBis() {
		return encadreRechercheBis;
	}

	/**
	 * Sets the encadre recherche bis.
	 * 
	 * @param encadreRechercheBis
	 *            the encadreRechercheBis to set
	 */
	public void setEncadreRechercheBis(String encadreRechercheBis) {
		this.encadreRechercheBis = encadreRechercheBis;
	}

	/**
	 * Gets the etat objet.
	 * 
	 * @return the etatObjet
	 */
	public String getEtatObjet() {
		return etatObjet;
	}

	/**
	 * Sets the etat objet.
	 * 
	 * @param etatObjet
	 *            the etatObjet to set
	 */
	public void setEtatObjet(String etatObjet) {
		this.etatObjet = etatObjet;
	}

	/**
	 * Gets the id actualite.
	 * 
	 * @return the idActualite
	 */
	public Long getIdActualite() {
		return idActualite;
	}

	/**
	 * Sets the id actualite.
	 * 
	 * @param idActualite
	 *            the idActualite to set
	 */
	public void setIdActualite(Long idActualite) {
		this.idActualite = idActualite;
	}

	/**
	 * Gets the id plan acces.
	 * 
	 * @return the idPlanAcces
	 */
	@GetterAnnotation(isIdMedia = true)
	public Long getIdPlanAcces() {
		return idPlanAcces;
	}

	/**
	 * Sets the id plan acces.
	 * 
	 * @param idPlanAcces
	 *            the idPlanAcces to set
	 */
	public void setIdPlanAcces(Long idPlanAcces) {
		this.idPlanAcces = idPlanAcces;
	}

	/**
	 * Gets the id vignette.
	 * 
	 * @return the idVignette
	 */
	public Long getIdVignette() {
		return idVignette;
	}

	/**
	 * Sets the id vignette.
	 * 
	 * @param idVignette
	 *            the idVignette to set
	 */
	public void setIdVignette(Long idVignette) {
		this.idVignette = idVignette;
	}

	/**
	 * Gets the insertion agenda.
	 * 
	 * @return the insertionAgenda
	 */
	public String getInsertionAgenda() {
		return insertionAgenda;
	}

	/**
	 * Sets the insertion agenda.
	 * 
	 * @param insertionAgenda
	 *            the insertionAgenda to set
	 */
	public void setInsertionAgenda(String insertionAgenda) {
		this.insertionAgenda = insertionAgenda;
	}

	/**
	 * Gets the langue.
	 * 
	 * @return the langue
	 */
	public String getLangue() {
		return langue;
	}

	/**
	 * Sets the langue.
	 * 
	 * @param langue
	 *            the langue to set
	 */
	public void setLangue(String langue) {
		this.langue = langue;
	}

	/**
	 * Gets the lieu.
	 * 
	 * @return the lieu
	 */
	@GetterAnnotation(isToolbox = true)
	public String getLieu() {
		return lieu;
	}

	/**
	 * Sets the lieu.
	 * 
	 * @param lieu
	 *            the lieu to set
	 */
	@SetterAnnotation(isToolbox = true)
	public void setLieu(String lieu) {
		this.lieu = lieu;
	}

	/**
	 * Gets the message alerte.
	 * 
	 * @return the messageAlerte
	 */
	public String getMessageAlerte() {
		return messageAlerte;
	}

	/**
	 * Sets the message alerte.
	 * 
	 * @param messageAlerte
	 *            the messageAlerte to set
	 */
	public void setMessageAlerte(String messageAlerte) {
		this.messageAlerte = messageAlerte;
	}

	/**
	 * Gets the meta description.
	 * 
	 * @return the metaDescription
	 */
	public String getMetaDescription() {
		return metaDescription;
	}

	/**
	 * Sets the meta description.
	 * 
	 * @param metaDescription
	 *            the metaDescription to set
	 */
	public void setMetaDescription(String metaDescription) {
		this.metaDescription = metaDescription;
	}

	/**
	 * Gets the meta keywords.
	 * 
	 * @return the metaKeywords
	 */
	public String getMetaKeywords() {
		return metaKeywords;
	}

	/**
	 * Sets the meta keywords.
	 * 
	 * @param metaKeywords
	 *            the metaKeywords to set
	 */
	public void setMetaKeywords(String metaKeywords) {
		this.metaKeywords = metaKeywords;
	}

	/**
	 * Gets the nb hits.
	 * 
	 * @return the nbHits
	 */
	public Long getNbHits() {
		return nbHits;
	}

	/**
	 * Sets the nb hits.
	 * 
	 * @param nbHits
	 *            the nbHits to set
	 */
	public void setNbHits(Long nbHits) {
		this.nbHits = nbHits;
	}

	/**
	 * Gets the partenaires.
	 * 
	 * @return the partenaires
	 */
	@GetterAnnotation(isToolbox = true)
	public String getPartenaires() {
		return partenaires;
	}

	/**
	 * Sets the partenaires.
	 * 
	 * @param partenaires
	 *            the partenaires to set
	 */
	@SetterAnnotation(isToolbox = true)
	public void setPartenaires(String partenaires) {
		this.partenaires = partenaires;
	}

	/**
	 * Gets the rattachement bandeau.
	 * 
	 * @return the rattachementBandeau
	 */
	public String getRattachementBandeau() {
		return rattachementBandeau;
	}

	/**
	 * Sets the rattachement bandeau.
	 * 
	 * @param rattachementBandeau
	 *            the rattachementBandeau to set
	 */
	public void setRattachementBandeau(String rattachementBandeau) {
		this.rattachementBandeau = rattachementBandeau;
	}

	/**
	 * Gets the responsable evenement.
	 * 
	 * @return the responsableEvenement
	 */
	public String getResponsableEvenement() {
		return responsableEvenement;
	}

	/**
	 * Sets the responsable evenement.
	 * 
	 * @param responsableEvenement
	 *            the responsableEvenement to set
	 */
	public void setResponsableEvenement(String responsableEvenement) {
		this.responsableEvenement = responsableEvenement;
	}

	/**
	 * Gets the resume.
	 * 
	 * @return the resume
	 */
	public String getResume() {
		return resume;
	}

	/**
	 * Sets the resume.
	 * 
	 * @param resume
	 *            the resume to set
	 */
	public void setResume(String resume) {
		this.resume = resume;
	}

	/**
	 * Gets the site evenement.
	 * 
	 * @return the siteEvenement
	 */
	public String getSiteEvenement() {
		return siteEvenement;
	}

	/**
	 * Sets the site evenement.
	 * 
	 * @param siteEvenement
	 *            the siteEvenement to set
	 */
	public void setSiteEvenement(String siteEvenement) {
		this.siteEvenement = siteEvenement;
	}

	/**
	 * Gets the thematique.
	 * 
	 * @return the thematique
	 */
	public String getThematique() {
		return thematique;
	}

	/**
	 * Sets the thematique.
	 * 
	 * @param thematique
	 *            the thematique to set
	 */
	public void setThematique(String thematique) {
		this.thematique = thematique;
	}

	/**
	 * Gets the titre.
	 * 
	 * @return the titre
	 */
	public String getTitre() {
		return titre;
	}

	/**
	 * Sets the titre.
	 * 
	 * @param titre
	 *            the titre to set
	 */
	public void setTitre(String titre) {
		this.titre = titre;
	}

	/**
	 * Gets the titre encadre.
	 * 
	 * @return the titreEncadre
	 */
	public String getTitreEncadre() {
		return titreEncadre;
	}

	/**
	 * Sets the titre encadre.
	 * 
	 * @param titreEncadre
	 *            the titreEncadre to set
	 */
	public void setTitreEncadre(String titreEncadre) {
		this.titreEncadre = titreEncadre;
	}

	/**
	 * Gets the type evenement.
	 * 
	 * @return the typeEvenement
	 */
	public String getTypeEvenement() {
		return typeEvenement;
	}

	/**
	 * Sets the type evenement.
	 * 
	 * @param typeEvenement
	 *            the typeEvenement to set
	 */
	public void setTypeEvenement(String typeEvenement) {
		this.typeEvenement = typeEvenement;
	}
}
