/**
 * Copyright (C) 2015 Kosmos contact@kosmos.fr
 *
 * Projet: actualite
 * Version: 1.02.07
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.objetspartages.sgbd;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Types;

import com.jsbsoft.jtf.database.OMContext;
import com.univ.objetspartages.bean.ActualiteBean;

// TODO: Auto-generated Javadoc
/**
 * Classe d'acces aux donnees pour actualite.
 */
public class ActualiteDB extends ActualiteBean {

	/**
	 *
	 */
	private static final long serialVersionUID = 646758875291777768L;

	/** The ctx. */
	protected transient OMContext ctx = null;

	/** The rs. */
	private transient ResultSet rs = null;

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return toString(".");
	}

	/**
	 * To string.
	 *
	 * @param aSeparator
	 *            the a separator
	 *
	 * @return the string
	 */
	public String toString(final String aSeparator) {
		return getIdActualite() + aSeparator + getTitre() + aSeparator + getResume() + aSeparator + getDateEvenement() + aSeparator + getLieu() + aSeparator + getIdPlanAcces() + aSeparator + getTypeEvenement() + aSeparator + getThematique() + aSeparator + getDescription() + aSeparator + getResponsableEvenement() + aSeparator + getEmailResponsableEvenement() + aSeparator + getRattachementBandeau() + aSeparator + getDateSuppression() + aSeparator + getComplementDate() + aSeparator + getSiteEvenement() + aSeparator + getDateFinEvenement() + aSeparator + getDateArchivage() + aSeparator + getIdVignette() + aSeparator + getDateDeclenchement() + aSeparator + getPartenaires() + aSeparator + getInsertionAgenda() + aSeparator + getCode() + aSeparator + getCodeRubrique() + aSeparator + getCodeRattachement() + aSeparator + getMetaKeywords() + aSeparator + getMetaDescription() + aSeparator + getTitreEncadre() + aSeparator + getContenuEncadre() + aSeparator + getEncadreRecherche() + aSeparator + getEncadreRechercheBis() + aSeparator + getDateAlerte() + aSeparator + getMessageAlerte() + aSeparator + getDateCreation() + aSeparator + getDateProposition() + aSeparator + getDateValidation() + aSeparator + getDateModification() + aSeparator + getCodeRedacteur() + aSeparator + getCodeValidation() + aSeparator + getLangue() + aSeparator + getEtatObjet() + aSeparator + getNbHits() + aSeparator + getDiffusionPublicVise() + aSeparator + getDiffusionModeRestriction() + aSeparator + getDiffusionPublicViseRestriction();
	}

	/**
	 * Sets the ctx.
	 *
	 * @param _ctx
	 *            the new ctx
	 */
	public void setCtx(final OMContext _ctx) {
		ctx = _ctx;
	}

	/**
	 * Gets the connection.
	 *
	 * @return the connection
	 */
	private Connection getConnection() {
		return ctx.getConnection();
	}

	/**
	 * Adds the.
	 *
	 * @throws Exception
	 *             the exception
	 */
	public void add() throws Exception {
		PreparedStatement stmt = null;
		ResultSet rs = null;
		try {
			stmt = getConnection().prepareStatement("insert into ACTUALITE ( ID_ACTUALITE , TITRE , RESUME , DATE_EVENEMENT , LIEU , ID_PLAN_ACCES , TYPE_EVENEMENT , THEMATIQUE , DESCRIPTION , RESPONSABLE_EVENEMENT , EMAIL_RESPONSABLE_EVENEMENT , RATTACHEMENT_BANDEAU , DATE_SUPPRESSION , COMPLEMENT_DATE , SITE_EVENEMENT , DATE_FIN_EVENEMENT , DATE_ARCHIVAGE , ID_VIGNETTE , DATE_DECLENCHEMENT , PARTENAIRES , INSERTION_AGENDA , CODE , CODE_RUBRIQUE , CODE_RATTACHEMENT , META_KEYWORDS , META_DESCRIPTION , TITRE_ENCADRE , CONTENU_ENCADRE , ENCADRE_RECHERCHE , ENCADRE_RECHERCHE_BIS , DATE_ALERTE , MESSAGE_ALERTE , DATE_CREATION , DATE_PROPOSITION , DATE_VALIDATION , DATE_MODIFICATION , CODE_REDACTEUR , CODE_VALIDATION , LANGUE , ETAT_OBJET , NB_HITS , DIFFUSION_PUBLIC_VISE , DIFFUSION_MODE_RESTRICTION , DIFFUSION_PUBLIC_VISE_RESTRICTION) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", Statement.RETURN_GENERATED_KEYS);
			stmt.setObject(1, getIdActualite(), Types.BIGINT);
			stmt.setObject(2, getTitre(), Types.LONGVARCHAR);
			stmt.setObject(3, getResume(), Types.LONGVARCHAR);
			stmt.setObject(4, getDateEvenement(), Types.DATE);
			stmt.setObject(5, getLieu(), Types.LONGVARCHAR);
			stmt.setObject(6, getIdPlanAcces(), Types.BIGINT);
			stmt.setObject(7, getTypeEvenement(), Types.VARCHAR);
			stmt.setObject(8, getThematique(), Types.VARCHAR);
			stmt.setObject(9, getDescription(), Types.LONGVARCHAR);
			stmt.setObject(10, getResponsableEvenement(), Types.LONGVARCHAR);
			stmt.setObject(11, getEmailResponsableEvenement(), Types.LONGVARCHAR);
			stmt.setObject(12, getRattachementBandeau(), Types.VARCHAR);
			stmt.setObject(13, getDateSuppression(), Types.DATE);
			stmt.setObject(14, getComplementDate(), Types.LONGVARCHAR);
			stmt.setObject(15, getSiteEvenement(), Types.VARCHAR);
			stmt.setObject(16, getDateFinEvenement(), Types.DATE);
			stmt.setObject(17, getDateArchivage(), Types.DATE);
			stmt.setObject(18, getIdVignette(), Types.BIGINT);
			stmt.setObject(19, getDateDeclenchement(), Types.DATE);
			stmt.setObject(20, getPartenaires(), Types.LONGVARCHAR);
			stmt.setObject(21, getInsertionAgenda(), Types.VARCHAR);
			stmt.setObject(22, getCode(), Types.VARCHAR);
			stmt.setObject(23, getCodeRubrique(), Types.VARCHAR);
			stmt.setObject(24, getCodeRattachement(), Types.VARCHAR);
			stmt.setObject(25, getMetaKeywords(), Types.LONGVARCHAR);
			stmt.setObject(26, getMetaDescription(), Types.LONGVARCHAR);
			stmt.setObject(27, getTitreEncadre(), Types.VARCHAR);
			stmt.setObject(28, getContenuEncadre(), Types.LONGVARCHAR);
			stmt.setObject(29, getEncadreRecherche(), Types.VARCHAR);
			stmt.setObject(30, getEncadreRechercheBis(), Types.VARCHAR);
			stmt.setObject(31, getDateAlerte(), Types.DATE);
			stmt.setObject(32, getMessageAlerte(), Types.LONGVARCHAR);
			stmt.setObject(33, getDateCreation(), Types.TIMESTAMP);
			stmt.setObject(34, getDateProposition(), Types.TIMESTAMP);
			stmt.setObject(35, getDateValidation(), Types.TIMESTAMP);
			stmt.setObject(36, getDateModification(), Types.TIMESTAMP);
			stmt.setObject(37, getCodeRedacteur(), Types.VARCHAR);
			stmt.setObject(38, getCodeValidation(), Types.VARCHAR);
			stmt.setObject(39, getLangue(), Types.VARCHAR);
			stmt.setObject(40, getEtatObjet(), Types.VARCHAR);
			stmt.setObject(41, getNbHits(), Types.BIGINT);
			stmt.setObject(42, getDiffusionPublicVise(), Types.VARCHAR);
			stmt.setObject(43, getDiffusionModeRestriction(), Types.VARCHAR);
			stmt.setObject(44, getDiffusionPublicViseRestriction(), Types.VARCHAR);
			final int rowsAffected = stmt.executeUpdate();
			if (rowsAffected == 0) {
				throw new Exception("METHOD_AFFCTD_NOROWS");
			} else if (rowsAffected > 1) {
				throw new Exception("METHOD_AFFCTD_MULTROWS");
			}
			rs = stmt.getGeneratedKeys();
			rs.next();
			setIdActualite(rs.getLong(1));
		} catch (final SQLException e) {
			throw new Exception("ERROR_IN_METHOD add()", e);
		} finally {
			if (rs != null) {
				rs.close();
			}
			if (stmt != null) {
				stmt.close();
			}
		}
	}

	/**
	 * Delete.
	 *
	 * @throws Exception
	 *             the exception
	 */
	public void delete() throws Exception {
		PreparedStatement stmt = null;
		try {
			stmt = getConnection().prepareStatement("delete from ACTUALITE " + "where ID_ACTUALITE = ?");
			// put parameters into statement
			stmt.setObject(1, getIdActualite(), Types.BIGINT);
			final int rowsAffected = stmt.executeUpdate();
			if (rowsAffected == 0) {
				throw new Exception("METHOD_AFFCTD_NOROWS");
			} else if (rowsAffected > 1) {
				throw new Exception("METHOD_AFFCTD_MULTROWS");
			}
		} catch (final SQLException e) {
			throw new Exception("ERROR_IN_METHOD delete()", e);
		} finally {
			if (stmt != null) {
				stmt.close();
			}
		}
	}

	/**
	 * Gets the sQL base query.
	 *
	 * @return the sQL base query
	 */
	public String getSQLBaseQuery() {
		return "select distinct T1.ID_ACTUALITE, T1.TITRE, T1.RESUME, T1.DATE_EVENEMENT, T1.LIEU, T1.ID_PLAN_ACCES, T1.TYPE_EVENEMENT, T1.THEMATIQUE, T1.DESCRIPTION, T1.RESPONSABLE_EVENEMENT, T1.EMAIL_RESPONSABLE_EVENEMENT, T1.RATTACHEMENT_BANDEAU, T1.DATE_SUPPRESSION, T1.COMPLEMENT_DATE, T1.SITE_EVENEMENT, T1.DATE_FIN_EVENEMENT, T1.DATE_ARCHIVAGE, T1.ID_VIGNETTE, T1.DATE_DECLENCHEMENT, T1.PARTENAIRES, T1.INSERTION_AGENDA, T1.CODE, T1.CODE_RUBRIQUE, T1.CODE_RATTACHEMENT, T1.META_KEYWORDS, T1.META_DESCRIPTION, T1.TITRE_ENCADRE, T1.CONTENU_ENCADRE, T1.ENCADRE_RECHERCHE, T1.ENCADRE_RECHERCHE_BIS, T1.DATE_ALERTE, T1.MESSAGE_ALERTE, T1.DATE_CREATION, T1.DATE_PROPOSITION, T1.DATE_VALIDATION, T1.DATE_MODIFICATION, T1.CODE_REDACTEUR, T1.CODE_VALIDATION, T1.LANGUE, T1.ETAT_OBJET, T1.NB_HITS, T1.DIFFUSION_PUBLIC_VISE, T1.DIFFUSION_MODE_RESTRICTION, T1.DIFFUSION_PUBLIC_VISE_RESTRICTION from ACTUALITE T1 ";
	}

	/**
	 * Gets the sQL base optimized query.
	 *
	 * @return the sQL base optimized query
	 */
	public String getSQLBaseOptimizedQuery() {
		return "select T1.ID_ACTUALITE, T1.CODE, T1.LANGUE from ACTUALITE T1 ";
	}

	/**
	 * Renvoie l'element suivant du ResultSet.
	 *
	 * @return true, if next item
	 *
	 * @throws Exception
	 *             the exception
	 */
	public boolean nextItem() throws Exception {
		boolean res = false;
		try {
			if (rs.next()) {
				if (ctx.getDatas().get("optimizedSelect") != null) {
					retrieveFromOptimizedRS();
				} else {
					retrieveFromRS();
				}
				res = true;
			} else {
				try {
					rs.close();
				} finally {
					rs = null;
				}
			}
		} catch (final Exception e) {
			throw new Exception("ERROR_IN_METHOD nextItem()", e);
		}
		return res;
	}

	/**
	 * Recuperation d'une ligne de la base de donnees.
	 *
	 * @throws Exception
	 *             the exception
	 */
	public void retrieve() throws Exception {
		PreparedStatement stmt = null;
		try {
			stmt = getConnection().prepareStatement("select T1.ID_ACTUALITE, T1.TITRE, T1.RESUME, T1.DATE_EVENEMENT, T1.LIEU, T1.ID_PLAN_ACCES, T1.TYPE_EVENEMENT, T1.THEMATIQUE, T1.DESCRIPTION, T1.RESPONSABLE_EVENEMENT, T1.EMAIL_RESPONSABLE_EVENEMENT, T1.RATTACHEMENT_BANDEAU, T1.DATE_SUPPRESSION, T1.COMPLEMENT_DATE, T1.SITE_EVENEMENT, T1.DATE_FIN_EVENEMENT, T1.DATE_ARCHIVAGE, T1.ID_VIGNETTE, T1.DATE_DECLENCHEMENT, T1.PARTENAIRES, T1.INSERTION_AGENDA, T1.CODE, T1.CODE_RUBRIQUE, T1.CODE_RATTACHEMENT, T1.META_KEYWORDS, T1.META_DESCRIPTION, T1.TITRE_ENCADRE, T1.CONTENU_ENCADRE, T1.ENCADRE_RECHERCHE, T1.ENCADRE_RECHERCHE_BIS, T1.DATE_ALERTE, T1.MESSAGE_ALERTE, T1.DATE_CREATION, T1.DATE_PROPOSITION, T1.DATE_VALIDATION, T1.DATE_MODIFICATION, T1.CODE_REDACTEUR, T1.CODE_VALIDATION, T1.LANGUE, T1.ETAT_OBJET, T1.NB_HITS, T1.DIFFUSION_PUBLIC_VISE, T1.DIFFUSION_MODE_RESTRICTION, T1.DIFFUSION_PUBLIC_VISE_RESTRICTION from ACTUALITE T1 where T1.ID_ACTUALITE = ?");
			stmt.setObject(1, getIdActualite(), Types.BIGINT);
			rs = stmt.executeQuery();
			if (!rs.next()) {
				throw new Exception("retrieve : METHOD_NO_RESULTS");
			}
			retrieveFromRS();
		} catch (final SQLException e) {
			throw new Exception("ERROR_IN_METHOD retrieve()", e);
		} finally {
			if (rs != null) {
				rs.close();
				rs = null;
			}
			if (stmt != null) {
				stmt.close();
			}
		}
	}

	/**
	 * Retrieve from rs.
	 *
	 * @throws Exception
	 *             the exception
	 */
	private void retrieveFromRS() throws Exception {
		try {
			// get output from result set
			setIdActualite(rs.getLong(1));
			setTitre(rs.getString(2));
			setResume(rs.getString(3));
			setDateEvenement(rs.getDate(4));
			setLieu(rs.getString(5));
			setIdPlanAcces(rs.getLong(6));
			setTypeEvenement(rs.getString(7));
			setThematique(rs.getString(8));
			setDescription(rs.getString(9));
			setResponsableEvenement(rs.getString(10));
			setEmailResponsableEvenement(rs.getString(11));
			setRattachementBandeau(rs.getString(12));
			setDateSuppression(rs.getDate(13));
			setComplementDate(rs.getString(14));
			setSiteEvenement(rs.getString(15));
			setDateFinEvenement(rs.getDate(16));
			setDateArchivage(rs.getDate(17));
			setIdVignette(rs.getLong(18));
			setDateDeclenchement(rs.getDate(19));
			setPartenaires(rs.getString(20));
			setInsertionAgenda(rs.getString(21));
			setCode(rs.getString(22));
			setCodeRubrique(rs.getString(23));
			setCodeRattachement(rs.getString(24));
			setMetaKeywords(rs.getString(25));
			setMetaDescription(rs.getString(26));
			setTitreEncadre(rs.getString(27));
			setContenuEncadre(rs.getString(28));
			setEncadreRecherche(rs.getString(29));
			setEncadreRechercheBis(rs.getString(30));
			setDateAlerte(rs.getDate(31));
			setMessageAlerte(rs.getString(32));
			setDateCreation(new Date(rs.getTimestamp(33).getTime()));
			setDateProposition(new Date(rs.getTimestamp(34).getTime()));
			setDateValidation(new Date(rs.getTimestamp(35).getTime()));
			setDateModification(new Date(rs.getTimestamp(36).getTime()));
			setCodeRedacteur(rs.getString(37));
			setCodeValidation(rs.getString(38));
			setLangue(rs.getString(39));
			setEtatObjet(rs.getString(40));
			setNbHits(rs.getLong(41));
			setDiffusionPublicVise(rs.getString(42));
			setDiffusionModeRestriction(rs.getString(43));
			setDiffusionPublicViseRestriction(rs.getString(44));
		} catch (final SQLException e) {
			throw new Exception("ERROR_IN_METHOD retrieveFromRS()", e);
		}
	}

	/**
	 * Retrieve from optimized rs.
	 *
	 * @throws Exception
	 *             the exception
	 */
	private void retrieveFromOptimizedRS() throws Exception {
		try {
			// get output from result set
			setIdActualite(rs.getLong(1));
			setCode(rs.getString(2));
			setLangue(rs.getString(3));
		} catch (final SQLException e) {
			throw new Exception("ERROR_IN_METHOD retrieveFromOptimizedRS()", e);
		}
	}

	/**
	 * Cette methode optimise l'execution de la requete (pas de count).
	 *
	 * @param sqlSuffix
	 *            the sql suffix
	 *
	 * @throws Exception
	 *             the exception
	 */
	public void selectNoCount(final String sqlSuffix) throws Exception {
		PreparedStatement stmt = null;
		try {
			String query = getSQLBaseQuery();
			if (sqlSuffix != null) {
				query += sqlSuffix;
			}
			stmt = getConnection().prepareStatement(query);
			rs = stmt.executeQuery();
		} catch (final SQLException e) {
			throw new Exception("SELECT_FAILED", e);
		}
	}

	/**
	 * Select.
	 *
	 * @param sqlSuffix
	 *            the sql suffix
	 *
	 * @return the int
	 *
	 * @throws Exception
	 *             the exception
	 */
	public int select(final String sqlSuffix) throws Exception {
		int count = 0;
		if (ctx.getDatas().get("optimizedObject") != null && ctx.getDatas().get("optimizedSelect") != null) {
			count = selectNoCountOptimized(sqlSuffix);
		} else {
			PreparedStatement stmt = null;
			try {
				// recuperation nombre de lignes
				String query = "select count(distinct T1.ID_ACTUALITE) from ACTUALITE T1 ";
				if (sqlSuffix != null) {
					query += sqlSuffix;
				}
				stmt = getConnection().prepareStatement(query);
				rs = stmt.executeQuery();
				rs.next();
				count = rs.getInt(1);
				// execution requete
				query = getSQLBaseQuery();
				if (sqlSuffix != null) {
					query += sqlSuffix;
				}
				stmt = getConnection().prepareStatement(query);
				rs = stmt.executeQuery();
			} catch (final SQLException e) {
				throw new Exception("SELECT_FAILED", e);
			}
		}
		return count;
	}

	/**
	 * Select no count optimized.
	 *
	 * @param sqlSuffix
	 *            the sql suffix
	 *
	 * @return the int
	 *
	 * @throws Exception
	 *             the exception
	 */
	private int selectNoCountOptimized(final String sqlSuffix) throws Exception {
		PreparedStatement stmt = null;
		final int count = -1;
		try {
			String query = getSQLBaseOptimizedQuery();
			if (sqlSuffix != null) {
				query += sqlSuffix;
			}
			if (ctx.getDatas().get("optimizedLimit") != null) {
				query += " limit 0," + (String) ctx.getDatas().get("optimizedLimit") + "0";
			}
			stmt = getConnection().prepareStatement(query);
			rs = stmt.executeQuery();
		} catch (final SQLException e) {
			throw new Exception("SELECT_FAILED", e);
		}
		return count;
	}

	/**
	 * Mise a jour d'une ligne de la base de donnees.
	 *
	 * @throws Exception
	 *             the exception
	 */
	public void update() throws Exception {
		PreparedStatement stmt = null;
		try {
			stmt = getConnection().prepareStatement("update ACTUALITE set ID_ACTUALITE = ?, TITRE = ?, RESUME = ?, DATE_EVENEMENT = ?, LIEU = ?, ID_PLAN_ACCES = ?, TYPE_EVENEMENT = ?, THEMATIQUE = ?, DESCRIPTION = ?, RESPONSABLE_EVENEMENT = ?, EMAIL_RESPONSABLE_EVENEMENT = ?, RATTACHEMENT_BANDEAU = ?, DATE_SUPPRESSION = ?, COMPLEMENT_DATE = ?, SITE_EVENEMENT = ?, DATE_FIN_EVENEMENT = ?, DATE_ARCHIVAGE = ?, ID_VIGNETTE = ?, DATE_DECLENCHEMENT = ?, PARTENAIRES = ?, INSERTION_AGENDA = ?, CODE = ?, CODE_RUBRIQUE = ?, CODE_RATTACHEMENT = ?, META_KEYWORDS = ?, META_DESCRIPTION = ?, TITRE_ENCADRE = ?, CONTENU_ENCADRE = ?, ENCADRE_RECHERCHE = ?, ENCADRE_RECHERCHE_BIS = ?, DATE_ALERTE = ?, MESSAGE_ALERTE = ?, DATE_CREATION = ?, DATE_PROPOSITION = ?, DATE_VALIDATION = ?, DATE_MODIFICATION = ?, CODE_REDACTEUR = ?, CODE_VALIDATION = ?, LANGUE = ?, ETAT_OBJET = ?, NB_HITS = ?, DIFFUSION_PUBLIC_VISE = ?, DIFFUSION_MODE_RESTRICTION = ?, DIFFUSION_PUBLIC_VISE_RESTRICTION = ? where ID_ACTUALITE = ?");
			// put parameters into statement
			stmt.setObject(1, getIdActualite(), Types.BIGINT);
			stmt.setObject(2, getTitre(), Types.LONGVARCHAR);
			stmt.setObject(3, getResume(), Types.LONGVARCHAR);
			stmt.setObject(4, getDateEvenement(), Types.DATE);
			stmt.setObject(5, getLieu(), Types.LONGVARCHAR);
			stmt.setObject(6, getIdPlanAcces(), Types.BIGINT);
			stmt.setObject(7, getTypeEvenement(), Types.VARCHAR);
			stmt.setObject(8, getThematique(), Types.VARCHAR);
			stmt.setObject(9, getDescription(), Types.LONGVARCHAR);
			stmt.setObject(10, getResponsableEvenement(), Types.LONGVARCHAR);
			stmt.setObject(11, getEmailResponsableEvenement(), Types.LONGVARCHAR);
			stmt.setObject(12, getRattachementBandeau(), Types.VARCHAR);
			stmt.setObject(13, getDateSuppression(), Types.DATE);
			stmt.setObject(14, getComplementDate(), Types.LONGVARCHAR);
			stmt.setObject(15, getSiteEvenement(), Types.VARCHAR);
			stmt.setObject(16, getDateFinEvenement(), Types.DATE);
			stmt.setObject(17, getDateArchivage(), Types.DATE);
			stmt.setObject(18, getIdVignette(), Types.BIGINT);
			stmt.setObject(19, getDateDeclenchement(), Types.DATE);
			stmt.setObject(20, getPartenaires(), Types.LONGVARCHAR);
			stmt.setObject(21, getInsertionAgenda(), Types.VARCHAR);
			stmt.setObject(22, getCode(), Types.VARCHAR);
			stmt.setObject(23, getCodeRubrique(), Types.VARCHAR);
			stmt.setObject(24, getCodeRattachement(), Types.VARCHAR);
			stmt.setObject(25, getMetaKeywords(), Types.LONGVARCHAR);
			stmt.setObject(26, getMetaDescription(), Types.LONGVARCHAR);
			stmt.setObject(27, getTitreEncadre(), Types.VARCHAR);
			stmt.setObject(28, getContenuEncadre(), Types.LONGVARCHAR);
			stmt.setObject(29, getEncadreRecherche(), Types.VARCHAR);
			stmt.setObject(30, getEncadreRechercheBis(), Types.VARCHAR);
			stmt.setObject(31, getDateAlerte(), Types.DATE);
			stmt.setObject(32, getMessageAlerte(), Types.LONGVARCHAR);
			stmt.setObject(33, getDateCreation(), Types.TIMESTAMP);
			stmt.setObject(34, getDateProposition(), Types.TIMESTAMP);
			stmt.setObject(35, getDateValidation(), Types.TIMESTAMP);
			stmt.setObject(36, getDateModification(), Types.TIMESTAMP);
			stmt.setObject(37, getCodeRedacteur(), Types.VARCHAR);
			stmt.setObject(38, getCodeValidation(), Types.VARCHAR);
			stmt.setObject(39, getLangue(), Types.VARCHAR);
			stmt.setObject(40, getEtatObjet(), Types.VARCHAR);
			stmt.setObject(41, getNbHits(), Types.BIGINT);
			stmt.setObject(42, getDiffusionPublicVise(), Types.VARCHAR);
			stmt.setObject(43, getDiffusionModeRestriction(), Types.VARCHAR);
			stmt.setObject(44, getDiffusionPublicViseRestriction(), Types.VARCHAR);
			stmt.setObject(45, getIdActualite(), Types.BIGINT);
			stmt.executeUpdate();
		} catch (final SQLException e) {
			throw new Exception("ERROR_IN_METHOD update()", e);
		} finally {
			if (stmt != null) {
				stmt.close();
			}
		}
	}
}
