/**
 * Copyright (C) 2015 Kosmos contact@kosmos.fr
 *
 * Projet: actualite
 * Version: 1.02.07
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.objetspartages.util;

import org.apache.commons.lang3.StringUtils;

import com.kportal.core.config.MessageHelper;
import com.kportal.core.config.PropertyHelper;
import com.kportal.extension.ExtensionHelper;
import com.kportal.extension.IExtension;
import com.kportal.extension.module.IModule;
import com.kportal.extension.module.ModuleHelper;
import com.univ.objetspartages.om.Actualite;
import com.univ.objetspartages.om.EtatFiche;
import com.univ.utils.ContexteUniv;
import com.univ.utils.ContexteUtil;

public class ActualiteHelper {

	public static final String ID_EXTENSION = "actualite";

	/**
	 * Methode permettant de récupérer les 5 dernières actualités de la même thématiques, rubrique et langue que l'actu fourni en paramètre
	 *
	 * @param actualite l'actualité courante permettant de récupérer la thématique rechercher sans la faire remonter dans les résultats
	 * @return l'objet actu contenant les résultats...
	 * @throws Exception lors de la requête en BDD
	 */
	public static Actualite getActualiteMemeThematique(final Actualite actualite) throws Exception {
		final Actualite actu = new Actualite();
		final ContexteUniv ctx = ContexteUtil.getContexteUniv();
		actu.setCtx(ctx);
		final String thematiques = StringUtils.isNotBlank(actualite.getThematique()) ? actualite.getThematique().replace(";", "+") : null;
		ctx.setCalculListeResultatsFront(Boolean.TRUE);
		actu.select(StringUtils.EMPTY, StringUtils.EMPTY, StringUtils.EMPTY, thematiques, null, null, StringUtils.EMPTY, actualite.getCodeRubrique(), actualite.getLangue(),
			StringUtils.EMPTY, EtatFiche.EN_LIGNE.getEtat(), StringUtils.EMPTY, "5", "META.META_DATE_MISE_EN_LIGNE DESC", StringUtils.EMPTY);
		ctx.setCalculListeResultatsFront(Boolean.FALSE);
		return actu;
	}

	public static IExtension getExtension() {
		return ExtensionHelper.getExtensionManager().getExtension(ID_EXTENSION);
	}

	public static String getProperty(final String key) {
		return PropertyHelper.getProperty(ID_EXTENSION, key);
	}

	public static String getMessage(final String key) {
		return MessageHelper.getMessage(ID_EXTENSION, key);
	}

	public static IModule getModule(final String idBean) {
		return ModuleHelper.getModule(ID_EXTENSION, idBean);
	}
}
