/*
 * Decompiled with CFR 0.152.
 */
package com.univ.objetspartages.om;

import com.jsbsoft.jtf.core.LangueUtil;
import com.jsbsoft.jtf.database.OMContext;
import com.kportal.cms.objetspartages.annotation.FicheAnnotation;
import com.kportal.cms.objetspartages.om.ContentRedirect;
import com.univ.objetspartages.om.DiffusionSelective;
import com.univ.objetspartages.om.EtatFiche;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.InfosRubriques;
import com.univ.objetspartages.om.InfosStructure;
import com.univ.objetspartages.om.Libelle;
import com.univ.objetspartages.om.Metatag;
import com.univ.objetspartages.om.Ressource;
import com.univ.objetspartages.om.Rubrique;
import com.univ.objetspartages.om.Structure;
import com.univ.objetspartages.sgbd.LienDB;
import com.univ.utils.Chaine;
import com.univ.utils.ContexteUniv;
import com.univ.utils.FicheUnivMgr;
import com.univ.utils.RequeteUtil;
import com.univ.utils.UnivWebFmt;
import com.univ.utils.sql.RequeteSQL;
import com.univ.utils.sql.clause.ClauseLimit;
import com.univ.utils.sql.clause.ClauseOrderBy;
import com.univ.utils.sql.clause.ClauseWhere;
import com.univ.utils.sql.criterespecifique.ConditionHelper;
import com.univ.utils.sql.criterespecifique.LimitHelper;
import com.univ.utils.sql.criterespecifique.OrderByHelper;
import com.univ.utils.sql.criterespecifique.RequeteSQLHelper;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.lang3.StringUtils;

@FicheAnnotation
public class Lien
extends LienDB
implements FicheUniv,
DiffusionSelective,
Cloneable,
ContentRedirect {
    private static final long serialVersionUID = 4900701412833993966L;

    public static String getLibelleAffichable(OMContext ctx, String codes, String langue) throws Exception {
        String res = "";
        if (codes == null || codes.length() == 0) {
            return res;
        }
        Lien lien = new Lien();
        lien.init();
        lien.setCtx(ctx);
        if (langue == null || langue.length() == 0) {
            langue = "0";
        }
        StringTokenizer st = new StringTokenizer(codes, ";");
        while (st.hasMoreTokens()) {
            String code = st.nextToken();
            int count = lien.selectCodeLangueEtat(code, langue, "0003");
            if (count == 0) {
                count = lien.selectCodeLangueEtat(code, langue, "");
            }
            if (count > 0) {
                if (res.length() > 1) {
                    res = res + ";";
                }
                if (!lien.nextItem()) continue;
                res = res + lien.getLibelleAffichable();
                continue;
            }
            res = res + "-";
        }
        return res;
    }

    public static Lien getFicheLien(OMContext ctx, String code, String langue) throws Exception {
        Lien fiche = null;
        if (code != null && code.length() > 0) {
            if (langue == null || langue.length() == 0) {
                langue = "0";
            }
            fiche = new Lien();
            fiche.init();
            fiche.setCtx(ctx);
            int count = fiche.selectCodeLangueEtat(code, langue, "0003");
            if (count == 0) {
                count = fiche.selectCodeLangueEtat(code, langue, "");
            }
            if (count == 0) {
                count = fiche.selectCodeLangueEtat(code, "", "0003");
            }
            if (count > 0) {
                fiche.nextItem();
            }
        }
        return fiche;
    }

    public void init() {
        FicheUnivMgr.init((FicheUniv)this);
        this.setIdLien(new Long(0L));
        this.setCode("");
        this.setLangue("0");
        this.setTitre("");
        this.setUrl("");
        this.setThematique("");
        this.setType("");
        this.setCategorie("");
        this.setResume("");
        this.setDescription("");
        this.setAuteurediteur("");
        this.setNomresponsable("");
        this.setEmailresponsable("");
    }

    public String getLibelleAffichable() {
        return this.getTitre();
    }

    public Long getIdFiche() {
        return this.getIdLien();
    }

    public void setIdFiche(Long idFiche) {
        this.setIdLien(idFiche);
    }

    public String getLibelleThematique() {
        return Libelle.getLibelle((String)"04", (String)this.getThematique(), (Locale)LangueUtil.getLocale((int)Integer.parseInt(this.getLangue())));
    }

    public String getLibelleType() {
        return Libelle.getLibelle((String)"70", (String)this.getType(), (Locale)LangueUtil.getLocale((int)Integer.parseInt(this.getLangue())));
    }

    public String getLibelleCategorie() {
        return Libelle.getLibelle((String)"71", (String)this.getCategorie(), (Locale)LangueUtil.getLocale((int)Integer.parseInt(this.getLangue())));
    }

    public List<String> getListLibelleCategorie() {
        return Libelle.getLibelleSousFormeDeListe((String)"71", (String)this.getCategorie(), (Locale)LangueUtil.getLocale((int)Integer.parseInt(this.getLangue())));
    }

    public String getLibelleBackOffice() {
        return this.getLibelleAffichable() + " [" + Rubrique.getIntitule((String)this.getCodeRubrique()) + "]";
    }

    public String getFormatedDescription() throws Exception {
        return UnivWebFmt.formaterEnHTML((ContexteUniv)((ContexteUniv)this.ctx), (String)this.getDescription());
    }

    public Ressource getVignette() throws Exception {
        return Ressource.getFichier((FicheUniv)this);
    }

    public InfosRubriques getInfosRubrique() {
        return Rubrique.renvoyerItemRubrique((String)this.getCodeRubrique());
    }

    public InfosStructure getInfosStructure() throws Exception {
        return Structure.renvoyerItemStructure((String)this.getCodeRattachement(), (String)this.getLangue());
    }

    public Metatag getMeta() throws Exception {
        return FicheUnivMgr.lireMeta((FicheUniv)this);
    }

    public String getFullTextString() {
        String s = this.getUrl() + " " + StringUtils.replace((String)this.getLibelleThematique(), (String)";", (String)" ") + " " + StringUtils.replace((String)this.getLibelleType(), (String)";", (String)" ") + " " + StringUtils.replace((String)this.getLibelleCategorie(), (String)";", (String)" ") + " " + this.getResume() + " " + this.getDescription() + " " + this.getAuteurediteur() + " " + this.getNomresponsable() + " " + this.getEmailresponsable();
        return s;
    }

    public void dupliquer(String nouvelleLangue) throws Exception {
        FicheUnivMgr.dupliquer((FicheUniv)this);
        this.setIdFiche(new Long(0L));
        this.setLangue(nouvelleLangue);
        this.add();
    }

    public int traiterRequete(String requete) throws Exception {
        String titre = RequeteUtil.renvoyerParametre((String)requete, (String)"TITRE");
        String url = RequeteUtil.renvoyerParametre((String)requete, (String)"URL");
        String auteurediteur = RequeteUtil.renvoyerParametre((String)requete, (String)"AUTEUREDITEUR");
        String thematique = RequeteUtil.renvoyerParametre((String)requete, (String)"THEMATIQUE");
        String type = RequeteUtil.renvoyerParametre((String)requete, (String)"TYPE");
        String categorie = RequeteUtil.renvoyerParametre((String)requete, (String)"CATEGORIE");
        String description = RequeteUtil.renvoyerParametre((String)requete, (String)"DESCRIPTION");
        String ids = RequeteUtil.renvoyerParametre((String)requete, (String)"IDS");
        String nombre = RequeteUtil.renvoyerParametre((String)requete, (String)"NOMBRE");
        String codeRubrique = RequeteUtil.renvoyerParametre((String)requete, (String)"CODE_RUBRIQUE");
        String codeRattachement = RequeteUtil.renvoyerParametre((String)requete, (String)"CODE_RATTACHEMENT");
        String langue = RequeteUtil.renvoyerParametre((String)requete, (String)"LANGUE");
        String nomResponsable = RequeteUtil.renvoyerParametre((String)requete, (String)"NOMRESPONSABLE");
        String selection = RequeteUtil.renvoyerParametre((String)requete, (String)"SELECTION");
        String etatObjet = (String)StringUtils.defaultIfBlank((CharSequence)RequeteUtil.renvoyerParametre((String)requete, (String)"ETAT_OBJET"), (CharSequence)EtatFiche.EN_LIGNE.toString());
        String codeRedacteur = RequeteUtil.renvoyerParametre((String)requete, (String)"CODE_REDACTEUR");
        String codeFiche = RequeteUtil.renvoyerParametre((String)requete, (String)"CODE");
        String order = "T1.TITRE";
        String orderTri = "ASC";
        if (selection.length() > 0 && selection.equals("0007")) {
            order = "META.META_DATE_MISE_EN_LIGNE";
            orderTri = "DESC";
        }
        return this.select(titre, url, auteurediteur, nomResponsable, thematique, type, categorie, description, ids, nombre, codeRubrique, codeRattachement, langue, etatObjet, codeRedacteur, order + " " + orderTri, codeFiche);
    }

    public int selectCodeLangueEtat(String code, String langue, String etatObjet) throws Exception {
        ClauseWhere whereCodeLangueEtat = ConditionHelper.whereCodeLangueEtat((String)code, (String)langue, (String)etatObjet);
        return this.select(whereCodeLangueEtat.formaterSQL());
    }

    @Deprecated
    public int selectParCodeRubrique(String codeRubrique, String langue) throws Exception {
        ClauseWhere whereCodeRubriqueLangueEtat = new ClauseWhere();
        if (StringUtils.isNotEmpty((CharSequence)codeRubrique)) {
            whereCodeRubriqueLangueEtat.setPremiereCondition(ConditionHelper.egalVarchar((String)"T1.CODE_RUBRIQUE", (String)codeRubrique));
        }
        if (StringUtils.isNotEmpty((CharSequence)langue)) {
            whereCodeRubriqueLangueEtat.and(ConditionHelper.egalVarchar((String)"T1.LANGUE", (String)langue));
        }
        if (StringUtils.isNotEmpty((CharSequence)langue)) {
            whereCodeRubriqueLangueEtat.and(ConditionHelper.egalVarchar((String)"T1.ETAT_OBJET", (String)"0003"));
        }
        return this.select(whereCodeRubriqueLangueEtat.formaterSQL());
    }

    public String getReferences() {
        return FicheUnivMgr.getReferenceParTexte((String)this.getDescription()) + FicheUnivMgr.getReferenceParJointure((String)"structure", (String)this.getCodeRattachement());
    }

    public int select(String titre, String url, String auteurediteur, String nomResponsable, String thematique, String type, String categorie, String description, String ids, String nombre, String codeRubrique, String codeRattachement, String langue, String etatObjet, String codeRedacteur, String ordre, String code) throws Exception {
        RequeteSQL requeteSelect = new RequeteSQL();
        ClauseWhere where = new ClauseWhere();
        if (StringUtils.isNotEmpty((CharSequence)titre)) {
            where.setPremiereCondition(ConditionHelper.rechercheMots((String)"T1.TITRE", (String)titre));
        }
        if (StringUtils.isNotEmpty((CharSequence)url)) {
            where.and(ConditionHelper.rechercheMots((String)"T1.URL", (String)url));
        }
        if (StringUtils.isNotEmpty((CharSequence)auteurediteur)) {
            where.and(ConditionHelper.rechercheMots((String)"T1.AUTEUREDITEUR", (String)auteurediteur));
        }
        if (StringUtils.isNotEmpty((CharSequence)nomResponsable)) {
            where.and(ConditionHelper.rechercheMots((String)"T1.NOMRESPONSABLE", (String)nomResponsable));
        }
        if (StringUtils.isNotEmpty((CharSequence)thematique) && !"0000".equals(thematique)) {
            where.and(ConditionHelper.likePourValeursMultiple((String)"THEMATIQUE", (String)thematique));
        }
        if (StringUtils.isNotEmpty((CharSequence)type) && !"0000".equals(type)) {
            where.and(ConditionHelper.likePourValeursMultiple((String)"T1.TYPE", (String)type));
        }
        if (StringUtils.isNotEmpty((CharSequence)categorie) && !"0000".equals(categorie)) {
            where.and(ConditionHelper.likePourValeursMultiple((String)"T1.CATEGORIE", (String)categorie));
        }
        if (StringUtils.isNotEmpty((CharSequence)description)) {
            where.and(ConditionHelper.rechercheMots((String)"T1.DESCRIPTION", (String)description));
        }
        if (StringUtils.isNotEmpty((CharSequence)ids) && !"0000".equals(ids)) {
            where.and(ConditionHelper.in((String)"ID_LIEN", (Collection)Chaine.getVecteurPointsVirgules((String)ids)));
        }
        if (StringUtils.isNotEmpty((CharSequence)codeRattachement)) {
            where.and(ConditionHelper.getConditionStructure((String)"T1.CODE_RATTACHEMENT", (String)codeRattachement));
        }
        if (StringUtils.isNotEmpty((CharSequence)langue) && !"0000".equals(langue)) {
            where.and(ConditionHelper.egalVarchar((String)"T1.LANGUE", (String)langue));
        }
        if (StringUtils.isNotEmpty((CharSequence)etatObjet) && !"0000".equals(etatObjet)) {
            where.and(ConditionHelper.egalVarchar((String)"T1.ETAT_OBJET", (String)etatObjet));
        }
        if (StringUtils.isNotEmpty((CharSequence)codeRedacteur)) {
            where.and(ConditionHelper.egalVarchar((String)"T1.CODE_REDACTEUR", (String)codeRedacteur));
        }
        if (StringUtils.isNotEmpty((CharSequence)code)) {
            where.and(ConditionHelper.egalVarchar((String)"T1.CODE", (String)code));
        }
        requeteSelect = RequeteSQLHelper.getRequeteGenerique((ClauseWhere)where, (OMContext)this.ctx, (FicheUniv)this, (String)codeRubrique);
        ClauseOrderBy orderBy = new ClauseOrderBy();
        if (StringUtils.isNotEmpty((CharSequence)ordre)) {
            orderBy = OrderByHelper.reconstruireClauseOrderBy((String)ordre);
        } else {
            orderBy.orderBy("T1.TITRE", ClauseOrderBy.SensDeTri.ASC);
        }
        requeteSelect.orderBy(orderBy);
        ClauseLimit limite = LimitHelper.ajouterCriteresLimitesEtOptimisation((OMContext)this.ctx, (String)nombre);
        requeteSelect.limit(limite);
        return this.select(requeteSelect.formaterRequete());
    }

    public String getContenu() {
        return this.getDescription();
    }

    public Object clone() {
        Lien clone = new Lien();
        clone.setAuteurediteur(this.getAuteurediteur());
        clone.setCategorie(this.getCategorie());
        clone.setCode(this.getCode());
        clone.setCodeRattachement(this.getCodeRattachement());
        clone.setCodeRedacteur(this.getCodeRedacteur());
        clone.setCodeRubrique(this.getCodeRubrique());
        clone.setCodeValidation(this.getCodeValidation());
        clone.setContenuEncadre(this.getContenuEncadre());
        clone.setCtx(this.ctx);
        clone.setDateAlerte(this.getDateAlerte());
        clone.setDateCreation(this.getDateCreation());
        clone.setDateModification(this.getDateModification());
        clone.setDateProposition(this.getDateProposition());
        clone.setDateValidation(this.getDateValidation());
        clone.setDescription(this.getDescription());
        clone.setDiffusionModeRestriction(this.getDiffusionModeRestriction());
        clone.setDiffusionPublicVise(this.getDiffusionPublicVise());
        clone.setDiffusionPublicViseRestriction(this.getDiffusionPublicViseRestriction());
        clone.setEmailresponsable(this.getEmailresponsable());
        clone.setEncadreRecherche(this.getEncadreRecherche());
        clone.setEncadreRechercheBis(this.getEncadreRechercheBis());
        clone.setEtatObjet(this.getEtatObjet());
        clone.setIdFiche(this.getIdFiche());
        clone.setIdLien(this.getIdLien());
        clone.setLangue(this.getLangue());
        clone.setMessageAlerte(this.getMessageAlerte());
        clone.setMetaDescription(this.getMetaDescription());
        clone.setMetaKeywords(this.getMetaKeywords());
        clone.setNbHits(this.getNbHits());
        clone.setNomresponsable(this.getNomresponsable());
        clone.setQualifier(this.qualifier);
        clone.setResume(this.getResume());
        clone.setThematique(this.getThematique());
        clone.setTitre(this.getTitre());
        clone.setTitreEncadre(this.getTitreEncadre());
        clone.setType(this.getType());
        clone.setUrl(this.getUrl());
        return clone;
    }

    public Vector<String> getVecteurTypes() {
        Vector<String> v = new Vector<String>();
        StringTokenizer st = new StringTokenizer(this.getType(), ";");
        while (st.hasMoreTokens()) {
            v.add(st.nextToken());
        }
        return v;
    }

    public void setVecteurTypes(Vector<String> v) {
        String liste = "";
        Enumeration<String> en = v.elements();
        while (en.hasMoreElements()) {
            liste = liste + en.nextElement() + ";";
        }
        this.setType(liste);
    }

    public Vector<String> getVecteurThematiques() {
        Vector<String> v = new Vector<String>();
        StringTokenizer st = new StringTokenizer(this.getThematique(), ";");
        while (st.hasMoreTokens()) {
            v.add(st.nextToken());
        }
        return v;
    }

    public void setVecteurThematiques(Vector<String> v) {
        String liste = "";
        Enumeration<String> en = v.elements();
        while (en.hasMoreElements()) {
            liste = liste + en.nextElement() + ";";
        }
        this.setThematique(liste);
    }

    public Vector<String> getVecteurCategories() {
        Vector<String> v = new Vector<String>();
        StringTokenizer st = new StringTokenizer(this.getCategorie(), ";");
        while (st.hasMoreTokens()) {
            v.add(st.nextToken());
        }
        return v;
    }

    public void setVecteurCategories(Vector<String> v) {
        String liste = "";
        Enumeration<String> en = v.elements();
        while (en.hasMoreElements()) {
            liste = liste + en.nextElement() + ";";
        }
        this.setCategorie(liste);
    }

    public String getUrlRedirect() {
        return this.getUrl();
    }
}

