/*
 * Decompiled with CFR 0.152.
 */
package com.univ.objetspartages.sgbd;

import com.jsbsoft.jtf.database.OMContext;
import com.univ.objetspartages.bean.LienBean;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class LienDB
extends LienBean {
    private static final long serialVersionUID = 5480953915133538233L;
    protected transient OMContext ctx = null;
    protected transient String qualifier = null;
    private transient ResultSet rs = null;

    public void setCtx(OMContext _ctx) {
        this.ctx = _ctx;
    }

    public void setQualifier(String qualifier) {
        this.qualifier = qualifier;
    }

    private Connection getConnection() {
        return this.ctx.getConnection();
    }

    public void add() throws Exception {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.getConnection().prepareStatement("insert into LIEN (ID_LIEN , TITRE , URL , THEMATIQUE , TYPE , CATEGORIE , RESUME , DESCRIPTION , AUTEUREDITEUR , NOMRESPONSABLE , EMAILRESPONSABLE , CODE , CODE_RUBRIQUE , CODE_RATTACHEMENT , META_KEYWORDS , META_DESCRIPTION , TITRE_ENCADRE , CONTENU_ENCADRE , ENCADRE_RECHERCHE , ENCADRE_RECHERCHE_BIS , DATE_ALERTE , MESSAGE_ALERTE , DATE_CREATION , DATE_PROPOSITION , DATE_VALIDATION , DATE_MODIFICATION , CODE_REDACTEUR , CODE_VALIDATION , LANGUE , ETAT_OBJET , NB_HITS , DIFFUSION_PUBLIC_VISE , DIFFUSION_MODE_RESTRICTION , DIFFUSION_PUBLIC_VISE_RESTRICTION) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", 1);
            stmt.setObject(1, (Object)this.getIdLien(), -5);
            stmt.setObject(2, (Object)this.getTitre(), 12);
            stmt.setObject(3, (Object)this.getUrl(), 12);
            stmt.setObject(4, (Object)this.getThematique(), -1);
            stmt.setObject(5, (Object)this.getType(), -1);
            stmt.setObject(6, (Object)this.getCategorie(), 12);
            stmt.setObject(7, (Object)this.getResume(), -1);
            stmt.setObject(8, (Object)this.getDescription(), -1);
            stmt.setObject(9, (Object)this.getAuteurediteur(), 12);
            stmt.setObject(10, (Object)this.getNomresponsable(), 12);
            stmt.setObject(11, (Object)this.getEmailresponsable(), 12);
            stmt.setObject(12, (Object)this.getCode(), 12);
            stmt.setObject(13, (Object)this.getCodeRubrique(), 12);
            stmt.setObject(14, (Object)this.getCodeRattachement(), 12);
            stmt.setObject(15, (Object)this.getMetaKeywords(), -1);
            stmt.setObject(16, (Object)this.getMetaDescription(), -1);
            stmt.setObject(17, (Object)this.getTitreEncadre(), 12);
            stmt.setObject(18, (Object)this.getContenuEncadre(), -1);
            stmt.setObject(19, (Object)this.getEncadreRecherche(), 12);
            stmt.setObject(20, (Object)this.getEncadreRechercheBis(), 12);
            stmt.setObject(21, (Object)this.getDateAlerte(), 91);
            stmt.setObject(22, (Object)this.getMessageAlerte(), -1);
            stmt.setObject(23, (Object)this.getDateCreation(), 93);
            stmt.setObject(24, (Object)this.getDateProposition(), 93);
            stmt.setObject(25, (Object)this.getDateValidation(), 93);
            stmt.setObject(26, (Object)this.getDateModification(), 93);
            stmt.setObject(27, (Object)this.getCodeRedacteur(), 12);
            stmt.setObject(28, (Object)this.getCodeValidation(), 12);
            stmt.setObject(29, (Object)this.getLangue(), 12);
            stmt.setObject(30, (Object)this.getEtatObjet(), 12);
            stmt.setObject(31, (Object)this.getNbHits(), -5);
            stmt.setObject(32, (Object)this.getDiffusionPublicVise(), 12);
            stmt.setObject(33, (Object)this.getDiffusionModeRestriction(), 12);
            stmt.setObject(34, (Object)this.getDiffusionPublicViseRestriction(), 12);
            int rowsAffected = stmt.executeUpdate();
            if (rowsAffected == 0) {
                throw new Exception("METHOD_AFFCTD_NOROWS");
            }
            if (rowsAffected > 1) {
                throw new Exception("METHOD_AFFCTD_MULTROWS");
            }
            rs = stmt.getGeneratedKeys();
            rs.next();
            this.setIdLien(rs.getLong(1));
        }
        catch (SQLException e) {
            throw new Exception("ERROR_IN_METHOD add()", e);
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    public void delete() throws Exception {
        try (PreparedStatement stmt = null;){
            stmt = this.getConnection().prepareStatement("delete from LIEN where ID_LIEN = ?");
            stmt.setObject(1, (Object)this.getIdLien(), -5);
            int rowsAffected = stmt.executeUpdate();
            if (rowsAffected == 0) {
                throw new Exception("METHOD_AFFCTD_NOROWS");
            }
            if (rowsAffected > 1) {
                throw new Exception("METHOD_AFFCTD_MULTROWS");
            }
        }
    }

    public String getSQLBaseQuery() {
        return String.format("select distinct T1.ID_LIEN, T1.TITRE, T1.URL, T1.THEMATIQUE, T1.TYPE, T1.CATEGORIE, T1.RESUME, T1.DESCRIPTION, T1.AUTEUREDITEUR, T1.NOMRESPONSABLE, T1.EMAILRESPONSABLE, T1.CODE, T1.CODE_RUBRIQUE, T1.CODE_RATTACHEMENT, T1.META_KEYWORDS, T1.META_DESCRIPTION, T1.TITRE_ENCADRE, T1.CONTENU_ENCADRE, T1.ENCADRE_RECHERCHE, T1.ENCADRE_RECHERCHE_BIS, T1.DATE_ALERTE, T1.MESSAGE_ALERTE, T1.DATE_CREATION, T1.DATE_PROPOSITION, T1.DATE_VALIDATION, T1.DATE_MODIFICATION, T1.CODE_REDACTEUR, T1.CODE_VALIDATION, T1.LANGUE, T1.ETAT_OBJET, T1.NB_HITS, T1.DIFFUSION_PUBLIC_VISE, T1.DIFFUSION_MODE_RESTRICTION, T1.DIFFUSION_PUBLIC_VISE_RESTRICTION from %sLIEN T1 ", this.qualifier == null ? "" : this.qualifier);
    }

    public String getSQLBaseOptimizedQuery() {
        return String.format("select T1.ID_LIEN, T1.CODE, T1.LANGUE from %sLIEN T1 ", this.qualifier == null ? "" : this.qualifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean nextItem() throws Exception {
        boolean res;
        block8: {
            res = false;
            try {
                if (this.rs.next()) {
                    if (this.ctx.getDatas().get("optimizedSelect") != null) {
                        this.retrieveFromOptimizedRS();
                    } else {
                        this.retrieveFromRS();
                    }
                    res = true;
                    break block8;
                }
                try {
                    this.rs.close();
                }
                finally {
                    this.rs = null;
                }
            }
            catch (Exception e) {
                throw new Exception("ERROR_IN_METHOD nextItem()", e);
            }
        }
        return res;
    }

    public void retrieve() throws Exception {
        PreparedStatement stmt = null;
        try {
            stmt = this.getConnection().prepareStatement("select T1.ID_LIEN, T1.TITRE, T1.URL, T1.THEMATIQUE, T1.TYPE, T1.CATEGORIE, T1.RESUME, T1.DESCRIPTION, T1.AUTEUREDITEUR, T1.NOMRESPONSABLE, T1.EMAILRESPONSABLE, T1.CODE, T1.CODE_RUBRIQUE, T1.CODE_RATTACHEMENT, T1.META_KEYWORDS, T1.META_DESCRIPTION, T1.TITRE_ENCADRE, T1.CONTENU_ENCADRE, T1.ENCADRE_RECHERCHE, T1.ENCADRE_RECHERCHE_BIS, T1.DATE_ALERTE, T1.MESSAGE_ALERTE, T1.DATE_CREATION, T1.DATE_PROPOSITION, T1.DATE_VALIDATION, T1.DATE_MODIFICATION, T1.CODE_REDACTEUR, T1.CODE_VALIDATION, T1.LANGUE, T1.ETAT_OBJET, T1.NB_HITS, T1.DIFFUSION_PUBLIC_VISE, T1.DIFFUSION_MODE_RESTRICTION, T1.DIFFUSION_PUBLIC_VISE_RESTRICTION from LIEN T1 where T1.ID_LIEN = ?");
            stmt.setObject(1, (Object)this.getIdLien(), -5);
            this.rs = stmt.executeQuery();
            if (!this.rs.next()) {
                throw new Exception("retrieve : METHOD_NO_RESULTS");
            }
            this.retrieveFromRS();
        }
        catch (SQLException e) {
            throw new Exception("ERROR_IN_METHOD retrieve()", e);
        }
        finally {
            if (this.rs != null) {
                this.rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    private void retrieveFromRS() throws Exception {
        try {
            this.setIdLien(this.rs.getLong(1));
            this.setTitre(this.rs.getString(2));
            this.setUrl(this.rs.getString(3));
            this.setThematique(this.rs.getString(4));
            this.setType(this.rs.getString(5));
            this.setCategorie(this.rs.getString(6));
            this.setResume(this.rs.getString(7));
            this.setDescription(this.rs.getString(8));
            this.setAuteurediteur(this.rs.getString(9));
            this.setNomresponsable(this.rs.getString(10));
            this.setEmailresponsable(this.rs.getString(11));
            this.setCode(this.rs.getString(12));
            this.setCodeRubrique(this.rs.getString(13));
            this.setCodeRattachement(this.rs.getString(14));
            this.setMetaKeywords(this.rs.getString(15));
            this.setMetaDescription(this.rs.getString(16));
            this.setTitreEncadre(this.rs.getString(17));
            this.setContenuEncadre(this.rs.getString(18));
            this.setEncadreRecherche(this.rs.getString(19));
            this.setEncadreRechercheBis(this.rs.getString(20));
            this.setDateAlerte(this.rs.getDate(21));
            this.setMessageAlerte(this.rs.getString(22));
            this.setDateCreation(new Date(this.rs.getTimestamp(23).getTime()));
            this.setDateProposition(new Date(this.rs.getTimestamp(24).getTime()));
            this.setDateValidation(new Date(this.rs.getTimestamp(25).getTime()));
            this.setDateModification(new Date(this.rs.getTimestamp(26).getTime()));
            this.setCodeRedacteur(this.rs.getString(27));
            this.setCodeValidation(this.rs.getString(28));
            this.setLangue(this.rs.getString(29));
            this.setEtatObjet(this.rs.getString(30));
            this.setNbHits(this.rs.getLong(31));
            this.setDiffusionPublicVise(this.rs.getString(32));
            this.setDiffusionModeRestriction(this.rs.getString(33));
            this.setDiffusionPublicViseRestriction(this.rs.getString(34));
        }
        catch (SQLException e) {
            throw new Exception("ERROR_IN_METHOD retrieveFromRS()", e);
        }
    }

    private void retrieveFromOptimizedRS() throws Exception {
        try {
            this.setIdLien(this.rs.getLong(1));
            this.setCode(this.rs.getString(2));
            this.setLangue(this.rs.getString(3));
        }
        catch (SQLException e) {
            throw new Exception("ERROR_IN_METHOD retrieveFromOptimizedRS()", e);
        }
    }

    public void selectNoCount(String sqlSuffix) throws Exception {
        PreparedStatement stmt = null;
        try {
            String query = this.getSQLBaseQuery();
            if (sqlSuffix != null) {
                query = query + sqlSuffix;
            }
            stmt = this.getConnection().prepareStatement(query);
            this.rs = stmt.executeQuery();
        }
        catch (SQLException e) {
            throw new Exception("SELECT_FAILED", e);
        }
    }

    public int select(String sqlSuffix) throws Exception {
        int count;
        if (this.ctx.getDatas().get("optimizedObject") != null && this.ctx.getDatas().get("optimizedSelect") != null) {
            count = this.selectNoCountOptimized(sqlSuffix);
        } else {
            try {
                String query = String.format("select count(distinct T1.ID_LIEN) from %sLIEN T1 ", this.qualifier == null ? "" : this.qualifier);
                if (sqlSuffix != null) {
                    query = query + sqlSuffix;
                }
                PreparedStatement stmt = this.getConnection().prepareStatement(query);
                this.rs = stmt.executeQuery();
                this.rs.next();
                count = this.rs.getInt(1);
                query = this.getSQLBaseQuery();
                if (sqlSuffix != null) {
                    query = query + sqlSuffix;
                }
                stmt = this.getConnection().prepareStatement(query);
                this.rs = stmt.executeQuery();
            }
            catch (SQLException e) {
                throw new Exception("SELECT_FAILED", e);
            }
        }
        return count;
    }

    private int selectNoCountOptimized(String sqlSuffix) throws Exception {
        int count = -1;
        try {
            String query = this.getSQLBaseOptimizedQuery();
            if (sqlSuffix != null) {
                query = query + sqlSuffix;
            }
            if (this.ctx.getDatas().get("optimizedLimit") != null) {
                query = query + String.format(" limit 0,%s0", this.ctx.getDatas().get("optimizedLimit"));
            }
            PreparedStatement stmt = this.getConnection().prepareStatement(query);
            this.rs = stmt.executeQuery();
        }
        catch (SQLException e) {
            throw new Exception("SELECT_FAILED", e);
        }
        return -1;
    }

    public void update() throws Exception {
        try (PreparedStatement stmt = null;){
            stmt = this.getConnection().prepareStatement("update LIEN set ID_LIEN = ?, TITRE = ?, URL = ?, THEMATIQUE = ?, TYPE = ?, CATEGORIE = ?, RESUME = ?, DESCRIPTION = ?, AUTEUREDITEUR = ?, NOMRESPONSABLE = ?, EMAILRESPONSABLE = ?, CODE = ?, CODE_RUBRIQUE = ?, CODE_RATTACHEMENT = ?, META_KEYWORDS = ?, META_DESCRIPTION = ?, TITRE_ENCADRE = ?, CONTENU_ENCADRE = ?, ENCADRE_RECHERCHE = ?, ENCADRE_RECHERCHE_BIS = ?, DATE_ALERTE = ?, MESSAGE_ALERTE = ?, DATE_CREATION = ?, DATE_PROPOSITION = ?, DATE_VALIDATION = ?, DATE_MODIFICATION = ?, CODE_REDACTEUR = ?, CODE_VALIDATION = ?, LANGUE = ?, ETAT_OBJET = ?, NB_HITS = ?, DIFFUSION_PUBLIC_VISE = ?, DIFFUSION_MODE_RESTRICTION = ?, DIFFUSION_PUBLIC_VISE_RESTRICTION = ? where ID_LIEN = ?");
            stmt.setObject(1, (Object)this.getIdLien(), -5);
            stmt.setObject(2, (Object)this.getTitre(), 12);
            stmt.setObject(3, (Object)this.getUrl(), 12);
            stmt.setObject(4, (Object)this.getThematique(), -1);
            stmt.setObject(5, (Object)this.getType(), -1);
            stmt.setObject(6, (Object)this.getCategorie(), 12);
            stmt.setObject(7, (Object)this.getResume(), -1);
            stmt.setObject(8, (Object)this.getDescription(), -1);
            stmt.setObject(9, (Object)this.getAuteurediteur(), 12);
            stmt.setObject(10, (Object)this.getNomresponsable(), 12);
            stmt.setObject(11, (Object)this.getEmailresponsable(), 12);
            stmt.setObject(12, (Object)this.getCode(), 12);
            stmt.setObject(13, (Object)this.getCodeRubrique(), 12);
            stmt.setObject(14, (Object)this.getCodeRattachement(), 12);
            stmt.setObject(15, (Object)this.getMetaKeywords(), -1);
            stmt.setObject(16, (Object)this.getMetaDescription(), -1);
            stmt.setObject(17, (Object)this.getTitreEncadre(), 12);
            stmt.setObject(18, (Object)this.getContenuEncadre(), -1);
            stmt.setObject(19, (Object)this.getEncadreRecherche(), 12);
            stmt.setObject(20, (Object)this.getEncadreRechercheBis(), 12);
            stmt.setObject(21, (Object)this.getDateAlerte(), 91);
            stmt.setObject(22, (Object)this.getMessageAlerte(), -1);
            stmt.setObject(23, (Object)this.getDateCreation(), 93);
            stmt.setObject(24, (Object)this.getDateProposition(), 93);
            stmt.setObject(25, (Object)this.getDateValidation(), 93);
            stmt.setObject(26, (Object)this.getDateModification(), 93);
            stmt.setObject(27, (Object)this.getCodeRedacteur(), 12);
            stmt.setObject(28, (Object)this.getCodeValidation(), 12);
            stmt.setObject(29, (Object)this.getLangue(), 12);
            stmt.setObject(30, (Object)this.getEtatObjet(), 12);
            stmt.setObject(31, (Object)this.getNbHits(), -5);
            stmt.setObject(32, (Object)this.getDiffusionPublicVise(), 12);
            stmt.setObject(33, (Object)this.getDiffusionModeRestriction(), 12);
            stmt.setObject(34, (Object)this.getDiffusionPublicViseRestriction(), 12);
            stmt.setObject(35, (Object)this.getIdLien(), -5);
            stmt.executeUpdate();
        }
    }
}

