/**
 * Copyright (C) 2015 Kosmos contact@kosmos.fr
 *
 * Projet: cataloguelien
 * Version: 1.02.04
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kosmos.cms.module;

import org.apache.commons.lang3.StringUtils;

import com.jsbsoft.jtf.core.LangueUtil;
import com.kportal.tag.interpreteur.impl.AbstractInterpreteurTag;
import com.univ.objetspartages.om.Lien;
import com.univ.utils.ContexteUtil;

public class InterpreteurTagLien extends AbstractInterpreteurTag {

	@Override
	public String interpreterTag(String texteAInterpreter, String baliseOuvrante, String baliseFermante) throws Exception {
		// test que le tag est genere pour une jsp en front
		if (ContexteUtil.getContexteUniv().getJspWriter() != null) {
			String codeLien = StringUtils.substringBetween(texteAInterpreter, baliseOuvrante, baliseFermante);
			String langueLien = Integer.toString(LangueUtil.getIndiceLocale(ContexteUtil.getContexteUniv().getLocale()));
			int indiceLangue = codeLien.toUpperCase().indexOf(",LANGUE=");
			if (indiceLangue != -1) {
				langueLien = codeLien.substring(indiceLangue + 8);
				codeLien = codeLien.substring(0, indiceLangue);
			}
			Lien lien = Lien.getFicheLien(ContexteUtil.getContexteUniv(), codeLien, langueLien);
			// insertion de l'url de la fiche Lien
			return lien.getUrl();
		}
		return StringUtils.EMPTY;
	}

	@Override
	public String getReferenceTag(String texteAInterpreter, String baliseOuvrante, String baliseFermante) {
		// TODO Auto-generated method stub
		return null;
	}
}
