/**
 * Copyright (C) 2015 Kosmos contact@kosmos.fr
 *
 * Projet: cataloguelien
 * Version: 1.02.04
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kportal.objetpartages.oi;

import com.kportal.cms.objetspartages.oi.ObjetMail;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.Lien;

/**
 * Classe renvoyant le nom et l'adresse mail du responsable d'une fiche lien.
 *
 * @author yacouba.kone
 *
 */
public class ResponsableLienMail implements ObjetMail {

	/**
	 * Renvoie le nom du responsable d'une fiche lien à qui on envoie l'email.
	 *
	 * @return the nom responsable
	 */
	@Override
	public String getLibelle(final FicheUniv ficheUniv) {
		return ((Lien) ficheUniv).getNomresponsable();
	}

	/**
	 * Renvoie l'email du responsable d'une fiche lien à qui on écrit.
	 *
	 * @return the mailto
	 */
	@Override
	public String getAdresse(final FicheUniv ficheUniv) {
		return ((Lien) ficheUniv).getEmailresponsable();
	}
}
