/**
 * Copyright (C) 2015 Kosmos contact@kosmos.fr
 *
 * Projet: cataloguelien
 * Version: 1.02.04
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.objetspartages.bean;

import java.io.Serializable;
import java.sql.Date;

import com.kportal.cms.objetspartages.annotation.GetterAnnotation;
import com.kportal.cms.objetspartages.annotation.SetterAnnotation;

public class LienBean implements Serializable {

	private static final long serialVersionUID = 3615635575721149639L;

	/** The id lien. */
	private Long idLien = null;

	/** The titre. */
	private String titre = null;

	/** The url. */
	private String url = null;

	/** The thematique. */
	private String thematique = null;

	/** The type. */
	private String type = null;

	/** The categorie. */
	private String categorie = null;

	/** The resume. */
	private String resume = null;

	/** The description. */
	private String description = null;

	/** The auteurediteur. */
	private String auteurediteur = null;

	/** The nomresponsable. */
	private String nomresponsable = null;

	/** The emailresponsable. */
	private String emailresponsable = null;

	/** The code. */
	private String code = null;

	/** The code rubrique. */
	private String codeRubrique = null;

	/** The code rattachement. */
	private String codeRattachement = null;

	/** The meta keywords. */
	private String metaKeywords = null;

	/** The meta description. */
	private String metaDescription = null;

	/** The titre encadre. */
	private String titreEncadre = null;

	/** The contenu encadre. */
	private String contenuEncadre = null;

	/** The encadre recherche. */
	private String encadreRecherche = null;

	/** The encadre recherche bis. */
	private String encadreRechercheBis = null;

	/** The date alerte. */
	private Date dateAlerte = null;

	/** The message alerte. */
	private String messageAlerte = null;

	/** The date creation. */
	private Date dateCreation = null;

	/** The date proposition. */
	private Date dateProposition = null;

	/** The date validation. */
	private Date dateValidation = null;

	/** The date modification. */
	private Date dateModification = null;

	/** The code redacteur. */
	private String codeRedacteur = null;

	/** The code validation. */
	private String codeValidation = null;

	/** The langue. */
	private String langue = null;

	/** The etat objet. */
	private String etatObjet = null;

	/** The nb hits. */
	private Long nbHits = null;

	/** The diffusion public vise. */
	private String diffusionPublicVise = null;

	/** The diffusion mode restriction. */
	private String diffusionModeRestriction = null;

	/** The diffusion public vise restriction. */
	private String diffusionPublicViseRestriction = null;

	/**
	 * Sets the id lien.
	 * 
	 * @param idLien
	 *            the new id lien
	 */
	public void setIdLien(Long idLien) {
		this.idLien = idLien;
	}

	/**
	 * Sets the titre.
	 * 
	 * @param titre
	 *            the new titre
	 */
	public void setTitre(String titre) {
		this.titre = titre;
	}

	/**
	 * Sets the url.
	 * 
	 * @param url
	 *            the new url
	 */
	public void setUrl(String url) {
		this.url = url;
	}

	/**
	 * Sets the thematique.
	 * 
	 * @param thematique
	 *            the new thematique
	 */
	public void setThematique(String thematique) {
		this.thematique = thematique;
	}

	/**
	 * Sets the type.
	 * 
	 * @param type
	 *            the new type
	 */
	public void setType(String type) {
		this.type = type;
	}

	/**
	 * Sets the categorie.
	 * 
	 * @param categorie
	 *            the new categorie
	 */
	public void setCategorie(String categorie) {
		this.categorie = categorie;
	}

	/**
	 * Sets the resume.
	 * 
	 * @param resume
	 *            the new resume
	 */
	public void setResume(String resume) {
		this.resume = resume;
	}

	/**
	 * Sets the description.
	 * 
	 * @param description
	 *            the new description
	 */
	@SetterAnnotation(isToolbox = true)
	public void setDescription(String description) {
		this.description = description;
	}

	/**
	 * Sets the auteurediteur.
	 * 
	 * @param auteurediteur
	 *            the new auteurediteur
	 */
	public void setAuteurediteur(String auteurediteur) {
		this.auteurediteur = auteurediteur;
	}

	/**
	 * Sets the nomresponsable.
	 * 
	 * @param nomresponsable
	 *            the new nomresponsable
	 */
	public void setNomresponsable(String nomresponsable) {
		this.nomresponsable = nomresponsable;
	}

	/**
	 * Sets the emailresponsable.
	 * 
	 * @param emailresponsable
	 *            the new emailresponsable
	 */
	public void setEmailresponsable(String emailresponsable) {
		this.emailresponsable = emailresponsable;
	}

	/**
	 * Sets the code.
	 * 
	 * @param code
	 *            the new code
	 */
	public void setCode(String code) {
		this.code = code;
	}

	/**
	 * Sets the code rubrique.
	 * 
	 * @param codeRubrique
	 *            the new code rubrique
	 */
	public void setCodeRubrique(String codeRubrique) {
		this.codeRubrique = codeRubrique;
	}

	/**
	 * Sets the code rattachement.
	 * 
	 * @param codeRattachement
	 *            the new code rattachement
	 */
	public void setCodeRattachement(String codeRattachement) {
		this.codeRattachement = codeRattachement;
	}

	/**
	 * Sets the meta keywords.
	 * 
	 * @param metaKeywords
	 *            the new meta keywords
	 */
	public void setMetaKeywords(String metaKeywords) {
		this.metaKeywords = metaKeywords;
	}

	/**
	 * Sets the meta description.
	 * 
	 * @param metaDescription
	 *            the new meta description
	 */
	public void setMetaDescription(String metaDescription) {
		this.metaDescription = metaDescription;
	}

	/**
	 * Sets the titre encadre.
	 * 
	 * @param titreEncadre
	 *            the new titre encadre
	 */
	public void setTitreEncadre(String titreEncadre) {
		this.titreEncadre = titreEncadre;
	}

	/**
	 * Sets the contenu encadre.
	 * 
	 * @param contenuEncadre
	 *            the new contenu encadre
	 */
	@SetterAnnotation(isToolbox = true)
	public void setContenuEncadre(String contenuEncadre) {
		this.contenuEncadre = contenuEncadre;
	}

	/**
	 * Sets the encadre recherche.
	 * 
	 * @param encadreRecherche
	 *            the new encadre recherche
	 */
	public void setEncadreRecherche(String encadreRecherche) {
		this.encadreRecherche = encadreRecherche;
	}

	/**
	 * Sets the encadre recherche bis.
	 * 
	 * @param encadreRechercheBis
	 *            the new encadre recherche bis
	 */
	public void setEncadreRechercheBis(String encadreRechercheBis) {
		this.encadreRechercheBis = encadreRechercheBis;
	}

	/**
	 * Sets the date alerte.
	 * 
	 * @param dateAlerte
	 *            the new date alerte
	 */
	public void setDateAlerte(Date dateAlerte) {
		this.dateAlerte = dateAlerte;
	}

	/**
	 * Sets the message alerte.
	 * 
	 * @param messageAlerte
	 *            the new message alerte
	 */
	public void setMessageAlerte(String messageAlerte) {
		this.messageAlerte = messageAlerte;
	}

	/**
	 * Sets the date creation.
	 * 
	 * @param dateCreation
	 *            the new date creation
	 */
	public void setDateCreation(Date dateCreation) {
		this.dateCreation = dateCreation;
	}

	/**
	 * Sets the date proposition.
	 * 
	 * @param dateProposition
	 *            the new date proposition
	 */
	public void setDateProposition(Date dateProposition) {
		this.dateProposition = dateProposition;
	}

	/**
	 * Sets the date validation.
	 * 
	 * @param dateValidation
	 *            the new date validation
	 */
	public void setDateValidation(Date dateValidation) {
		this.dateValidation = dateValidation;
	}

	/**
	 * Sets the date modification.
	 * 
	 * @param dateModification
	 *            the new date modification
	 */
	public void setDateModification(Date dateModification) {
		this.dateModification = dateModification;
	}

	/**
	 * Sets the code redacteur.
	 * 
	 * @param codeRedacteur
	 *            the new code redacteur
	 */
	public void setCodeRedacteur(String codeRedacteur) {
		this.codeRedacteur = codeRedacteur;
	}

	/**
	 * Sets the code validation.
	 * 
	 * @param codeValidation
	 *            the new code validation
	 */
	public void setCodeValidation(String codeValidation) {
		this.codeValidation = codeValidation;
	}

	/**
	 * Sets the langue.
	 * 
	 * @param langue
	 *            the new langue
	 */
	public void setLangue(String langue) {
		this.langue = langue;
	}

	/**
	 * Sets the etat objet.
	 * 
	 * @param etatObjet
	 *            the new etat objet
	 */
	public void setEtatObjet(String etatObjet) {
		this.etatObjet = etatObjet;
	}

	/**
	 * Sets the nb hits.
	 * 
	 * @param nbHits
	 *            the new nb hits
	 */
	public void setNbHits(Long nbHits) {
		this.nbHits = nbHits;
	}

	/**
	 * Sets the diffusion public vise.
	 * 
	 * @param diffusionPublicVise
	 *            the new diffusion public vise
	 */
	public void setDiffusionPublicVise(String diffusionPublicVise) {
		this.diffusionPublicVise = diffusionPublicVise;
	}

	/**
	 * Sets the diffusion mode restriction.
	 * 
	 * @param diffusionModeRestriction
	 *            the new diffusion mode restriction
	 */
	public void setDiffusionModeRestriction(String diffusionModeRestriction) {
		this.diffusionModeRestriction = diffusionModeRestriction;
	}

	/**
	 * Sets the diffusion public vise restriction.
	 * 
	 * @param diffusionPublicViseRestriction
	 *            the new diffusion public vise restriction
	 */
	public void setDiffusionPublicViseRestriction(String diffusionPublicViseRestriction) {
		this.diffusionPublicViseRestriction = diffusionPublicViseRestriction;
	}

	/**
	 * Gets the id lien.
	 * 
	 * @return the id lien
	 */
	public Long getIdLien() {
		return idLien;
	}

	/**
	 * Gets the titre.
	 * 
	 * @return the titre
	 */
	public String getTitre() {
		return titre;
	}

	/**
	 * Gets the url.
	 * 
	 * @return the url
	 */
	public String getUrl() {
		return url;
	}

	/**
	 * Gets the thematique.
	 * 
	 * @return the thematique
	 */
	public String getThematique() {
		return thematique;
	}

	/**
	 * Gets the type.
	 * 
	 * @return the type
	 */
	public String getType() {
		return type;
	}

	/**
	 * Gets the categorie.
	 * 
	 * @return the categorie
	 */
	public String getCategorie() {
		return categorie;
	}

	/**
	 * Gets the resume.
	 * 
	 * @return the resume
	 */
	public String getResume() {
		return resume;
	}

	/**
	 * Gets the description.
	 * 
	 * @return the description
	 */
	@GetterAnnotation(isToolbox = true)
	public String getDescription() {
		return description;
	}

	/**
	 * Gets the auteurediteur.
	 * 
	 * @return the auteurediteur
	 */
	public String getAuteurediteur() {
		return auteurediteur;
	}

	/**
	 * Gets the nomresponsable.
	 * 
	 * @return the nomresponsable
	 */
	public String getNomresponsable() {
		return nomresponsable;
	}

	/**
	 * Gets the emailresponsable.
	 * 
	 * @return the emailresponsable
	 */
	public String getEmailresponsable() {
		return emailresponsable;
	}

	/**
	 * Gets the code.
	 * 
	 * @return the code
	 */
	public String getCode() {
		return code;
	}

	/**
	 * Gets the code rubrique.
	 * 
	 * @return the code rubrique
	 */
	public String getCodeRubrique() {
		return codeRubrique;
	}

	/**
	 * Gets the code rattachement.
	 * 
	 * @return the code rattachement
	 */
	public String getCodeRattachement() {
		return codeRattachement;
	}

	/**
	 * Gets the meta keywords.
	 * 
	 * @return the meta keywords
	 */
	public String getMetaKeywords() {
		return metaKeywords;
	}

	/**
	 * Gets the meta description.
	 * 
	 * @return the meta description
	 */
	public String getMetaDescription() {
		return metaDescription;
	}

	/**
	 * Gets the titre encadre.
	 * 
	 * @return the titre encadre
	 */
	public String getTitreEncadre() {
		return titreEncadre;
	}

	/**
	 * Gets the contenu encadre.
	 * 
	 * @return the contenu encadre
	 */
	@GetterAnnotation(isToolbox = true)
	public String getContenuEncadre() {
		return contenuEncadre;
	}

	/**
	 * Gets the encadre recherche.
	 * 
	 * @return the encadre recherche
	 */
	public String getEncadreRecherche() {
		return encadreRecherche;
	}

	/**
	 * Gets the encadre recherche bis.
	 * 
	 * @return the encadre recherche bis
	 */
	public String getEncadreRechercheBis() {
		return encadreRechercheBis;
	}

	/**
	 * Gets the date alerte.
	 * 
	 * @return the date alerte
	 */
	public Date getDateAlerte() {
		return dateAlerte;
	}

	/**
	 * Gets the message alerte.
	 * 
	 * @return the message alerte
	 */
	public String getMessageAlerte() {
		return messageAlerte;
	}

	/**
	 * Gets the date creation.
	 * 
	 * @return the date creation
	 */
	public Date getDateCreation() {
		return dateCreation;
	}

	/**
	 * Gets the date proposition.
	 * 
	 * @return the date proposition
	 */
	public Date getDateProposition() {
		return dateProposition;
	}

	/**
	 * Gets the date validation.
	 * 
	 * @return the date validation
	 */
	public Date getDateValidation() {
		return dateValidation;
	}

	/**
	 * Gets the date modification.
	 * 
	 * @return the date modification
	 */
	public Date getDateModification() {
		return dateModification;
	}

	/**
	 * Gets the code redacteur.
	 * 
	 * @return the code redacteur
	 */
	public String getCodeRedacteur() {
		return codeRedacteur;
	}

	/**
	 * Gets the code validation.
	 * 
	 * @return the code validation
	 */
	public String getCodeValidation() {
		return codeValidation;
	}

	/**
	 * Gets the langue.
	 * 
	 * @return the langue
	 */
	public String getLangue() {
		return langue;
	}

	/**
	 * Gets the etat objet.
	 * 
	 * @return the etat objet
	 */
	public String getEtatObjet() {
		return etatObjet;
	}

	/**
	 * Gets the nb hits.
	 * 
	 * @return the nb hits
	 */
	public Long getNbHits() {
		return nbHits;
	}

	/**
	 * Gets the diffusion public vise.
	 * 
	 * @return the diffusion public vise
	 */
	public String getDiffusionPublicVise() {
		return diffusionPublicVise;
	}

	/**
	 * Gets the diffusion mode restriction.
	 * 
	 * @return the diffusion mode restriction
	 */
	public String getDiffusionModeRestriction() {
		return diffusionModeRestriction;
	}

	/**
	 * Gets the diffusion public vise restriction.
	 * 
	 * @return the diffusion public vise restriction
	 */
	public String getDiffusionPublicViseRestriction() {
		return diffusionPublicViseRestriction;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return toString(".");
	}

	/**
	 * To string.
	 * 
	 * @param aSeparator
	 *            the a separator
	 * 
	 * @return the string
	 */
	public String toString(String aSeparator) {
		String s = "" + getIdLien() + aSeparator + getTitre() + aSeparator + getUrl() + aSeparator + getThematique() + aSeparator + getType() + aSeparator + getCategorie() + aSeparator + getResume() + aSeparator + getDescription() + aSeparator + getAuteurediteur() + aSeparator + getNomresponsable() + aSeparator + getEmailresponsable() + aSeparator + getCode() + aSeparator + getCodeRubrique() + aSeparator + getCodeRattachement() + aSeparator + getMetaKeywords() + aSeparator + getMetaDescription() + aSeparator + getTitreEncadre() + aSeparator + getContenuEncadre() + aSeparator + getEncadreRecherche() + aSeparator + getEncadreRechercheBis() + aSeparator + getDateAlerte() + aSeparator + getMessageAlerte() + aSeparator + getDateCreation() + aSeparator + getDateProposition() + aSeparator + getDateValidation() + aSeparator + getDateModification() + aSeparator + getCodeRedacteur() + aSeparator + getCodeValidation() + aSeparator + getLangue() + aSeparator + getEtatObjet() + aSeparator + getNbHits() + aSeparator + getDiffusionPublicVise() + aSeparator + getDiffusionModeRestriction() + aSeparator + getDiffusionPublicViseRestriction();
		return s;
	}
}
