/**
 * Copyright (C) 2015 Kosmos contact@kosmos.fr
 *
 * Projet: cataloguelien
 * Version: 1.02.04
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.objetspartages.misc;

import static com.univ.objetspartages.util.CritereRechercheUtil.getCritereChaineAvecLibelle;
import static com.univ.objetspartages.util.CritereRechercheUtil.getCritereTexteNonVideFormater;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import com.jsbsoft.jtf.core.InfoBean;
import com.jsbsoft.jtf.database.OMContext;
import com.univ.objetspartages.om.AbstractRechercheExterne;
import com.univ.objetspartages.om.Libelle;
import com.univ.objetspartages.util.CritereRecherche;
import com.univ.utils.RechercheFicheHelper;

// TODO: Auto-generated Javadoc
/**
 * The Class RechercheKosmosLien.
 */
public class RechercheLien extends AbstractRechercheExterne {

	/**
	 * Prepare le formulaire de recherche.
	 * 
	 * @param infoBean
	 *            the info bean
	 * @param ctx
	 *            the ctx
	 * 
	 * @return true, if preparer recherche
	 * 
	 * @throws Exception
	 *             the exception
	 */
	@Override
	public boolean preparerRECHERCHE(final InfoBean infoBean, final OMContext ctx) throws Exception {
		boolean rechercheEffectuee = false;
		final String objet = StringUtils.defaultString(infoBean.getString("OBJET"), "").toUpperCase();
		final Locale locale = ctx.getLocale();
		if (objet.equals("LIEN")) {
			infoBean.set("LISTE_THEMATIQUES", Libelle.getListe("04", locale));
			infoBean.set("LISTE_TYPES", Libelle.getListe("70", locale));
			infoBean.set("LISTE_CATEGORIES", Libelle.getListe("71", locale));
			rechercheEffectuee = true;
		}
		return rechercheEffectuee;
	}

	/**
	 * Traite la recherche.
	 * 
	 * @param infoBean
	 *            the info bean
	 * @param ctx
	 *            the ctx
	 * 
	 * @return true, if traiter recherche
	 * 
	 * @throws Exception
	 *             the exception
	 */
	@Override
	public boolean traiterRECHERCHE(final InfoBean infoBean, final OMContext ctx) throws Exception {
		boolean rechercheEffectuee = false;
		final String objet = infoBean.getString("OBJET");
		if (objet.equalsIgnoreCase("LIEN")) {
			final List<CritereRecherche> criteres = new ArrayList<>();
			criteres.add(new CritereRecherche("OBJET", objet, StringUtils.EMPTY));
			CollectionUtils.addIgnoreNull(criteres, getCritereTexteNonVideFormater(infoBean, "TITRE"));
			CollectionUtils.addIgnoreNull(criteres, getCritereChaineAvecLibelle(infoBean, "THEMATIQUE", "04"));
			CollectionUtils.addIgnoreNull(criteres, getCritereChaineAvecLibelle(infoBean, "TYPE", "70"));
			CollectionUtils.addIgnoreNull(criteres, getCritereChaineAvecLibelle(infoBean, "CATEGORIE", "71"));
			CollectionUtils.addIgnoreNull(criteres, getCritereTexteNonVideFormater(infoBean, "URL"));
			CollectionUtils.addIgnoreNull(criteres, getCritereTexteNonVideFormater(infoBean, "AUTEUREDITEUR"));
			CollectionUtils.addIgnoreNull(criteres, getCritereTexteNonVideFormater(infoBean, "NOMRESPONSABLE"));
			CollectionUtils.addIgnoreNull(criteres, getCritereTexteNonVideFormater(infoBean, "DESCRIPTION"));
			rechercheEffectuee = true;
			// attribut commun à toute les fiches
			criteres.addAll(getCritereDefaut(infoBean));
			infoBean.set(RechercheFicheHelper.ATTRIBUT_INFOBEAN_CRITERES, criteres);
			gestionAncienFront(infoBean, criteres);
		}
		return rechercheEffectuee;
	}

	@Override
	public List<String> getCriteresRequete(final String objet, final boolean listeIncluse) {
		final List<String> criteres = new ArrayList<>();
		if (objet.equals("LIEN")) {
			criteres.add("TITRE");
			criteres.add("URL");
			criteres.add("AUTEUREDITEUR");
			criteres.add("NOMRESPONSABLE");
			criteres.add("THEMATIQUE");
			criteres.add("TYPE");
			criteres.add("CATEGORIE");
			criteres.add("DATE_DEBUT");
			criteres.add("DATE_FIN");
			if (listeIncluse) {
				criteres.add("SELECTION");
				criteres.add("JOUR");
				criteres.add("TRI_DATE");
			}
		}
		return criteres;
	}
}
