/**
 * Copyright (C) 2015 Kosmos contact@kosmos.fr
 *
 * Projet: cataloguelien
 * Version: 1.02.04
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.objetspartages.processus;

import java.util.Vector;

import com.jsbsoft.jtf.core.InfoBean;
import com.jsbsoft.jtf.core.LangueUtil;
import com.univ.objetspartages.om.Libelle;
import com.univ.objetspartages.om.Lien;

/**
 * Processus de gestion des liens.
 */
public class SaisieLien extends SaisieFiche {

	/** The lien. */
	private Lien lien = null;

	/**
	 * Constructeur.
	 *
	 * @param infoBean
	 *            the info bean
	 */
	public SaisieLien(final InfoBean infoBean) {
		super(infoBean);
	}

	/**
	 * Point d'entree du processus.
	 *
	 * @return true, if traiter action
	 *
	 * @throws Exception
	 *             the exception
	 */
	@Override
	public boolean traiterAction() throws Exception {
		infoBean.set("CODE_OBJET", "0018");
		lien = new Lien();
		lien.setCtx(this);
		lien.init();
		traiterActionParDefaut(lien);
		infoBean.set("NOM_ONGLET", "lien");
		// on continue si on n'est pas a la FIN !!!
		return (etat == FIN);
	}

	/**
	 * Affichage de l'ecran des criteres de recherche d'un(e) lien.
	 *
	 * @throws Exception
	 *             the exception
	 */
	@Override
	protected void preparerRECHERCHE() throws Exception {
		ecranLogique = ECRAN_RECHERCHE;
		infoBean.set("LISTE_LANGUES", LangueUtil.getListeLangues(getLocale()));
		infoBean.set("LISTE_THEMATIQUES", Libelle.getListe("04", getLocale()));
		infoBean.set("LISTE_TYPES", Libelle.getListe("70", getLocale()));
		infoBean.set("LISTE_CATEGORIES", Libelle.getListe("71", getLocale()));
	}

	/**
	 * Affichage de l'ecran de saisie d'un(e) lien.
	 *
	 * @throws Exception
	 *             the exception
	 */
	@Override
	protected void preparerPRINCIPAL() throws Exception {
		ecranLogique = ECRAN_PRINCIPAL;
		infoBean.set("ID_LIEN", lien.getIdLien().toString());
		infoBean.set("TITRE", lien.getTitre());
		infoBean.set("URL", lien.getUrl());
		infoBean.set("THEMATIQUE", lien.getThematique());
		infoBean.set("LIBELLE_THEMATIQUE", lien.getLibelleThematique());
		infoBean.set("LISTE_THEMATIQUES", Libelle.getListe("04", LangueUtil.getLocale(lien.getLangue())));
		infoBean.set("TYPE", lien.getType());
		infoBean.set("LIBELLE_TYPE", lien.getLibelleType());
		infoBean.set("LISTE_TYPES", Libelle.getListe("70", LangueUtil.getLocale(lien.getLangue())));
		infoBean.set("CATEGORIE", lien.getCategorie());
		infoBean.set("LIBELLE_CATEGORIE", lien.getLibelleCategorie());
		infoBean.set("LISTE_CATEGORIES", Libelle.getListe("71", LangueUtil.getLocale(lien.getLangue())));
		infoBean.set("RESUME", lien.getResume());
		infoBean.set("DESCRIPTION", lien.getDescription());
		infoBean.set("AUTEUREDITEUR", lien.getAuteurediteur());
		infoBean.set("NOMRESPONSABLE", lien.getNomresponsable());
		infoBean.set("EMAILRESPONSABLE", lien.getEmailresponsable());
		infoBean.set("CODE_RUBRIQUE", lien.getCodeRubrique());
		infoBean.set("LIBELLE_CODE_RUBRIQUE", lien.getInfosRubrique().getLibelleAffichable());
		infoBean.set("CODE_RATTACHEMENT", lien.getCodeRattachement());
		infoBean.set("LIBELLE_CODE_RATTACHEMENT", lien.getInfosStructure().getLibelleAffichable());
		infoBean.set("LIBELLE_AFFICHABLE", lien.getLibelleAffichable());
		if (infoBean.get("SAISIE_FRONT") == null) {
			infoBean.set("SOUS_ONGLET", "PRINCIPAL"); // onglet par defaut
		}
		if (infoBean.get("SAISIE_FRONT") != null) {
			// dans le front, les types , categories et thematiques sont selectionnes via des cases a cocher
			int iType = 0;
			int iCateg = 0;
			int iThem = 0;
			// tri des types par libellés
			final Libelle libelle = new Libelle();
			libelle.setCtx(this);
			if (libelle.select("WHERE TYPE='70' AND LANGUE='0' ORDER BY LIBELLE") > 0) {
				String valeurType = "0";
				while (libelle.nextItem()) {
					valeurType = "0";
					if (lien.getType().contains(libelle.getCode())) {
						valeurType = "1";
					}
					infoBean.set("CODE_TYPE#" + iType, libelle.getCode());
					infoBean.set("LIBELLE_TYPE#" + iType, libelle.getLibelle());
					infoBean.set("VALEUR_TYPE#" + iType, valeurType);
					iType++;
				}
			}
			infoBean.set("TYPES_NB_ITEMS", iType);
			if (libelle.select("WHERE TYPE='71' AND LANGUE='0' ORDER BY LIBELLE") > 0) {
				String valeurCategorie;
				while (libelle.nextItem()) {
					valeurCategorie = "0";
					if (lien.getCategorie().contains(libelle.getCode())) {
						valeurCategorie = "1";
					}
					infoBean.set("CODE_CATEGORIE#" + iCateg, libelle.getCode());
					infoBean.set("LIBELLE_CATEGORIE#" + iCateg, libelle.getLibelle());
					infoBean.set("VALEUR_CATEGORIE#" + iCateg, valeurCategorie);
					iCateg++;
				}
			}
			infoBean.set("CATEGORIES_NB_ITEMS", iCateg);
			if (libelle.select("WHERE TYPE='04' AND LANGUE='0' ORDER BY LIBELLE") > 0) {
				String valeurThematique;
				while (libelle.nextItem()) {
					valeurThematique = "0";
					if (lien.getThematique().contains(libelle.getCode())) {
						valeurThematique = "1";
					}
					infoBean.set("CODE_THEMATIQUE#" + iThem, libelle.getCode());
					infoBean.set("LIBELLE_THEMATIQUE#" + iThem, libelle.getLibelle());
					infoBean.set("VALEUR_THEMATIQUE#" + iThem, valeurThematique);
					iThem++;
				}
			}
			infoBean.set("THEMATIQUES_NB_ITEMS", iThem);
		}
		ControleurUniv.preparerPRINCIPAL(infoBean, lien, this);
	}

	/**
	 * Traite l'ecran de saisie d'une fiche.
	 *
	 * @throws Exception
	 *             the exception
	 */
	@Override
	protected void traiterPRINCIPAL() throws Exception {
		// chargement de l'objet
		if (infoBean.getEtatObjet().equals(InfoBean.ETAT_OBJET_CREATION)) {
			lien.init();
		} else {
			lien.setIdLien(new Long(infoBean.getString("ID_LIEN")));
			lien.retrieve();
		}
		// changement d'onglet
		if (action.equals(InfoBean.ACTION_ONGLET)) {
			infoBean.set("SOUS_ONGLET", infoBean.getString("SOUS_ONGLET_DEMANDE"));
		}
		// validation de l'ecran
		else if (action.equals(InfoBean.ACTION_ENREGISTRER)) {
			if (infoBean.getEtatObjet().equals(InfoBean.ETAT_OBJET_CREATION)) {
				// donnees saisissables uniquement en creation
				lien.setLangue(infoBean.getString("LANGUE"));
				lien.setCode(Long.toString(System.currentTimeMillis()));
			}
			lien.setTitre((String) infoBean.get("TITRE"));
			lien.setUrl((String) infoBean.get("URL"));
			lien.setResume((String) infoBean.get("RESUME"));
			lien.setDescription((String) infoBean.get("DESCRIPTION"));
			lien.setAuteurediteur((String) infoBean.get("AUTEUREDITEUR"));
			lien.setNomresponsable((String) infoBean.get("NOMRESPONSABLE"));
			lien.setEmailresponsable((String) infoBean.get("EMAILRESPONSABLE"));
			lien.setCodeRubrique(infoBean.getString("CODE_RUBRIQUE"));
			lien.setCodeRattachement(infoBean.getString("CODE_RATTACHEMENT"));
			if (infoBean.get("SAISIE_FRONT") != null) {
				//dans le front, les thématiques sont des cases a cocher
				if (infoBean.get("THEMATIQUES_NB_ITEMS") != null) {
					final Vector<String> v = new Vector<>();
					for (int j = 0; j < Integer.parseInt(infoBean.getString("THEMATIQUES_NB_ITEMS")); j++) {
						if (infoBean.getString("VALEUR_THEMATIQUE#" + j) != null && infoBean.getString("VALEUR_THEMATIQUE#" + j).equals("1")) {
							v.add(infoBean.getString("CODE_THEMATIQUE#" + j));
						}
					}
					lien.setVecteurThematiques(v);
				}
				//dans le front, les types sont des cases a cocher
				if (infoBean.get("TYPES_NB_ITEMS") != null) {
					final Vector<String> v = new Vector<>();
					for (int j = 0; j < Integer.parseInt(infoBean.getString("TYPES_NB_ITEMS")); j++) {
						if (infoBean.getString("VALEUR_TYPE#" + j) != null && infoBean.getString("VALEUR_TYPE#" + j).equals("1")) {
							v.add(infoBean.getString("CODE_TYPE#" + j));
						}
					}
					lien.setVecteurTypes(v);
				}
				//dans le front, les catégories sont des cases a cocher
				if (infoBean.get("CATEGORIES_NB_ITEMS") != null) {
					final Vector<String> v = new Vector<>();
					for (int j = 0; j < Integer.parseInt(infoBean.getString("CATEGORIES_NB_ITEMS")); j++) {
						if (infoBean.getString("VALEUR_CATEGORIE#" + j) != null && infoBean.getString("VALEUR_CATEGORIE#" + j).equals("1")) {
							v.add(infoBean.getString("CODE_CATEGORIE#" + j));
						}
					}
					lien.setVecteurCategories(v);
				}
			} else {
				lien.setThematique((String) infoBean.get("THEMATIQUE"));
				lien.setType((String) infoBean.get("TYPE"));
				lien.setCategorie((String) infoBean.get("CATEGORIE"));
			}
		}
		// appel au traitement general
		ecranLogique = ControleurUniv.traiterPRINCIPAL(infoBean, lien, this);
		if (ecranLogique.length() == 0) {
			etat = FIN;
		}
	}
}
