/**
 * Copyright (C) 2015 Kosmos contact@kosmos.fr
 *
 * Projet: cataloguelien
 * Version: 1.02.04
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.objetspartages.sgbd;

import com.jsbsoft.jtf.database.OMContext;
import com.univ.objetspartages.bean.LienBean;
import org.apache.commons.lang3.StringUtils;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;

// TODO: Auto-generated Javadoc
/**
 * Classe d'acces aux donnees pour lien.
 */
public class LienDB extends LienBean {

	/**
	 *
	 */
	private static final long serialVersionUID = 5480953915133538233L;

	/** The ctx. */
	protected transient OMContext ctx = null;

	/** The qualifier. */
	protected transient String qualifier = null;

	/** The rs. */
	private transient ResultSet rs = null;

	/**
	 * Sets the ctx.
	 *
	 * @param _ctx
	 *            the new ctx
	 */
	public void setCtx(final OMContext _ctx) {
		ctx = _ctx;
	}

	/**
	 * Sets the qualifier.
	 *
	 * @param qualifier
	 *            the new qualifier
	 */
	public void setQualifier(final String qualifier) {
		this.qualifier = qualifier;
	}

	/**
	 * Gets the connection.
	 *
	 * @return the connection
	 */
	private Connection getConnection() {
		return ctx.getConnection();
	}

	/**
	 * Adds the.
	 *
	 * @throws Exception
	 *             the exception
	 */
	public void add() throws Exception {
		PreparedStatement stmt = null;
		ResultSet rs = null;
		try {
			stmt = getConnection().prepareStatement("insert into LIEN (ID_LIEN , TITRE , URL , THEMATIQUE , TYPE , CATEGORIE , RESUME , DESCRIPTION , AUTEUREDITEUR , NOMRESPONSABLE , EMAILRESPONSABLE , CODE , CODE_RUBRIQUE , CODE_RATTACHEMENT , META_KEYWORDS , META_DESCRIPTION , TITRE_ENCADRE , CONTENU_ENCADRE , ENCADRE_RECHERCHE , ENCADRE_RECHERCHE_BIS , DATE_ALERTE , MESSAGE_ALERTE , DATE_CREATION , DATE_PROPOSITION , DATE_VALIDATION , DATE_MODIFICATION , CODE_REDACTEUR , CODE_VALIDATION , LANGUE , ETAT_OBJET , NB_HITS , DIFFUSION_PUBLIC_VISE , DIFFUSION_MODE_RESTRICTION , DIFFUSION_PUBLIC_VISE_RESTRICTION) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", PreparedStatement.RETURN_GENERATED_KEYS);
			stmt.setObject(1, getIdLien(), Types.BIGINT);
			stmt.setObject(2, getTitre(), Types.VARCHAR);
			stmt.setObject(3, getUrl(), Types.VARCHAR);
			stmt.setObject(4, getThematique(), Types.LONGVARCHAR);
			stmt.setObject(5, getType(), Types.LONGVARCHAR);
			stmt.setObject(6, getCategorie(), Types.VARCHAR);
			stmt.setObject(7, getResume(), Types.LONGVARCHAR);
			stmt.setObject(8, getDescription(), Types.LONGVARCHAR);
			stmt.setObject(9, getAuteurediteur(), Types.VARCHAR);
			stmt.setObject(10, getNomresponsable(), Types.VARCHAR);
			stmt.setObject(11, getEmailresponsable(), Types.VARCHAR);
			stmt.setObject(12, getCode(), Types.VARCHAR);
			stmt.setObject(13, getCodeRubrique(), Types.VARCHAR);
			stmt.setObject(14, getCodeRattachement(), Types.VARCHAR);
			stmt.setObject(15, getMetaKeywords(), Types.LONGVARCHAR);
			stmt.setObject(16, getMetaDescription(), Types.LONGVARCHAR);
			stmt.setObject(17, getTitreEncadre(), Types.VARCHAR);
			stmt.setObject(18, getContenuEncadre(), Types.LONGVARCHAR);
			stmt.setObject(19, getEncadreRecherche(), Types.VARCHAR);
			stmt.setObject(20, getEncadreRechercheBis(), Types.VARCHAR);
			stmt.setObject(21, getDateAlerte(), Types.DATE);
			stmt.setObject(22, getMessageAlerte(), Types.LONGVARCHAR);
			stmt.setObject(23, getDateCreation(), Types.TIMESTAMP);
			stmt.setObject(24, getDateProposition(), Types.TIMESTAMP);
			stmt.setObject(25, getDateValidation(), Types.TIMESTAMP);
			stmt.setObject(26, getDateModification(), Types.TIMESTAMP);
			stmt.setObject(27, getCodeRedacteur(), Types.VARCHAR);
			stmt.setObject(28, getCodeValidation(), Types.VARCHAR);
			stmt.setObject(29, getLangue(), Types.VARCHAR);
			stmt.setObject(30, getEtatObjet(), Types.VARCHAR);
			stmt.setObject(31, getNbHits(), Types.BIGINT);
			stmt.setObject(32, getDiffusionPublicVise(), Types.VARCHAR);
			stmt.setObject(33, getDiffusionModeRestriction(), Types.VARCHAR);
			stmt.setObject(34, getDiffusionPublicViseRestriction(), Types.VARCHAR);
			final int rowsAffected = stmt.executeUpdate();
			if (rowsAffected == 0) {
				throw new Exception("METHOD_AFFCTD_NOROWS");
			} else if (rowsAffected > 1) {
				throw new Exception("METHOD_AFFCTD_MULTROWS");
			}
			rs = stmt.getGeneratedKeys();
			rs.next();
			setIdLien(rs.getLong(1));
		} catch (final SQLException e) {
			throw new Exception("ERROR_IN_METHOD add()", e);
		} finally {
			if (rs != null) {
				rs.close();
			}
			if (stmt != null) {
				stmt.close();
			}
		}
	}

	/**
	 * Delete.
	 *
	 * @throws Exception
	 *             the exception
	 */
	public void delete() throws Exception {
		PreparedStatement stmt = null;
		try {
			stmt = getConnection().prepareStatement("delete from LIEN where ID_LIEN = ?");
			// put parameters into statement
			stmt.setObject(1, getIdLien(), Types.BIGINT);
			final int rowsAffected = stmt.executeUpdate();
			if (rowsAffected == 0) {
				throw new Exception("METHOD_AFFCTD_NOROWS");
			} else if (rowsAffected > 1) {
				throw new Exception("METHOD_AFFCTD_MULTROWS");
			}
		} catch (final SQLException e) {
			throw new Exception("ERROR_IN_METHOD delete()", e);
		} finally {
			if (stmt != null) {
				stmt.close();
			}
		}
	}

	/**
	 * Gets the sQL base query.
	 *
	 * @return the sQL base query
	 */
	public String getSQLBaseQuery() {
		return String.format("select distinct T1.ID_LIEN, T1.TITRE, T1.URL, T1.THEMATIQUE, T1.TYPE, T1.CATEGORIE, T1.RESUME, T1.DESCRIPTION, T1.AUTEUREDITEUR, T1.NOMRESPONSABLE, T1.EMAILRESPONSABLE, T1.CODE, T1.CODE_RUBRIQUE, T1.CODE_RATTACHEMENT, T1.META_KEYWORDS, T1.META_DESCRIPTION, T1.TITRE_ENCADRE, T1.CONTENU_ENCADRE, T1.ENCADRE_RECHERCHE, T1.ENCADRE_RECHERCHE_BIS, T1.DATE_ALERTE, T1.MESSAGE_ALERTE, T1.DATE_CREATION, T1.DATE_PROPOSITION, T1.DATE_VALIDATION, T1.DATE_MODIFICATION, T1.CODE_REDACTEUR, T1.CODE_VALIDATION, T1.LANGUE, T1.ETAT_OBJET, T1.NB_HITS, T1.DIFFUSION_PUBLIC_VISE, T1.DIFFUSION_MODE_RESTRICTION, T1.DIFFUSION_PUBLIC_VISE_RESTRICTION from %sLIEN T1 ", qualifier == null ? StringUtils.EMPTY : qualifier);
	}

	/**
	 * Gets the sQL base optimized query.
	 *
	 * @return the sQL base optimized query
	 */
	public String getSQLBaseOptimizedQuery() {
		return String.format("select T1.ID_LIEN, T1.CODE, T1.LANGUE from %sLIEN T1 ", qualifier == null ? StringUtils.EMPTY : qualifier);
	}

	/**
	 * Renvoie l'element suivant du ResultSet.
	 *
	 * @return true, if next item
	 *
	 * @throws Exception
	 *             the exception
	 */
	public boolean nextItem() throws Exception {
		boolean res = false;
		try {
			if (rs.next()) {
				if (ctx.getDatas().get("optimizedSelect") != null) {
					retrieveFromOptimizedRS();
				} else {
					retrieveFromRS();
				}
				res = true;
			} else {
				try {
					rs.close();
				} finally {
					rs = null;
				}
			}
		} catch (final Exception e) {
			throw new Exception("ERROR_IN_METHOD nextItem()", e);
		}
		return res;
	}

	/**
	 * Recuperation d'une ligne de la base de donnees.
	 *
	 * @throws Exception
	 *             the exception
	 */
	public void retrieve() throws Exception {
		PreparedStatement stmt = null;
		try {
			stmt = getConnection().prepareStatement("select T1.ID_LIEN, T1.TITRE, T1.URL, T1.THEMATIQUE, T1.TYPE, T1.CATEGORIE, T1.RESUME, T1.DESCRIPTION, T1.AUTEUREDITEUR, T1.NOMRESPONSABLE, T1.EMAILRESPONSABLE, T1.CODE, T1.CODE_RUBRIQUE, T1.CODE_RATTACHEMENT, T1.META_KEYWORDS, T1.META_DESCRIPTION, T1.TITRE_ENCADRE, T1.CONTENU_ENCADRE, T1.ENCADRE_RECHERCHE, T1.ENCADRE_RECHERCHE_BIS, T1.DATE_ALERTE, T1.MESSAGE_ALERTE, T1.DATE_CREATION, T1.DATE_PROPOSITION, T1.DATE_VALIDATION, T1.DATE_MODIFICATION, T1.CODE_REDACTEUR, T1.CODE_VALIDATION, T1.LANGUE, T1.ETAT_OBJET, T1.NB_HITS, T1.DIFFUSION_PUBLIC_VISE, T1.DIFFUSION_MODE_RESTRICTION, T1.DIFFUSION_PUBLIC_VISE_RESTRICTION from LIEN T1 where T1.ID_LIEN = ?");
			stmt.setObject(1, getIdLien(), Types.BIGINT);
			rs = stmt.executeQuery();
			if (!rs.next()) {
				throw new Exception("retrieve : METHOD_NO_RESULTS");
			}
			retrieveFromRS();
		} catch (final SQLException e) {
			throw new Exception("ERROR_IN_METHOD retrieve()", e);
		} finally {
			if (rs != null) {
				rs.close();
			}
			if (stmt != null) {
				stmt.close();
			}
		}
	}

	/**
	 * Retrieve from rs.
	 *
	 * @throws Exception
	 *             the exception
	 */
	private void retrieveFromRS() throws Exception {
		try {
			// get output from result set
			setIdLien(rs.getLong(1));
			setTitre(rs.getString(2));
			setUrl(rs.getString(3));
			setThematique(rs.getString(4));
			setType(rs.getString(5));
			setCategorie(rs.getString(6));
			setResume(rs.getString(7));
			setDescription(rs.getString(8));
			setAuteurediteur(rs.getString(9));
			setNomresponsable(rs.getString(10));
			setEmailresponsable(rs.getString(11));
			setCode(rs.getString(12));
			setCodeRubrique(rs.getString(13));
			setCodeRattachement(rs.getString(14));
			setMetaKeywords(rs.getString(15));
			setMetaDescription(rs.getString(16));
			setTitreEncadre(rs.getString(17));
			setContenuEncadre(rs.getString(18));
			setEncadreRecherche(rs.getString(19));
			setEncadreRechercheBis(rs.getString(20));
			setDateAlerte(rs.getDate(21));
			setMessageAlerte(rs.getString(22));
			setDateCreation(new Date(rs.getTimestamp(23).getTime()));
			setDateProposition(new Date(rs.getTimestamp(24).getTime()));
			setDateValidation(new Date(rs.getTimestamp(25).getTime()));
			setDateModification(new Date(rs.getTimestamp(26).getTime()));
			setCodeRedacteur(rs.getString(27));
			setCodeValidation(rs.getString(28));
			setLangue(rs.getString(29));
			setEtatObjet(rs.getString(30));
			setNbHits(rs.getLong(31));
			setDiffusionPublicVise(rs.getString(32));
			setDiffusionModeRestriction(rs.getString(33));
			setDiffusionPublicViseRestriction(rs.getString(34));
		} catch (final SQLException e) {
			throw new Exception("ERROR_IN_METHOD retrieveFromRS()", e);
		}
	}

	/**
	 * Retrieve from optimized rs.
	 *
	 * @throws Exception
	 *             the exception
	 */
	private void retrieveFromOptimizedRS() throws Exception {
		try {
			// get output from result set
			setIdLien(rs.getLong(1));
			setCode(rs.getString(2));
			setLangue(rs.getString(3));
		} catch (final SQLException e) {
			throw new Exception("ERROR_IN_METHOD retrieveFromOptimizedRS()", e);
		}
	}

	/**
	 * Cette methode optimise l'execution de la requete (pas de count).
	 *
	 * @param sqlSuffix
	 *            the sql suffix
	 *
	 * @throws Exception
	 *             the exception
	 */
	public void selectNoCount(final String sqlSuffix) throws Exception {
		PreparedStatement stmt = null;
		try {
			String query = getSQLBaseQuery();
			if (sqlSuffix != null) {
				query += sqlSuffix;
			}
			stmt = getConnection().prepareStatement(query);
			rs = stmt.executeQuery();
		} catch (final SQLException e) {
			throw new Exception("SELECT_FAILED", e);
		}
	}

	/**
	 * Select.
	 *
	 * @param sqlSuffix
	 *            the sql suffix
	 *
	 * @return the int
	 *
	 * @throws Exception
	 *             the exception
	 */
	public int select(final String sqlSuffix) throws Exception {
		int count;
		if (ctx.getDatas().get("optimizedObject") != null && ctx.getDatas().get("optimizedSelect") != null) {
			count = selectNoCountOptimized(sqlSuffix);
		} else {
			PreparedStatement stmt;
			try {
				// recuperation nombre de lignes
				String query = String.format("select count(distinct T1.ID_LIEN) from %sLIEN T1 ", qualifier == null ? StringUtils.EMPTY : qualifier);
				if (sqlSuffix != null) {
					query += sqlSuffix;
				}
				stmt = getConnection().prepareStatement(query);
				rs = stmt.executeQuery();
				rs.next();
				count = rs.getInt(1);
				// execution requete
				query = getSQLBaseQuery();
				if (sqlSuffix != null) {
					query += sqlSuffix;
				}
				stmt = getConnection().prepareStatement(query);
				rs = stmt.executeQuery();
			} catch (final SQLException e) {
				throw new Exception("SELECT_FAILED", e);
			}
		}
		return count;
	}

	/**
	 * Select no count optimized.
	 *
	 * @param sqlSuffix
	 *            the sql suffix
	 *
	 * @return the int
	 *
	 * @throws Exception
	 *             the exception
	 */
	private int selectNoCountOptimized(final String sqlSuffix) throws Exception {
		PreparedStatement stmt;
		final int count = -1;
		try {
			String query = getSQLBaseOptimizedQuery();
			if (sqlSuffix != null) {
				query += sqlSuffix;
			}
			if (ctx.getDatas().get("optimizedLimit") != null) {
				query += String.format(" limit 0,%s0", ctx.getDatas().get("optimizedLimit"));
			}
			stmt = getConnection().prepareStatement(query);
			rs = stmt.executeQuery();
		} catch (final SQLException e) {
			throw new Exception("SELECT_FAILED", e);
		}
		return count;
	}

	/**
	 * Mise a jour d'une ligne de la base de donnees.
	 *
	 * @throws Exception
	 *             the exception
	 */
	public void update() throws Exception {
		PreparedStatement stmt = null;
		try {
			stmt = getConnection().prepareStatement("update LIEN set ID_LIEN = ?, TITRE = ?, URL = ?, THEMATIQUE = ?, TYPE = ?, CATEGORIE = ?, RESUME = ?, DESCRIPTION = ?, AUTEUREDITEUR = ?, NOMRESPONSABLE = ?, EMAILRESPONSABLE = ?, CODE = ?, CODE_RUBRIQUE = ?, CODE_RATTACHEMENT = ?, META_KEYWORDS = ?, META_DESCRIPTION = ?, TITRE_ENCADRE = ?, CONTENU_ENCADRE = ?, ENCADRE_RECHERCHE = ?, ENCADRE_RECHERCHE_BIS = ?, DATE_ALERTE = ?, MESSAGE_ALERTE = ?, DATE_CREATION = ?, DATE_PROPOSITION = ?, DATE_VALIDATION = ?, DATE_MODIFICATION = ?, CODE_REDACTEUR = ?, CODE_VALIDATION = ?, LANGUE = ?, ETAT_OBJET = ?, NB_HITS = ?, DIFFUSION_PUBLIC_VISE = ?, DIFFUSION_MODE_RESTRICTION = ?, DIFFUSION_PUBLIC_VISE_RESTRICTION = ? where ID_LIEN = ?");
			// put parameters into statement
			stmt.setObject(1, getIdLien(), Types.BIGINT);
			stmt.setObject(2, getTitre(), Types.VARCHAR);
			stmt.setObject(3, getUrl(), Types.VARCHAR);
			stmt.setObject(4, getThematique(), Types.LONGVARCHAR);
			stmt.setObject(5, getType(), Types.LONGVARCHAR);
			stmt.setObject(6, getCategorie(), Types.VARCHAR);
			stmt.setObject(7, getResume(), Types.LONGVARCHAR);
			stmt.setObject(8, getDescription(), Types.LONGVARCHAR);
			stmt.setObject(9, getAuteurediteur(), Types.VARCHAR);
			stmt.setObject(10, getNomresponsable(), Types.VARCHAR);
			stmt.setObject(11, getEmailresponsable(), Types.VARCHAR);
			stmt.setObject(12, getCode(), Types.VARCHAR);
			stmt.setObject(13, getCodeRubrique(), Types.VARCHAR);
			stmt.setObject(14, getCodeRattachement(), Types.VARCHAR);
			stmt.setObject(15, getMetaKeywords(), Types.LONGVARCHAR);
			stmt.setObject(16, getMetaDescription(), Types.LONGVARCHAR);
			stmt.setObject(17, getTitreEncadre(), Types.VARCHAR);
			stmt.setObject(18, getContenuEncadre(), Types.LONGVARCHAR);
			stmt.setObject(19, getEncadreRecherche(), Types.VARCHAR);
			stmt.setObject(20, getEncadreRechercheBis(), Types.VARCHAR);
			stmt.setObject(21, getDateAlerte(), Types.DATE);
			stmt.setObject(22, getMessageAlerte(), Types.LONGVARCHAR);
			stmt.setObject(23, getDateCreation(), Types.TIMESTAMP);
			stmt.setObject(24, getDateProposition(), Types.TIMESTAMP);
			stmt.setObject(25, getDateValidation(), Types.TIMESTAMP);
			stmt.setObject(26, getDateModification(), Types.TIMESTAMP);
			stmt.setObject(27, getCodeRedacteur(), Types.VARCHAR);
			stmt.setObject(28, getCodeValidation(), Types.VARCHAR);
			stmt.setObject(29, getLangue(), Types.VARCHAR);
			stmt.setObject(30, getEtatObjet(), Types.VARCHAR);
			stmt.setObject(31, getNbHits(), Types.BIGINT);
			stmt.setObject(32, getDiffusionPublicVise(), Types.VARCHAR);
			stmt.setObject(33, getDiffusionModeRestriction(), Types.VARCHAR);
			stmt.setObject(34, getDiffusionPublicViseRestriction(), Types.VARCHAR);
			stmt.setObject(35, getIdLien(), Types.BIGINT);
			stmt.executeUpdate();
		} catch (final SQLException e) {
			throw new Exception("ERROR_IN_METHOD update()", e);
		} finally {
			if (stmt != null) {
				stmt.close();
			}
		}
	}
}
