/*
 * Decompiled with CFR 0.152.
 */
package com.kosmos.cms.module;

import com.jsbsoft.jtf.core.LangueUtil;
import com.jsbsoft.jtf.database.OMContext;
import com.kportal.tag.interpreteur.impl.AbstractInterpreteurTag;
import com.univ.objetspartages.om.Document;
import com.univ.objetspartages.om.EtatFiche;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.utils.ContexteUniv;
import com.univ.utils.ContexteUtil;
import com.univ.utils.UnivWebFmt;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterpreteurTagDocument
extends AbstractInterpreteurTag {
    private static final Logger LOG = LoggerFactory.getLogger(InterpreteurTagDocument.class);
    protected static String baliseInterneOuvrante = "[id-document]";
    protected static String baliseInterneFermante = "[/id-document]";

    public String interpreterTag(String texteAInterpreter, String baliseOuvrante, String baliseFermante) throws Exception {
        ContexteUniv ctx = ContexteUtil.getContexteUniv();
        String interpretationTag = "";
        if (ctx.getJspWriter() != null) {
            String contenuTag = StringUtils.substringBetween((String)texteAInterpreter, (String)baliseInterneOuvrante, (String)baliseInterneFermante);
            String contenuLien = StringUtils.defaultString((String)StringUtils.substringBetween((String)texteAInterpreter, (String)baliseInterneFermante, (String)"</a>"));
            contenuLien = StringUtils.substringAfter((String)contenuLien, (String)">");
            try {
                Document ficheDocument = InterpreteurTagDocument.getFicheDocument(contenuTag, ctx);
                if (ficheDocument.nextItem()) {
                    StringBuilder lienFichier = new StringBuilder();
                    String url = UnivWebFmt.determinerUrlFiche((ContexteUniv)ctx, (FicheUniv)ficheDocument);
                    lienFichier.append("<a href=\"").append(url).append("\">").append(contenuLien).append("</a>");
                    interpretationTag = lienFichier.toString();
                }
            }
            catch (Exception e) {
                LOG.error("impossible de r\u00e9cuperer le document li\u00e9 au tag " + texteAInterpreter, (Throwable)e);
            }
        }
        return interpretationTag;
    }

    private static Document getFicheDocument(String contenuTag, ContexteUniv ctx) throws Exception {
        String codeDocument = InterpreteurTagDocument.getCodeDocument(contenuTag);
        String langueDocument = InterpreteurTagDocument.getLangueDocument(contenuTag, ctx.getLocale());
        Document ficheDocument = new Document();
        ficheDocument.setCtx((OMContext)ctx);
        ficheDocument.selectCodeLangueEtat(codeDocument, langueDocument, EtatFiche.EN_LIGNE.getEtat());
        return ficheDocument;
    }

    private static String getCodeDocument(String contenuTag) {
        String codeDocument = StringUtils.substringAfter((String)contenuTag, (String)";");
        return StringUtils.substringBefore((String)codeDocument, (String)",LANGUE=");
    }

    private static String getLangueDocument(String contenuTag, Locale localeCourante) {
        String langue = StringUtils.substringAfter((String)contenuTag, (String)",LANGUE=");
        if (StringUtils.isBlank((CharSequence)langue)) {
            langue = Integer.toString(LangueUtil.getIndiceLocale((Locale)localeCourante));
        }
        return langue;
    }

    public String getReferenceTag(String texteAInterpreter, String baliseOuvrante, String baliseFermante) {
        return null;
    }
}

