/*
 * Decompiled with CFR 0.152.
 */
package com.univ.objetspartages.misc;

import com.jsbsoft.jtf.core.InfoBean;
import com.jsbsoft.jtf.core.LangueUtil;
import com.jsbsoft.jtf.database.OMContext;
import com.jsbsoft.jtf.exception.ErreurApplicative;
import com.kportal.cms.objetspartages.Objetpartage;
import com.univ.objetspartages.om.AbstractRechercheExterne;
import com.univ.objetspartages.om.Libelle;
import com.univ.objetspartages.om.ReferentielObjets;
import com.univ.objetspartages.om.Structure;
import com.univ.objetspartages.util.CritereRecherche;
import com.univ.objetspartages.util.CritereRechercheUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class RechercheDocument
extends AbstractRechercheExterne {
    public boolean preparerRECHERCHE(InfoBean infoBean, OMContext ctx) throws Exception {
        boolean rechercheEffectuee = false;
        String objet = StringUtils.defaultString((String)infoBean.getString("OBJET"), (String)"").toUpperCase();
        Locale locale = ctx.getLocale();
        if (objet.equals("DOCUMENT")) {
            infoBean.set("LISTE_TYPES_DOCUMENT", (Object)Libelle.getListe((String)"40", (Locale)locale));
            infoBean.set("LISTE_STRUCTURES", (Object)Structure.getListeStructuresPremierNiveau((String)String.valueOf(LangueUtil.getIndiceLocale((Locale)locale)), (boolean)true));
            infoBean.set("LISTE_THEMATIQUES", (Object)Libelle.getListe((String)"04", (Locale)locale));
            rechercheEffectuee = true;
        }
        return rechercheEffectuee;
    }

    public boolean traiterRECHERCHE(InfoBean infoBean, OMContext ctx) throws Exception {
        boolean rechercheEffectuee = false;
        String objet = infoBean.getString("OBJET").toUpperCase();
        if (objet.equals("DOCUMENT")) {
            ArrayList<CritereRecherche> criteres = new ArrayList<CritereRecherche>();
            criteres.add(new CritereRecherche("OBJET", objet, ""));
            Objetpartage module = ReferentielObjets.getObjetByNom((String)objet);
            CollectionUtils.addIgnoreNull(criteres, (Object)CritereRechercheUtil.getCritereTexteNonVideFormater((InfoBean)infoBean, (String)"TITRE"));
            CollectionUtils.addIgnoreNull(criteres, (Object)CritereRechercheUtil.getCritereDate((InfoBean)infoBean, (String)"DATE_DEBUT"));
            CollectionUtils.addIgnoreNull(criteres, (Object)CritereRechercheUtil.getCritereDate((InfoBean)infoBean, (String)"DATE_FIN"));
            CollectionUtils.addIgnoreNull(criteres, (Object)CritereRechercheUtil.getCritereTexteNonVideFormater((InfoBean)infoBean, (String)"AUTEUR"));
            CollectionUtils.addIgnoreNull(criteres, (Object)CritereRechercheUtil.getCritereChaineAvecLibelle((InfoBean)infoBean, (String)"TYPE_DOCUMENT", (String)"40"));
            CollectionUtils.addIgnoreNull(criteres, (Object)CritereRechercheUtil.getCritereThematique((InfoBean)infoBean));
            if ("0".equals(module.getProperty("fiche.DOCUMENT.recherche_vide")) && criteres.size() <= 1) {
                throw new ErreurApplicative(module.getMessage(ctx.getLocale(), "ST_RECHERCHE_SAISIR_UN_CRITERE"));
            }
            rechercheEffectuee = true;
            criteres.addAll(this.getCritereDefaut(infoBean));
            infoBean.set("CRITERE_REQUETE", criteres);
            this.gestionAncienFront(infoBean, criteres);
        }
        return rechercheEffectuee;
    }

    public List<String> getCriteresRequete(String objet, boolean listeIncluse) {
        ArrayList<String> criteres = new ArrayList<String>();
        if (objet.equals("DOCUMENT")) {
            criteres.add("TYPE_DOCUMENT");
            criteres.add("THEMATIQUE");
            criteres.add("DATE_DEBUT");
            criteres.add("DATE_FIN");
            if (listeIncluse) {
                criteres.add("SELECTION");
                criteres.add("NB_DAYS");
                criteres.add("TRI_DATE");
            }
        }
        return criteres;
    }
}

