/*
 * Decompiled with CFR 0.152.
 */
package com.univ.objetspartages.om;

import com.jsbsoft.jtf.core.Formateur;
import com.jsbsoft.jtf.core.LangueUtil;
import com.jsbsoft.jtf.database.OMContext;
import com.kportal.cms.objetspartages.annotation.FicheAnnotation;
import com.kportal.cms.objetspartages.om.ContentRedirect;
import com.kportal.core.config.PropertyHelper;
import com.univ.objetspartages.om.DiffusionSelective;
import com.univ.objetspartages.om.EtatFiche;
import com.univ.objetspartages.om.FicheExportableXML;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.InfosRubriques;
import com.univ.objetspartages.om.InfosStructure;
import com.univ.objetspartages.om.Libelle;
import com.univ.objetspartages.om.Metatag;
import com.univ.objetspartages.om.Ressource;
import com.univ.objetspartages.om.Rubrique;
import com.univ.objetspartages.om.Structure;
import com.univ.objetspartages.sgbd.DocumentDB;
import com.univ.utils.Chaine;
import com.univ.utils.ContexteUniv;
import com.univ.utils.DateUtil;
import com.univ.utils.FicheUnivMgr;
import com.univ.utils.RequeteUtil;
import com.univ.utils.URLResolver;
import com.univ.utils.UnivWebFmt;
import com.univ.utils.sql.RequeteSQL;
import com.univ.utils.sql.clause.ClauseLimit;
import com.univ.utils.sql.clause.ClauseOrderBy;
import com.univ.utils.sql.clause.ClauseWhere;
import com.univ.utils.sql.criterespecifique.ConditionHelper;
import com.univ.utils.sql.criterespecifique.LimitHelper;
import com.univ.utils.sql.criterespecifique.OrderByHelper;
import com.univ.utils.sql.criterespecifique.RequeteSQLHelper;
import com.univ.utils.sql.operande.TypeOperande;
import com.univ.xml.NodeUtil;
import java.sql.Date;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@FicheAnnotation
public class Document
extends DocumentDB
implements FicheUniv,
DiffusionSelective,
FicheExportableXML,
ContentRedirect {
    private static final long serialVersionUID = -427556824853088356L;
    private String urlRedirect;

    public static String getLibelleAffichable(OMContext ctx, String codes, String langue) throws Exception {
        String res = "";
        if (codes == null || codes.length() == 0) {
            return res;
        }
        Document document = new Document();
        document.init();
        document.setCtx(ctx);
        if (langue == null || langue.length() == 0) {
            langue = "0";
        }
        StringTokenizer st = new StringTokenizer(codes, ";");
        while (st.hasMoreTokens()) {
            String code = st.nextToken();
            int count = document.selectCodeLangueEtat(code, langue, "0003");
            if (count == 0) {
                count = document.selectCodeLangueEtat(code, langue, "");
            }
            if (count > 0) {
                if (res.length() > 1) {
                    res = res + ";";
                }
                if (!document.nextItem()) continue;
                res = res + document.getLibelleAffichable();
                continue;
            }
            res = res + "-";
        }
        return res;
    }

    public static Document getFicheDocument(OMContext ctx, String code, String langue) throws Exception {
        Document fiche = null;
        if (code != null && code.length() > 0) {
            if (langue == null || langue.length() == 0) {
                langue = "0";
            }
            fiche = new Document();
            fiche.init();
            fiche.setCtx(ctx);
            int count = fiche.selectCodeLangueEtat(code, langue, "0003");
            if (count == 0) {
                count = fiche.selectCodeLangueEtat(code, langue, "");
            }
            if (count == 0) {
                count = fiche.selectCodeLangueEtat(code, "", "0003");
            }
            if (count > 0) {
                fiche.nextItem();
            }
        }
        return fiche;
    }

    public void init() {
        FicheUnivMgr.init((FicheUniv)this);
        this.setIdDocument(new Long(0L));
        this.setCode("");
        this.setLangue("0");
        this.setTitre("");
        this.setSousTitre("");
        this.setResume("");
        this.setDateCreationDocument(new Date(System.currentTimeMillis()));
        this.setTypeDocument("");
        this.setSourceSupport("");
        this.setAuteurs("");
        this.setEditeur("");
        this.setDescription("");
        this.setReferencesIsdn("");
        this.setDateParutionDocument(new Date(0L));
        this.setDateDerniereMajDocument(new Date(0L));
        this.setProchaineMajPeriodicite("");
        this.setThematique("");
        this.setComplements("");
        this.setDateArchivageDocument(new Date(0L));
        this.setTheme("");
        this.setComiteSelection("");
    }

    public String getLibelleBackOffice() {
        return this.getLibelleAffichable() + " [" + Rubrique.getIntitule((String)this.getCodeRubrique()) + "]";
    }

    public String getLibelleAffichable() {
        return this.getTitre();
    }

    public Long getIdFiche() {
        return this.getIdDocument();
    }

    public void setIdFiche(Long idFiche) {
        this.setIdDocument(idFiche);
    }

    public List<Ressource> getListeFichiers() throws Exception {
        return Ressource.getListeFichier((FicheUniv)this);
    }

    public String getLibelleTypeDocument() {
        return Libelle.getLibelle((String)"40", (String)this.getTypeDocument(), (Locale)LangueUtil.getLocale((int)Integer.parseInt(this.getLangue())));
    }

    public String getLibelleThematique() {
        return Libelle.getLibelle((String)"04", (String)this.getThematique(), (Locale)LangueUtil.getLocale((int)Integer.parseInt(this.getLangue())));
    }

    public List<String> getListLibelleThematique() {
        return Libelle.getLibelleSousFormeDeListe((String)"04", (String)this.getThematique(), (Locale)LangueUtil.getLocale((int)Integer.parseInt(this.getLangue())));
    }

    public InfosRubriques getInfosRubrique() {
        return Rubrique.renvoyerItemRubrique((String)this.getCodeRubrique());
    }

    public InfosStructure getInfosStructure() throws Exception {
        return Structure.renvoyerItemStructure((String)this.getCodeRattachement(), (String)this.getLangue());
    }

    public Metatag getMeta() throws Exception {
        return FicheUnivMgr.lireMeta((FicheUniv)this);
    }

    public String getFormatedAuteurs() throws Exception {
        return UnivWebFmt.formaterEnHTML((ContexteUniv)((ContexteUniv)this.ctx), (String)this.getAuteurs());
    }

    public String getFormatedComplements() throws Exception {
        return UnivWebFmt.formaterEnHTML((ContexteUniv)((ContexteUniv)this.ctx), (String)this.getComplements());
    }

    public String getFormatedDescription() throws Exception {
        return UnivWebFmt.formaterEnHTML((ContexteUniv)((ContexteUniv)this.ctx), (String)this.getDescription());
    }

    public String getFullTextString() {
        String s = this.getSousTitre() + " " + this.getResume() + " " + this.getLibelleTypeDocument() + " " + this.getSourceSupport() + " " + this.getAuteurs() + " " + this.getEditeur() + " " + this.getDescription() + " " + this.getReferencesIsdn() + " " + this.getProchaineMajPeriodicite() + " " + StringUtils.replace((String)this.getLibelleThematique(), (String)";", (String)" ") + " " + this.getComplements();
        return s;
    }

    public void dupliquer(String nouvelleLangue) throws Exception {
        FicheUnivMgr.dupliquer((FicheUniv)this);
        this.setIdFiche(new Long(0L));
        this.setLangue(nouvelleLangue);
        this.add();
    }

    public int traiterRequete(String requete) throws Exception {
        String titre = RequeteUtil.renvoyerParametre((String)requete, (String)"TITRE");
        String auteur = RequeteUtil.renvoyerParametre((String)requete, (String)"AUTEUR");
        String typeDocument = RequeteUtil.renvoyerParametre((String)requete, (String)"TYPE_DOCUMENT");
        String thematique = RequeteUtil.renvoyerParametre((String)requete, (String)"THEMATIQUE");
        String codeRubrique = RequeteUtil.renvoyerParametre((String)requete, (String)"CODE_RUBRIQUE");
        String codeRattachement = RequeteUtil.renvoyerParametre((String)requete, (String)"CODE_RATTACHEMENT");
        String langue = RequeteUtil.renvoyerParametre((String)requete, (String)"LANGUE");
        String ids = RequeteUtil.renvoyerParametre((String)requete, (String)"IDS");
        String nbMax = RequeteUtil.renvoyerParametre((String)requete, (String)"NOMBRE");
        String period = RequeteUtil.renvoyerParametre((String)requete, (String)"SELECTION");
        String tri = RequeteUtil.renvoyerParametre((String)requete, (String)"TRI_DATE");
        String nbDays = RequeteUtil.renvoyerParametre((String)requete, (String)"NB_DAYS");
        String sDateDebut = RequeteUtil.renvoyerParametre((String)requete, (String)"DATE_DEBUT");
        String sDateFin = RequeteUtil.renvoyerParametre((String)requete, (String)"DATE_FIN");
        String code = RequeteUtil.renvoyerParametre((String)requete, (String)"CODE");
        String etatObjet = (String)StringUtils.defaultIfBlank((CharSequence)RequeteUtil.renvoyerParametre((String)requete, (String)"ETAT_OBJET"), (CharSequence)EtatFiche.EN_LIGNE.toString());
        String codeRedacteur = RequeteUtil.renvoyerParametre((String)requete, (String)"CODE_REDACTEUR");
        Date dateDebut = null;
        Date dateFin = null;
        String orderDate = "";
        String orderTri = "";
        if (period.length() > 0) {
            orderDate = "T1.DATE_CREATION_DOCUMENT";
            Date today = new Date(System.currentTimeMillis());
            if (period.endsWith("01")) {
                dateFin = today;
                orderTri = "DESC";
            } else if (period.endsWith("02")) {
                dateDebut = today;
                dateFin = today;
            } else if (period.endsWith("03")) {
                dateDebut = DateUtil.getFirstDayOfWeek((Date)today);
                dateFin = DateUtil.getLastDayOfWeek((Date)today);
            } else if (period.endsWith("04")) {
                dateDebut = DateUtil.getFirstDayOfMonth((Date)today);
                dateFin = DateUtil.getLastDayOfMonth((Date)today);
            } else if (period.endsWith("07")) {
                orderDate = "META.META_DATE_MISE_EN_LIGNE";
                orderTri = "DESC";
            }
        } else if (nbDays.length() > 0) {
            GregorianCalendar gCal = new GregorianCalendar();
            gCal.setTimeInMillis(System.currentTimeMillis());
            gCal.add(5, -Integer.parseInt(nbDays));
            dateDebut = new Date(gCal.getTimeInMillis());
            dateFin = new Date(System.currentTimeMillis());
            orderDate = "T1.DATE_CREATION_DOCUMENT";
        } else if (sDateDebut.length() > 0 || sDateFin.length() > 0) {
            dateDebut = DateUtil.parseDate((String)sDateDebut);
            dateFin = DateUtil.parseDate((String)sDateFin);
            orderDate = "T1.DATE_CREATION_DOCUMENT";
        }
        if ("DATE_DESC".equals(tri)) {
            orderTri = "DESC";
        }
        if ("DATE_ASC".equals(tri)) {
            orderTri = "ASC";
        }
        String order = "T1.TITRE";
        if (orderDate.length() > 0) {
            order = orderDate + " " + orderTri + ", " + order;
        }
        return this.select(code, titre, typeDocument, auteur, thematique, codeRattachement, codeRubrique, langue, codeRedacteur, etatObjet, dateDebut, dateFin, nbMax, order, ids);
    }

    public int selectCodeLangueEtat(String code, String langue, String etatObjet) throws Exception {
        RequeteSQL codeLangueEtatOrdreSurTitre = new RequeteSQL();
        ClauseWhere whereCodeLangueEtat = ConditionHelper.whereCodeLangueEtat((String)code, (String)langue, (String)etatObjet);
        ClauseOrderBy orderBy = new ClauseOrderBy();
        orderBy.orderBy("T1.TITRE", ClauseOrderBy.SensDeTri.ASC);
        codeLangueEtatOrdreSurTitre.where(whereCodeLangueEtat).orderBy(orderBy);
        return this.select(codeLangueEtatOrdreSurTitre.formaterRequete());
    }

    public int selectParCodeRubrique(String codeRubrique, String langue) throws Exception {
        RequeteSQL codeRubriqueLangueEnLigneOrdreTitre = new RequeteSQL();
        ClauseWhere whereCodeRubriqueLangueEtat = new ClauseWhere();
        if (StringUtils.isNotEmpty((CharSequence)codeRubrique)) {
            whereCodeRubriqueLangueEtat.setPremiereCondition(ConditionHelper.egalVarchar((String)"T1.CODE_RUBRIQUE", (String)codeRubrique));
        }
        if (StringUtils.isNotEmpty((CharSequence)langue)) {
            whereCodeRubriqueLangueEtat.and(ConditionHelper.egalVarchar((String)"T1.LANGUE", (String)langue));
        }
        whereCodeRubriqueLangueEtat.and(ConditionHelper.egalVarchar((String)"T1.ETAT_OBJET", (String)"0003"));
        ClauseOrderBy orderBy = new ClauseOrderBy();
        orderBy.orderBy("T1.TITRE", ClauseOrderBy.SensDeTri.ASC);
        codeRubriqueLangueEnLigneOrdreTitre.where(whereCodeRubriqueLangueEtat).orderBy(orderBy);
        return this.select(codeRubriqueLangueEnLigneOrdreTitre.formaterRequete());
    }

    public String getReferences() {
        return FicheUnivMgr.getReferenceParTexte((String)this.getSourceSupport()) + FicheUnivMgr.getReferenceParTexte((String)this.getAuteurs()) + FicheUnivMgr.getReferenceParTexte((String)this.getEditeur()) + FicheUnivMgr.getReferenceParTexte((String)this.getDescription()) + FicheUnivMgr.getReferenceParTexte((String)this.getEditeur()) + FicheUnivMgr.getReferenceParTexte((String)this.getReferencesIsdn()) + FicheUnivMgr.getReferenceParJointure((String)"structure", (String)this.getCodeRattachement()) + FicheUnivMgr.getReferenceParTexte((String)this.getComplements());
    }

    public int select(String code, String titre, String typeDocument, String auteurs, String thematique, String codeRattachement, String codeRubrique, String langue, String codeRedacteur, String etatObjet, Date dtstart, Date dtend, String nbMax, String order, String ids) throws Exception {
        RequeteSQL requeteSelect = new RequeteSQL();
        ClauseWhere where = new ClauseWhere();
        if (StringUtils.isNotEmpty((CharSequence)titre)) {
            where.setPremiereCondition(ConditionHelper.rechercheMots((String)"TITRE", (String)titre));
        }
        if (StringUtils.isNotEmpty((CharSequence)auteurs)) {
            where.and(ConditionHelper.rechercheMots((String)"AUTEURS", (String)auteurs));
        }
        if (StringUtils.isNotEmpty((CharSequence)typeDocument) && !"0000".equals(typeDocument)) {
            where.and(ConditionHelper.egalVarchar((String)"T1.TYPE_DOCUMENT", (String)typeDocument));
        }
        if (StringUtils.isNotEmpty((CharSequence)thematique) && !"0000".equals(thematique)) {
            where.and(ConditionHelper.likePourValeursMultiple((String)"THEMATIQUE", (String)thematique));
        }
        if (dtstart != null && Formateur.estSaisie((Date)dtstart)) {
            where.and(ConditionHelper.critereDateDebut((String)"DATE_CREATION_DOCUMENT", (Date)dtstart));
        }
        if (dtend != null && Formateur.estSaisie((Date)dtend)) {
            where.and(ConditionHelper.lessEquals((String)"DATE_CREATION_DOCUMENT", (Object)dtend, (TypeOperande)TypeOperande.DATE));
        }
        if (StringUtils.isNotEmpty((CharSequence)ids) && !"0000".equals(ids)) {
            where.and(ConditionHelper.in((String)"ID_DOCUMENT", (Collection)Chaine.getVecteurPointsVirgules((String)ids)));
        }
        if (StringUtils.isNotEmpty((CharSequence)codeRattachement)) {
            where.and(ConditionHelper.getConditionStructure((String)"CODE_RATTACHEMENT", (String)codeRattachement));
        }
        if (StringUtils.isNotEmpty((CharSequence)langue) && !"0000".equals(langue)) {
            where.and(ConditionHelper.egalVarchar((String)"T1.LANGUE", (String)langue));
        }
        if (StringUtils.isNotEmpty((CharSequence)etatObjet) && !"0000".equals(etatObjet)) {
            where.and(ConditionHelper.egalVarchar((String)"T1.ETAT_OBJET", (String)etatObjet));
        }
        if (StringUtils.isNotEmpty((CharSequence)codeRedacteur)) {
            where.and(ConditionHelper.egalVarchar((String)"CODE_REDACTEUR", (String)codeRedacteur));
        }
        if (StringUtils.isNotEmpty((CharSequence)code)) {
            where.and(ConditionHelper.egalVarchar((String)"T1.CODE", (String)code));
        }
        requeteSelect = RequeteSQLHelper.getRequeteGenerique((ClauseWhere)where, (OMContext)this.ctx, (FicheUniv)this, (String)codeRubrique);
        ClauseOrderBy orderBy = new ClauseOrderBy();
        if (StringUtils.isNotEmpty((CharSequence)order)) {
            orderBy = OrderByHelper.reconstruireClauseOrderBy((String)order);
        } else {
            orderBy.orderBy("T1.TITRE", ClauseOrderBy.SensDeTri.ASC);
        }
        requeteSelect.orderBy(orderBy);
        ClauseLimit limite = LimitHelper.ajouterCriteresLimitesEtOptimisation((OMContext)this.ctx, (String)nbMax);
        requeteSelect.limit(limite);
        return this.select(requeteSelect.formaterRequete());
    }

    public Node exportNodeFiche(Node liste, String formatExport) throws Exception {
        org.w3c.dom.Document document = liste.getOwnerDocument();
        Element fiche = document.createElement("DOCUMENT");
        NodeUtil.addNode((Node)fiche, (String)"CODE", (String)this.getCode());
        NodeUtil.addNode((Node)fiche, (String)"LANGUE", (String)this.getLangue());
        NodeUtil.addNode((Node)fiche, (String)"LIBELLE", (String)this.getLibelleAffichable());
        NodeUtil.addNode((Node)fiche, (String)"TITRE", (String)this.getTitre());
        NodeUtil.addNode((Node)fiche, (String)"AUTEURS", (String)this.getAuteurs());
        NodeUtil.addNode((Node)fiche, (String)"RATTACHEMENT", (String)Structure.getLibelleRattachement((OMContext)this.ctx, (String)this.getCodeRattachement(), (String)this.getLangue(), (boolean)true));
        NodeUtil.addNode((Node)fiche, (String)"CODE_RUBRIQUE", (String)this.getCodeRubrique());
        NodeUtil.addNode((Node)fiche, (String)"RUBRIQUE", (String)Rubrique.renvoyerItemRubrique((String)this.getCodeRubrique()).getIntitule());
        NodeUtil.addNode((Node)fiche, (String)"COMPLEMENTS", (String)this.getComplements());
        NodeUtil.addNode((Node)fiche, (String)"DATE_CREATION_DOCUMENT", (String)Formateur.formaterDate((Object)this.getDateCreationDocument(), (String)""));
        NodeUtil.addNode((Node)fiche, (String)"DATE_DERNIERE_MAJ_DOCUMENT", (String)Formateur.formaterDate((Object)this.getDateDerniereMajDocument(), (String)""));
        NodeUtil.addNode((Node)fiche, (String)"DESCRIPTION", (String)this.getDescription());
        NodeUtil.addNode((Node)fiche, (String)"EDITEUR", (String)this.getEditeur());
        NodeUtil.addNode((Node)fiche, (String)"PROCHAINE_MAJ_PERIODICITE", (String)this.getProchaineMajPeriodicite());
        NodeUtil.addNode((Node)fiche, (String)"REFERENCES_ISDN", (String)this.getReferencesIsdn());
        NodeUtil.addNode((Node)fiche, (String)"RESUME", (String)this.getResume());
        NodeUtil.addNode((Node)fiche, (String)"SOURCE_SUPPORT", (String)this.getSourceSupport());
        NodeUtil.addNode((Node)fiche, (String)"SOUS_TITRE", (String)this.getSousTitre());
        NodeUtil.addNode((Node)fiche, (String)"THEMATIQUE", (String)this.getThematique());
        NodeUtil.addNode((Node)fiche, (String)"TYPE_DOCUMENT", (String)Libelle.getLibelle((String)"40", (String)this.getTypeDocument(), (Locale)this.ctx.getLocale()));
        return fiche;
    }

    public String getUrlRedirect() {
        if (this.urlRedirect == null) {
            this.urlRedirect = "";
            try {
                List<Ressource> fichiersJoint;
                Metatag meta = FicheUnivMgr.lireMeta((FicheUniv)this);
                if ("1".equals(meta.getMetaDocumentFichiergw()) && (fichiersJoint = this.getListeFichiers()).size() == 1) {
                    this.urlRedirect = URLResolver.getAbsoluteUrl((String)fichiersJoint.get(0).getUrl(), (OMContext)this.ctx);
                    String typeDisposition = (String)StringUtils.defaultIfEmpty((CharSequence)PropertyHelper.getCoreProperty((String)"telechargement.disposition"), (CharSequence)"attachment");
                    if (typeDisposition.equalsIgnoreCase("attachment")) {
                        this.urlRedirect = this.urlRedirect + (this.urlRedirect.indexOf("?") != -1 ? "&" : "?") + "INLINE=FALSE";
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.urlRedirect;
    }
}

