/**
 * Copyright (C) 2015 Kosmos contact@kosmos.fr
 *
 * Projet: ged
 * Version: 1.02.04
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kosmos.cms.module;

import java.util.Locale;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.jsbsoft.jtf.core.LangueUtil;
import com.kportal.tag.interpreteur.impl.AbstractInterpreteurTag;
import com.univ.objetspartages.om.Document;
import com.univ.objetspartages.om.EtatFiche;
import com.univ.utils.ContexteUniv;
import com.univ.utils.ContexteUtil;
import com.univ.utils.UnivWebFmt;

public class InterpreteurTagDocument extends AbstractInterpreteurTag {

	private static final Logger LOG = LoggerFactory.getLogger(InterpreteurTagDocument.class);

	protected static String baliseInterneOuvrante = "[id-document]";

	protected static String baliseInterneFermante = "[/id-document]";

	@Override
	public String interpreterTag(final String texteAInterpreter, final String baliseOuvrante, final String baliseFermante) throws Exception {
		final ContexteUniv ctx = ContexteUtil.getContexteUniv();
		String interpretationTag = StringUtils.EMPTY;
		// test que le tag est genere pour une jsp en front
		if (ctx.getJspWriter() != null) {
			final String contenuTag = StringUtils.substringBetween(texteAInterpreter, baliseInterneOuvrante, baliseInterneFermante);
			String contenuLien = StringUtils.defaultString(StringUtils.substringBetween(texteAInterpreter, baliseInterneFermante, "</a>"));
			contenuLien = StringUtils.substringAfter(contenuLien, ">");
			try {
				final Document ficheDocument = getFicheDocument(contenuTag, ctx);
				if (ficheDocument.nextItem()) {
					StringBuilder lienFichier = new StringBuilder();
					String url = UnivWebFmt.determinerUrlFiche(ctx, ficheDocument);
					lienFichier.append("<a href=\"").append(url).append("\">").append(contenuLien).append("</a>");
					interpretationTag = lienFichier.toString();
				}
			} catch (final Exception e) {
				LOG.error("impossible de récuperer le document lié au tag " + texteAInterpreter, e);
			}
		}
		return interpretationTag;
	}

	private static Document getFicheDocument(final String contenuTag, final ContexteUniv ctx) throws Exception {
		final String codeDocument = getCodeDocument(contenuTag);
		final String langueDocument = getLangueDocument(contenuTag, ctx.getLocale());
		final Document ficheDocument = new Document();
		ficheDocument.setCtx(ctx);
		ficheDocument.selectCodeLangueEtat(codeDocument, langueDocument, EtatFiche.EN_LIGNE.getEtat());
		return ficheDocument;
	}

	private static String getCodeDocument(final String contenuTag) {
		final String codeDocument = StringUtils.substringAfter(contenuTag, ";");
		return StringUtils.substringBefore(codeDocument, ",LANGUE=");
	}

	private static String getLangueDocument(final String contenuTag, final Locale localeCourante) {
		String langue = StringUtils.substringAfter(contenuTag, ",LANGUE=");
		if (StringUtils.isBlank(langue)) {
			langue = Integer.toString(LangueUtil.getIndiceLocale(localeCourante));
		}
		return langue;
	}

	@Override
	public String getReferenceTag(final String texteAInterpreter, final String baliseOuvrante, final String baliseFermante) {
		return null;
	}
}
