/**
 * Copyright (C) 2015 Kosmos contact@kosmos.fr
 *
 * Projet: ged
 * Version: 1.02.04
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.objetspartages.bean;

import java.io.Serializable;
import java.sql.Date;

import com.kportal.cms.objetspartages.annotation.GetterAnnotation;
import com.kportal.cms.objetspartages.annotation.SetterAnnotation;

// TODO: Auto-generated Javadoc
/**
 * Classe d'acces aux donnees pour document.
 */
public class DocumentBean implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = -6027626543832306544L;

	/** The id document. */
	protected Long idDocument = null;

	/** The titre. */
	protected String titre = null;

	/** The sous titre. */
	protected String sousTitre = null;

	/** The resume. */
	protected String resume = null;

	/** The date creation document. */
	protected Date dateCreationDocument = null;

	/** The type document. */
	protected String typeDocument = null;

	/** The source support. */
	protected String sourceSupport = null;

	/** The auteurs. */
	protected String auteurs = null;

	/** The editeur. */
	protected String editeur = null;

	/** The description. */
	protected String description = null;

	/** The references isdn. */
	protected String referencesIsdn = null;

	/** The date parution document. */
	protected Date dateParutionDocument = null;

	/** The date derniere maj document. */
	protected Date dateDerniereMajDocument = null;

	/** The date archivage document. */
	protected Date dateArchivageDocument = null;

	/** The prochaine maj periodicite. */
	protected String prochaineMajPeriodicite = null;

	/** The theme. */
	protected String theme = null;

	/** The thematique. */
	protected String thematique = null;

	/** The comite selection. */
	protected String comiteSelection = null;

	/** The complements. */
	protected String complements = null;

	/** The code. */
	protected String code = null;

	/** The code rubrique. */
	protected String codeRubrique = null;

	/** The code rattachement. */
	protected String codeRattachement = null;

	/** The meta keywords. */
	protected String metaKeywords = null;

	/** The meta description. */
	protected String metaDescription = null;

	/** The titre encadre. */
	protected String titreEncadre = null;

	/** The contenu encadre. */
	protected String contenuEncadre = null;

	/** The encadre recherche. */
	protected String encadreRecherche = null;

	/** The encadre recherche bis. */
	protected String encadreRechercheBis = null;

	/** The date alerte. */
	protected Date dateAlerte = null;

	/** The message alerte. */
	protected String messageAlerte = null;

	/** The date creation. */
	protected Date dateCreation = null;

	/** The date proposition. */
	protected Date dateProposition = null;

	/** The date validation. */
	protected Date dateValidation = null;

	/** The date modification. */
	protected Date dateModification = null;

	/** The code redacteur. */
	protected String codeRedacteur = null;

	/** The code validation. */
	protected String codeValidation = null;

	/** The langue. */
	protected String langue = null;

	/** The etat objet. */
	protected String etatObjet = null;

	/** The nb hits. */
	protected Long nbHits = null;

	/** The diffusion public vise. */
	protected String diffusionPublicVise = null;

	/** The diffusion mode restriction. */
	protected String diffusionModeRestriction = null;

	/** The diffusion public vise restriction. */
	protected String diffusionPublicViseRestriction = null;

	/**
	 * Inits the.
	 * 
	 * @param bean
	 *            the bean
	 */
	public void init(DocumentBean bean) {
		this.idDocument = bean.idDocument;
		this.titre = bean.titre;
		this.sousTitre = bean.sousTitre;
		this.resume = bean.resume;
		this.dateCreationDocument = bean.dateCreationDocument;
		this.typeDocument = bean.typeDocument;
		this.sourceSupport = bean.sourceSupport;
		this.auteurs = bean.auteurs;
		this.editeur = bean.editeur;
		this.description = bean.description;
		this.referencesIsdn = bean.referencesIsdn;
		this.dateParutionDocument = bean.dateParutionDocument;
		this.dateDerniereMajDocument = bean.dateDerniereMajDocument;
		this.dateArchivageDocument = bean.dateArchivageDocument;
		this.prochaineMajPeriodicite = bean.prochaineMajPeriodicite;
		this.theme = bean.theme;
		this.thematique = bean.thematique;
		this.comiteSelection = bean.comiteSelection;
		this.complements = bean.complements;
		this.code = bean.code;
		this.codeRubrique = bean.codeRubrique;
		this.codeRattachement = bean.codeRattachement;
		this.metaKeywords = bean.metaKeywords;
		this.metaDescription = bean.metaDescription;
		this.titreEncadre = bean.titreEncadre;
		this.contenuEncadre = bean.contenuEncadre;
		this.encadreRecherche = bean.encadreRecherche;
		this.encadreRechercheBis = bean.encadreRechercheBis;
		this.dateAlerte = bean.dateAlerte;
		this.messageAlerte = bean.messageAlerte;
		this.dateCreation = bean.dateCreation;
		this.dateProposition = bean.dateProposition;
		this.dateValidation = bean.dateValidation;
		this.dateModification = bean.dateModification;
		this.codeRedacteur = bean.codeRedacteur;
		this.codeValidation = bean.codeValidation;
		this.langue = bean.langue;
		this.etatObjet = bean.etatObjet;
		this.nbHits = bean.nbHits;
		this.diffusionPublicVise = bean.diffusionPublicVise;
		this.diffusionModeRestriction = bean.diffusionModeRestriction;
		this.diffusionPublicViseRestriction = bean.diffusionPublicViseRestriction;
	}

	/**
	 * Instantiates a new document bean.
	 */
	public DocumentBean() {
		super();
		// TODO Auto-generated constructor stub
	}

	/**
	 * Gets the auteurs.
	 * 
	 * @return the auteurs
	 */
	@GetterAnnotation(isToolbox = true)
	public String getAuteurs() {
		return auteurs;
	}

	/**
	 * Sets the auteurs.
	 * 
	 * @param auteurs
	 *            the auteurs to set
	 */
	@SetterAnnotation(isToolbox = true)
	public void setAuteurs(String auteurs) {
		this.auteurs = auteurs;
	}

	/**
	 * Gets the code.
	 * 
	 * @return the code
	 */
	public String getCode() {
		return code;
	}

	/**
	 * Sets the code.
	 * 
	 * @param code
	 *            the code to set
	 */
	public void setCode(String code) {
		this.code = code;
	}

	/**
	 * Gets the code rattachement.
	 * 
	 * @return the codeRattachement
	 */
	public String getCodeRattachement() {
		return codeRattachement;
	}

	/**
	 * Sets the code rattachement.
	 * 
	 * @param codeRattachement
	 *            the codeRattachement to set
	 */
	public void setCodeRattachement(String codeRattachement) {
		this.codeRattachement = codeRattachement;
	}

	/**
	 * Gets the code redacteur.
	 * 
	 * @return the codeRedacteur
	 */
	public String getCodeRedacteur() {
		return codeRedacteur;
	}

	/**
	 * Sets the code redacteur.
	 * 
	 * @param codeRedacteur
	 *            the codeRedacteur to set
	 */
	public void setCodeRedacteur(String codeRedacteur) {
		this.codeRedacteur = codeRedacteur;
	}

	/**
	 * Gets the code rubrique.
	 * 
	 * @return the codeRubrique
	 */
	public String getCodeRubrique() {
		return codeRubrique;
	}

	/**
	 * Sets the code rubrique.
	 * 
	 * @param codeRubrique
	 *            the codeRubrique to set
	 */
	public void setCodeRubrique(String codeRubrique) {
		this.codeRubrique = codeRubrique;
	}

	/**
	 * Gets the code validation.
	 * 
	 * @return the codeValidation
	 */
	public String getCodeValidation() {
		return codeValidation;
	}

	/**
	 * Sets the code validation.
	 * 
	 * @param codeValidation
	 *            the codeValidation to set
	 */
	public void setCodeValidation(String codeValidation) {
		this.codeValidation = codeValidation;
	}

	/**
	 * Gets the comite selection.
	 * 
	 * @return the comiteSelection
	 */
	public String getComiteSelection() {
		return comiteSelection;
	}

	/**
	 * Sets the comite selection.
	 * 
	 * @param comiteSelection
	 *            the comiteSelection to set
	 */
	public void setComiteSelection(String comiteSelection) {
		this.comiteSelection = comiteSelection;
	}

	/**
	 * Gets the complements.
	 * 
	 * @return the complements
	 */
	@GetterAnnotation(isToolbox = true)
	public String getComplements() {
		return complements;
	}

	/**
	 * Sets the complements.
	 * 
	 * @param complements
	 *            the complements to set
	 */
	@SetterAnnotation(isToolbox = true)
	public void setComplements(String complements) {
		this.complements = complements;
	}

	/**
	 * Gets the contenu encadre.
	 * 
	 * @return the contenuEncadre
	 */
	@GetterAnnotation(isToolbox = true)
	public String getContenuEncadre() {
		return contenuEncadre;
	}

	/**
	 * Sets the contenu encadre.
	 * 
	 * @param contenuEncadre
	 *            the contenuEncadre to set
	 */
	@SetterAnnotation(isToolbox = true)
	public void setContenuEncadre(String contenuEncadre) {
		this.contenuEncadre = contenuEncadre;
	}

	/**
	 * Gets the date alerte.
	 * 
	 * @return the dateAlerte
	 */
	public Date getDateAlerte() {
		return dateAlerte;
	}

	/**
	 * Sets the date alerte.
	 * 
	 * @param dateAlerte
	 *            the dateAlerte to set
	 */
	public void setDateAlerte(Date dateAlerte) {
		this.dateAlerte = dateAlerte;
	}

	/**
	 * Gets the date archivage document.
	 * 
	 * @return the dateArchivageDocument
	 */
	public Date getDateArchivageDocument() {
		return dateArchivageDocument;
	}

	/**
	 * Sets the date archivage document.
	 * 
	 * @param dateArchivageDocument
	 *            the dateArchivageDocument to set
	 */
	public void setDateArchivageDocument(Date dateArchivageDocument) {
		this.dateArchivageDocument = dateArchivageDocument;
	}

	/**
	 * Gets the date creation.
	 * 
	 * @return the dateCreation
	 */
	public Date getDateCreation() {
		return dateCreation;
	}

	/**
	 * Sets the date creation.
	 * 
	 * @param dateCreation
	 *            the dateCreation to set
	 */
	public void setDateCreation(Date dateCreation) {
		this.dateCreation = dateCreation;
	}

	/**
	 * Gets the date creation document.
	 * 
	 * @return the dateCreationDocument
	 */
	public Date getDateCreationDocument() {
		return dateCreationDocument;
	}

	/**
	 * Sets the date creation document.
	 * 
	 * @param dateCreationDocument
	 *            the dateCreationDocument to set
	 */
	public void setDateCreationDocument(Date dateCreationDocument) {
		this.dateCreationDocument = dateCreationDocument;
	}

	/**
	 * Gets the date derniere maj document.
	 * 
	 * @return the dateDerniereMajDocument
	 */
	public Date getDateDerniereMajDocument() {
		return dateDerniereMajDocument;
	}

	/**
	 * Sets the date derniere maj document.
	 * 
	 * @param dateDerniereMajDocument
	 *            the dateDerniereMajDocument to set
	 */
	public void setDateDerniereMajDocument(Date dateDerniereMajDocument) {
		this.dateDerniereMajDocument = dateDerniereMajDocument;
	}

	/**
	 * Gets the date modification.
	 * 
	 * @return the dateModification
	 */
	public Date getDateModification() {
		return dateModification;
	}

	/**
	 * Sets the date modification.
	 * 
	 * @param dateModification
	 *            the dateModification to set
	 */
	public void setDateModification(Date dateModification) {
		this.dateModification = dateModification;
	}

	/**
	 * Gets the date parution document.
	 * 
	 * @return the dateParutionDocument
	 */
	public Date getDateParutionDocument() {
		return dateParutionDocument;
	}

	/**
	 * Sets the date parution document.
	 * 
	 * @param dateParutionDocument
	 *            the dateParutionDocument to set
	 */
	public void setDateParutionDocument(Date dateParutionDocument) {
		this.dateParutionDocument = dateParutionDocument;
	}

	/**
	 * Gets the date proposition.
	 * 
	 * @return the dateProposition
	 */
	public Date getDateProposition() {
		return dateProposition;
	}

	/**
	 * Sets the date proposition.
	 * 
	 * @param dateProposition
	 *            the dateProposition to set
	 */
	public void setDateProposition(Date dateProposition) {
		this.dateProposition = dateProposition;
	}

	/**
	 * Gets the date validation.
	 * 
	 * @return the dateValidation
	 */
	public Date getDateValidation() {
		return dateValidation;
	}

	/**
	 * Sets the date validation.
	 * 
	 * @param dateValidation
	 *            the dateValidation to set
	 */
	public void setDateValidation(Date dateValidation) {
		this.dateValidation = dateValidation;
	}

	/**
	 * Gets the description.
	 * 
	 * @return the description
	 */
	@GetterAnnotation(isToolbox = true)
	public String getDescription() {
		return description;
	}

	/**
	 * Sets the description.
	 * 
	 * @param description
	 *            the description to set
	 */
	@SetterAnnotation(isToolbox = true)
	public void setDescription(String description) {
		this.description = description;
	}

	/**
	 * Gets the diffusion mode restriction.
	 * 
	 * @return the diffusionModeRestriction
	 */
	public String getDiffusionModeRestriction() {
		return diffusionModeRestriction;
	}

	/**
	 * Sets the diffusion mode restriction.
	 * 
	 * @param diffusionModeRestriction
	 *            the diffusionModeRestriction to set
	 */
	public void setDiffusionModeRestriction(String diffusionModeRestriction) {
		this.diffusionModeRestriction = diffusionModeRestriction;
	}

	/**
	 * Gets the diffusion public vise.
	 * 
	 * @return the diffusionPublicVise
	 */
	public String getDiffusionPublicVise() {
		return diffusionPublicVise;
	}

	/**
	 * Sets the diffusion public vise.
	 * 
	 * @param diffusionPublicVise
	 *            the diffusionPublicVise to set
	 */
	public void setDiffusionPublicVise(String diffusionPublicVise) {
		this.diffusionPublicVise = diffusionPublicVise;
	}

	/**
	 * Gets the diffusion public vise restriction.
	 * 
	 * @return the diffusionPublicViseRestriction
	 */
	public String getDiffusionPublicViseRestriction() {
		return diffusionPublicViseRestriction;
	}

	/**
	 * Sets the diffusion public vise restriction.
	 * 
	 * @param diffusionPublicViseRestriction
	 *            the diffusionPublicViseRestriction to set
	 */
	public void setDiffusionPublicViseRestriction(String diffusionPublicViseRestriction) {
		this.diffusionPublicViseRestriction = diffusionPublicViseRestriction;
	}

	/**
	 * Gets the editeur.
	 * 
	 * @return the editeur
	 */
	public String getEditeur() {
		return editeur;
	}

	/**
	 * Sets the editeur.
	 * 
	 * @param editeur
	 *            the editeur to set
	 */
	public void setEditeur(String editeur) {
		this.editeur = editeur;
	}

	/**
	 * Gets the encadre recherche.
	 * 
	 * @return the encadreRecherche
	 */
	public String getEncadreRecherche() {
		return encadreRecherche;
	}

	/**
	 * Sets the encadre recherche.
	 * 
	 * @param encadreRecherche
	 *            the encadreRecherche to set
	 */
	public void setEncadreRecherche(String encadreRecherche) {
		this.encadreRecherche = encadreRecherche;
	}

	/**
	 * Gets the encadre recherche bis.
	 * 
	 * @return the encadreRechercheBis
	 */
	public String getEncadreRechercheBis() {
		return encadreRechercheBis;
	}

	/**
	 * Sets the encadre recherche bis.
	 * 
	 * @param encadreRechercheBis
	 *            the encadreRechercheBis to set
	 */
	public void setEncadreRechercheBis(String encadreRechercheBis) {
		this.encadreRechercheBis = encadreRechercheBis;
	}

	/**
	 * Gets the etat objet.
	 * 
	 * @return the etatObjet
	 */
	public String getEtatObjet() {
		return etatObjet;
	}

	/**
	 * Sets the etat objet.
	 * 
	 * @param etatObjet
	 *            the etatObjet to set
	 */
	public void setEtatObjet(String etatObjet) {
		this.etatObjet = etatObjet;
	}

	/**
	 * Gets the id document.
	 * 
	 * @return the idDocument
	 */
	public Long getIdDocument() {
		return idDocument;
	}

	/**
	 * Sets the id document.
	 * 
	 * @param idDocument
	 *            the idDocument to set
	 */
	public void setIdDocument(Long idDocument) {
		this.idDocument = idDocument;
	}

	/**
	 * Gets the langue.
	 * 
	 * @return the langue
	 */
	public String getLangue() {
		return langue;
	}

	/**
	 * Sets the langue.
	 * 
	 * @param langue
	 *            the langue to set
	 */
	public void setLangue(String langue) {
		this.langue = langue;
	}

	/**
	 * Gets the message alerte.
	 * 
	 * @return the messageAlerte
	 */
	public String getMessageAlerte() {
		return messageAlerte;
	}

	/**
	 * Sets the message alerte.
	 * 
	 * @param messageAlerte
	 *            the messageAlerte to set
	 */
	public void setMessageAlerte(String messageAlerte) {
		this.messageAlerte = messageAlerte;
	}

	/**
	 * Gets the meta description.
	 * 
	 * @return the metaDescription
	 */
	public String getMetaDescription() {
		return metaDescription;
	}

	/**
	 * Sets the meta description.
	 * 
	 * @param metaDescription
	 *            the metaDescription to set
	 */
	public void setMetaDescription(String metaDescription) {
		this.metaDescription = metaDescription;
	}

	/**
	 * Gets the meta keywords.
	 * 
	 * @return the metaKeywords
	 */
	public String getMetaKeywords() {
		return metaKeywords;
	}

	/**
	 * Sets the meta keywords.
	 * 
	 * @param metaKeywords
	 *            the metaKeywords to set
	 */
	public void setMetaKeywords(String metaKeywords) {
		this.metaKeywords = metaKeywords;
	}

	/**
	 * Gets the nb hits.
	 * 
	 * @return the nbHits
	 */
	public Long getNbHits() {
		return nbHits;
	}

	/**
	 * Sets the nb hits.
	 * 
	 * @param nbHits
	 *            the nbHits to set
	 */
	public void setNbHits(Long nbHits) {
		this.nbHits = nbHits;
	}

	/**
	 * Gets the prochaine maj periodicite.
	 * 
	 * @return the prochaineMajPeriodicite
	 */
	public String getProchaineMajPeriodicite() {
		return prochaineMajPeriodicite;
	}

	/**
	 * Sets the prochaine maj periodicite.
	 * 
	 * @param prochaineMajPeriodicite
	 *            the prochaineMajPeriodicite to set
	 */
	public void setProchaineMajPeriodicite(String prochaineMajPeriodicite) {
		this.prochaineMajPeriodicite = prochaineMajPeriodicite;
	}

	/**
	 * Gets the references isdn.
	 * 
	 * @return the referencesIsdn
	 */
	public String getReferencesIsdn() {
		return referencesIsdn;
	}

	/**
	 * Sets the references isdn.
	 * 
	 * @param referencesIsdn
	 *            the referencesIsdn to set
	 */
	public void setReferencesIsdn(String referencesIsdn) {
		this.referencesIsdn = referencesIsdn;
	}

	/**
	 * Gets the resume.
	 * 
	 * @return the resume
	 */
	public String getResume() {
		return resume;
	}

	/**
	 * Sets the resume.
	 * 
	 * @param resume
	 *            the resume to set
	 */
	public void setResume(String resume) {
		this.resume = resume;
	}

	/**
	 * Gets the source support.
	 * 
	 * @return the sourceSupport
	 */
	public String getSourceSupport() {
		return sourceSupport;
	}

	/**
	 * Sets the source support.
	 * 
	 * @param sourceSupport
	 *            the sourceSupport to set
	 */
	public void setSourceSupport(String sourceSupport) {
		this.sourceSupport = sourceSupport;
	}

	/**
	 * Gets the sous titre.
	 * 
	 * @return the sousTitre
	 */
	public String getSousTitre() {
		return sousTitre;
	}

	/**
	 * Sets the sous titre.
	 * 
	 * @param sousTitre
	 *            the sousTitre to set
	 */
	public void setSousTitre(String sousTitre) {
		this.sousTitre = sousTitre;
	}

	/**
	 * Gets the thematique.
	 * 
	 * @return the thematique
	 */
	public String getThematique() {
		return thematique;
	}

	/**
	 * Sets the thematique.
	 * 
	 * @param thematique
	 *            the thematique to set
	 */
	public void setThematique(String thematique) {
		this.thematique = thematique;
	}

	/**
	 * Gets the theme.
	 * 
	 * @return the theme
	 */
	public String getTheme() {
		return theme;
	}

	/**
	 * Sets the theme.
	 * 
	 * @param theme
	 *            the theme to set
	 */
	public void setTheme(String theme) {
		this.theme = theme;
	}

	/**
	 * Gets the titre.
	 * 
	 * @return the titre
	 */
	public String getTitre() {
		return titre;
	}

	/**
	 * Sets the titre.
	 * 
	 * @param titre
	 *            the titre to set
	 */
	public void setTitre(String titre) {
		this.titre = titre;
	}

	/**
	 * Gets the titre encadre.
	 * 
	 * @return the titreEncadre
	 */
	public String getTitreEncadre() {
		return titreEncadre;
	}

	/**
	 * Sets the titre encadre.
	 * 
	 * @param titreEncadre
	 *            the titreEncadre to set
	 */
	public void setTitreEncadre(String titreEncadre) {
		this.titreEncadre = titreEncadre;
	}

	/**
	 * Gets the type document.
	 * 
	 * @return the typeDocument
	 */
	public String getTypeDocument() {
		return typeDocument;
	}

	/**
	 * Sets the type document.
	 * 
	 * @param typeDocument
	 *            the typeDocument to set
	 */
	public void setTypeDocument(String typeDocument) {
		this.typeDocument = typeDocument;
	}
}
