/**
 * Copyright (C) 2015 Kosmos contact@kosmos.fr
 *
 * Projet: ged
 * Version: 1.02.04
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.objetspartages.misc;

import static com.univ.objetspartages.util.CritereRechercheUtil.getCritereChaineAvecLibelle;
import static com.univ.objetspartages.util.CritereRechercheUtil.getCritereDate;
import static com.univ.objetspartages.util.CritereRechercheUtil.getCritereTexteNonVideFormater;
import static com.univ.objetspartages.util.CritereRechercheUtil.getCritereThematique;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import com.jsbsoft.jtf.core.InfoBean;
import com.jsbsoft.jtf.core.LangueUtil;
import com.jsbsoft.jtf.database.OMContext;
import com.jsbsoft.jtf.exception.ErreurApplicative;
import com.kportal.cms.objetspartages.Objetpartage;
import com.univ.objetspartages.om.AbstractRechercheExterne;
import com.univ.objetspartages.om.Libelle;
import com.univ.objetspartages.om.ReferentielObjets;
import com.univ.objetspartages.om.Structure;
import com.univ.objetspartages.util.CritereRecherche;
import com.univ.utils.RechercheFicheHelper;

/**
 * The Class RechercheKosmosLien.
 */
public class RechercheDocument extends AbstractRechercheExterne {

	/**
	 * Prepare le formulaire de recherche.
	 * 
	 * @param infoBean
	 *            the info bean
	 * @param ctx
	 *            the ctx
	 * 
	 * @return true, if preparer recherche
	 * 
	 * @throws Exception
	 *             the exception
	 */
	@Override
	public boolean preparerRECHERCHE(final InfoBean infoBean, final OMContext ctx) throws Exception {
		boolean rechercheEffectuee = false;
		final String objet = StringUtils.defaultString(infoBean.getString("OBJET"), "").toUpperCase();
		final Locale locale = ctx.getLocale();
		if (objet.equals("DOCUMENT")) {
			infoBean.set("LISTE_TYPES_DOCUMENT", Libelle.getListe("40", locale));
			infoBean.set("LISTE_STRUCTURES", Structure.getListeStructuresPremierNiveau(String.valueOf(LangueUtil.getIndiceLocale(locale)), true));
			infoBean.set("LISTE_THEMATIQUES", Libelle.getListe("04", locale));
			rechercheEffectuee = true;
		}
		return rechercheEffectuee;
	}

	/**
	 * Traite la recherche.
	 * 
	 * @param infoBean
	 *            the info bean
	 * @param ctx
	 *            the ctx
	 * 
	 * @return true, if traiter recherche
	 * 
	 * @throws Exception
	 *             the exception
	 */
	@Override
	public boolean traiterRECHERCHE(final InfoBean infoBean, final OMContext ctx) throws Exception {
		boolean rechercheEffectuee = false;
		final String objet = infoBean.getString("OBJET").toUpperCase();
		if (objet.equals("DOCUMENT")) {
			final List<CritereRecherche> criteres = new ArrayList<>();
			criteres.add(new CritereRecherche("OBJET", objet, StringUtils.EMPTY));
			final Objetpartage module = ReferentielObjets.getObjetByNom(objet);
			CollectionUtils.addIgnoreNull(criteres, getCritereTexteNonVideFormater(infoBean, "TITRE"));
			CollectionUtils.addIgnoreNull(criteres, getCritereDate(infoBean, "DATE_DEBUT"));
			CollectionUtils.addIgnoreNull(criteres, getCritereDate(infoBean, "DATE_FIN"));
			CollectionUtils.addIgnoreNull(criteres, getCritereTexteNonVideFormater(infoBean, "AUTEUR"));
			CollectionUtils.addIgnoreNull(criteres, getCritereChaineAvecLibelle(infoBean, "TYPE_DOCUMENT", "40"));
			CollectionUtils.addIgnoreNull(criteres, getCritereThematique(infoBean));
			if ("0".equals(module.getProperty("fiche.DOCUMENT.recherche_vide"))) {
				if (criteres.size() <= 1) {
					throw new ErreurApplicative(module.getMessage(ctx.getLocale(), "ST_RECHERCHE_SAISIR_UN_CRITERE"));
				}
			}
			rechercheEffectuee = true;
			// attribut commun à toute les fiches
			criteres.addAll(getCritereDefaut(infoBean));
			infoBean.set(RechercheFicheHelper.ATTRIBUT_INFOBEAN_CRITERES, criteres);
			gestionAncienFront(infoBean, criteres);
		}
		return rechercheEffectuee;
	}

	@Override
	public List<String> getCriteresRequete(final String objet, final boolean listeIncluse) {
		final List<String> criteres = new ArrayList<>();
		if (objet.equals("DOCUMENT")) {
			criteres.add("TYPE_DOCUMENT");
			criteres.add("THEMATIQUE");
			criteres.add("DATE_DEBUT");
			criteres.add("DATE_FIN");
			if (listeIncluse) {
				criteres.add("SELECTION");
				criteres.add("NB_DAYS");
				criteres.add("TRI_DATE");
			}
		}
		return criteres;
	}
}
