/**
 * Copyright (C) 2015 Kosmos contact@kosmos.fr
 *
 * Projet: ged
 * Version: 1.02.04
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.objetspartages.processus;

import com.jsbsoft.jtf.core.InfoBean;
import com.jsbsoft.jtf.core.LangueUtil;
import com.univ.objetspartages.om.Document;
import com.univ.objetspartages.om.Libelle;

import java.sql.Date;

// TODO: Auto-generated Javadoc
/**
 * Processus de gestion des documents.
 */
public class SaisieDocument extends SaisieFiche {

	/** The document. */
	private Document document = null;

	/**
	 * Constructeur.
	 *
	 * @param infoBean
	 *            the info bean
	 */
	public SaisieDocument(final InfoBean infoBean) {
		super(infoBean);
	}

	/**
	 * Point d'entree du processus.
	 *
	 * @return true, if traiter action
	 *
	 * @throws Exception
	 *             the exception
	 */
	@Override
	public boolean traiterAction() throws Exception {
		infoBean.set("CODE_OBJET", "0017");
		etat = EN_COURS;
		document = new Document();
		document.setCtx(this);
		document.init();
		traiterActionParDefaut(document);
		infoBean.set("NOM_ONGLET", "document");
		// on continue si on n'est pas a la FIN !!!
		return (etat == FIN);
	}

	/**
	 * Affichage de l'ecran des criteres de recherche d'un(e) document.
	 *
	 * @throws Exception
	 *             the exception
	 */
	@Override
	protected void preparerRECHERCHE() throws Exception {
		ecranLogique = ECRAN_RECHERCHE;
		infoBean.set("LISTE_LANGUES", LangueUtil.getListeLangues(getLocale()));
		infoBean.set("LISTE_TYPES_DOCUMENT", Libelle.getListe("40", getLocale()));
		infoBean.set("LISTE_THEMATIQUES", Libelle.getListe("04", getLocale()));
	}

	/**
	 * Affichage de l'ecran de saisie d'un(e) document.
	 *
	 * @throws Exception
	 *             the exception
	 */
	@Override
	protected void preparerPRINCIPAL() throws Exception {
		ecranLogique = ECRAN_PRINCIPAL;
		infoBean.set("ID_DOCUMENT", document.getIdDocument().toString());
		infoBean.set("TITRE", document.getTitre());
		infoBean.set("TYPE_DOCUMENT", document.getTypeDocument());
		infoBean.set("LISTE_TYPE_DOCUMENT", Libelle.getListe("40", LangueUtil.getLocale(document.getLangue())));
		infoBean.set("CORPS", document.getDescription());
		infoBean.set("THEMATIQUE", document.getThematique());
		infoBean.set("LIBELLE_THEMATIQUE", document.getLibelleThematique());
		infoBean.set("LISTE_THEMATIQUES", Libelle.getListe("04", LangueUtil.getLocale(document.getLangue())));
		infoBean.set("SOUS_TITRE", document.getSousTitre());
		infoBean.set("RESUME", document.getResume());
		infoBean.set("DATE_CREATION_DOCUMENT", document.getDateCreationDocument());
		infoBean.set("SOURCE_SUPPORT", document.getSourceSupport());
		infoBean.set("AUTEURS", document.getAuteurs());
		infoBean.set("EDITEUR", document.getEditeur());
		infoBean.set("REFERENCES_ISDN", document.getReferencesIsdn());
		infoBean.set("DATE_PARUTION_DOCUMENT", document.getDateParutionDocument());
		infoBean.set("DATE_DERNIERE_MAJ_DOCUMENT", document.getDateDerniereMajDocument());
		infoBean.set("PROCHAINE_MAJ_PERIODICITE", document.getProchaineMajPeriodicite());
		infoBean.set("COMPLEMENTS", document.getComplements());
		infoBean.set("CODE_RUBRIQUE", document.getCodeRubrique());
		infoBean.set("LIBELLE_CODE_RUBRIQUE", document.getInfosRubrique().getLibelleAffichable());
		infoBean.set("CODE_RATTACHEMENT", document.getCodeRattachement());
		infoBean.set("LIBELLE_CODE_RATTACHEMENT", document.getInfosStructure().getLibelleAffichable());
		infoBean.set("LIBELLE_AFFICHABLE", document.getLibelleAffichable());
		infoBean.set("SOUS_ONGLET", "PRINCIPAL"); // onglet par defaut
		ControleurUniv.preparerPRINCIPAL(infoBean, document, this);
	}

	/**
	 * Traite l'ecran de saisie d'une fiche.
	 *
	 * @throws Exception
	 *             the exception
	 */
	@Override
	protected void traiterPRINCIPAL() throws Exception {
		// chargement de l'objet
		if (infoBean.getEtatObjet().equals(InfoBean.ETAT_OBJET_CREATION)) {
			document.init();
		} else {
			document.setIdDocument(new Long(infoBean.getString("ID_DOCUMENT")));
			document.retrieve();
		}
		// changement d'onglet
		if (action.equals(InfoBean.ACTION_ONGLET)) {
			infoBean.set("SOUS_ONGLET", infoBean.getString("SOUS_ONGLET_DEMANDE"));
		}
		// validation de l'ecran
		else if (action.equals(InfoBean.ACTION_ENREGISTRER)) {
			if (infoBean.getEtatObjet().equals(InfoBean.ETAT_OBJET_CREATION)) {
				// donnees saisissables uniquement en creation
				document.setLangue(infoBean.getString("LANGUE"));
				document.setCode(Long.toString(System.currentTimeMillis()));
			}
			document.setTitre((String) infoBean.get("TITRE"));
			document.setThematique((String) infoBean.get("THEMATIQUE"));
			document.setTypeDocument((String) infoBean.get("TYPE_DOCUMENT"));
			document.setResume((String) infoBean.get("RESUME"));
			document.setDescription((String) infoBean.get("CORPS"));
			document.setAuteurs((String) infoBean.get("AUTEURS"));
			document.setSousTitre((String) infoBean.get("SOUS_TITRE"));
			document.setResume((String) infoBean.get("RESUME"));
			document.setDateCreationDocument((Date) infoBean.get("DATE_CREATION_DOCUMENT"));
			document.setSourceSupport((String) infoBean.get("SOURCE_SUPPORT"));
			document.setEditeur((String) infoBean.get("EDITEUR"));
			document.setReferencesIsdn((String) infoBean.get("REFERENCES_ISDN"));
			document.setDateParutionDocument((Date) infoBean.get("DATE_PARUTION_DOCUMENT"));
			document.setDateDerniereMajDocument((Date) infoBean.get("DATE_DERNIERE_MAJ_DOCUMENT"));
			document.setProchaineMajPeriodicite((String) infoBean.get("PROCHAINE_MAJ_PERIODICITE"));
			document.setComplements((String) infoBean.get("COMPLEMENTS"));
			if (infoBean.get("CODE_RUBRIQUE") != null && infoBean.getString("CODE_RUBRIQUE").equals("0000") == false) {
				document.setCodeRubrique(infoBean.getString("CODE_RUBRIQUE"));
			} else {
				document.setCodeRubrique("");
			}
			document.setCodeRattachement(infoBean.getString("CODE_RATTACHEMENT"));
		}
		// appel au traitement general
		ecranLogique = ControleurUniv.traiterPRINCIPAL(infoBean, document, this);
		if (ecranLogique.length() == 0) {
			etat = FIN;
		}
	}
}
