/**
 * Copyright (C) 2015 Kosmos contact@kosmos.fr
 *
 * Projet: ged
 * Version: 1.02.04
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.objetspartages.sgbd;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Types;

import com.jsbsoft.jtf.database.OMContext;
import com.univ.objetspartages.bean.DocumentBean;

// TODO: Auto-generated Javadoc
/**
 * Classe d'acces aux donnees pour document.
 */
public class DocumentDB extends DocumentBean {

	/**
	 *
	 */
	private static final long serialVersionUID = -2621857935554846180L;

	/** The ctx. */
	protected transient OMContext ctx = null;

	/** The rs. */
	private transient ResultSet rs = null;

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return toString(".");
	}

	/**
	 * To string.
	 *
	 * @param aSeparator
	 *            the a separator
	 *
	 * @return the string
	 */
	public String toString(final String aSeparator) {
		final String s = "" + getIdDocument() + aSeparator + getTitre() + aSeparator + getSousTitre() + aSeparator + getResume() + aSeparator + getDateCreationDocument() + aSeparator + getTypeDocument() + aSeparator + getSourceSupport() + aSeparator + getAuteurs() + aSeparator + getEditeur() + aSeparator + getDescription() + aSeparator + getReferencesIsdn() + aSeparator + getDateParutionDocument() + aSeparator + getDateDerniereMajDocument() + aSeparator + getDateArchivageDocument() + aSeparator + getProchaineMajPeriodicite() + aSeparator + getTheme() + aSeparator + getThematique() + aSeparator + getComiteSelection() + aSeparator + getComplements() + aSeparator + getCode() + aSeparator + getCodeRubrique() + aSeparator + getCodeRattachement() + aSeparator + getMetaKeywords() + aSeparator + getMetaDescription() + aSeparator + getTitreEncadre() + aSeparator + getContenuEncadre() + aSeparator + getEncadreRecherche() + aSeparator + getEncadreRechercheBis() + aSeparator + getDateAlerte() + aSeparator + getMessageAlerte() + aSeparator + getDateCreation() + aSeparator + getDateProposition() + aSeparator + getDateValidation() + aSeparator + getDateModification() + aSeparator + getCodeRedacteur() + aSeparator + getCodeValidation() + aSeparator + getLangue() + aSeparator + getEtatObjet() + aSeparator + getNbHits() + aSeparator + getDiffusionPublicVise() + aSeparator + getDiffusionModeRestriction() + aSeparator + getDiffusionPublicViseRestriction();
		return s;
	}

	/**
	 * Sets the ctx.
	 *
	 * @param _ctx
	 *            the new ctx
	 */
	public void setCtx(final OMContext _ctx) {
		ctx = _ctx;
	}

	/**
	 * Gets the connection.
	 *
	 * @return the connection
	 */
	private Connection getConnection() {
		return ctx.getConnection();
	}

	/**
	 * Adds the.
	 *
	 * @throws Exception
	 *             the exception
	 */
	public void add() throws Exception {
		PreparedStatement stmt = null;
		ResultSet rs = null;
		try {
			stmt = getConnection().prepareStatement("insert into DOCUMENT (ID_DOCUMENT , TITRE , SOUS_TITRE , RESUME , DATE_CREATION_DOCUMENT , TYPE_DOCUMENT , SOURCE_SUPPORT , AUTEURS , EDITEUR , DESCRIPTION , REFERENCES_ISDN , DATE_PARUTION_DOCUMENT , DATE_DERNIERE_MAJ_DOCUMENT , DATE_ARCHIVAGE_DOCUMENT , PROCHAINE_MAJ_PERIODICITE , THEME , THEMATIQUE , COMITE_SELECTION , COMPLEMENTS , CODE , CODE_RUBRIQUE , CODE_RATTACHEMENT , META_KEYWORDS , META_DESCRIPTION , TITRE_ENCADRE , CONTENU_ENCADRE , ENCADRE_RECHERCHE , ENCADRE_RECHERCHE_BIS , DATE_ALERTE , MESSAGE_ALERTE , DATE_CREATION , DATE_PROPOSITION , DATE_VALIDATION , DATE_MODIFICATION , CODE_REDACTEUR , CODE_VALIDATION , LANGUE , ETAT_OBJET , NB_HITS , DIFFUSION_PUBLIC_VISE , DIFFUSION_MODE_RESTRICTION , DIFFUSION_PUBLIC_VISE_RESTRICTION) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", Statement.RETURN_GENERATED_KEYS);
			stmt.setObject(1, getIdDocument(), Types.BIGINT);
			stmt.setObject(2, getTitre(), Types.VARCHAR);
			stmt.setObject(3, getSousTitre(), Types.LONGVARCHAR);
			stmt.setObject(4, getResume(), Types.LONGVARCHAR);
			stmt.setObject(5, getDateCreationDocument(), Types.DATE);
			stmt.setObject(6, getTypeDocument(), Types.VARCHAR);
			stmt.setObject(7, getSourceSupport(), Types.LONGVARCHAR);
			stmt.setObject(8, getAuteurs(), Types.LONGVARCHAR);
			stmt.setObject(9, getEditeur(), Types.LONGVARCHAR);
			stmt.setObject(10, getDescription(), Types.LONGVARCHAR);
			stmt.setObject(11, getReferencesIsdn(), Types.LONGVARCHAR);
			stmt.setObject(12, getDateParutionDocument(), Types.DATE);
			stmt.setObject(13, getDateDerniereMajDocument(), Types.DATE);
			stmt.setObject(14, getDateArchivageDocument(), Types.DATE);
			stmt.setObject(15, getProchaineMajPeriodicite(), Types.VARCHAR);
			stmt.setObject(16, getTheme(), Types.VARCHAR);
			stmt.setObject(17, getThematique(), Types.VARCHAR);
			stmt.setObject(18, getComiteSelection(), Types.LONGVARCHAR);
			stmt.setObject(19, getComplements(), Types.LONGVARCHAR);
			stmt.setObject(20, getCode(), Types.VARCHAR);
			stmt.setObject(21, getCodeRubrique(), Types.VARCHAR);
			stmt.setObject(22, getCodeRattachement(), Types.VARCHAR);
			stmt.setObject(23, getMetaKeywords(), Types.LONGVARCHAR);
			stmt.setObject(24, getMetaDescription(), Types.LONGVARCHAR);
			stmt.setObject(25, getTitreEncadre(), Types.VARCHAR);
			stmt.setObject(26, getContenuEncadre(), Types.LONGVARCHAR);
			stmt.setObject(27, getEncadreRecherche(), Types.VARCHAR);
			stmt.setObject(28, getEncadreRechercheBis(), Types.VARCHAR);
			stmt.setObject(29, getDateAlerte(), Types.DATE);
			stmt.setObject(30, getMessageAlerte(), Types.LONGVARCHAR);
			stmt.setObject(31, getDateCreation(), Types.TIMESTAMP);
			stmt.setObject(32, getDateProposition(), Types.TIMESTAMP);
			stmt.setObject(33, getDateValidation(), Types.TIMESTAMP);
			stmt.setObject(34, getDateModification(), Types.TIMESTAMP);
			stmt.setObject(35, getCodeRedacteur(), Types.VARCHAR);
			stmt.setObject(36, getCodeValidation(), Types.VARCHAR);
			stmt.setObject(37, getLangue(), Types.VARCHAR);
			stmt.setObject(38, getEtatObjet(), Types.VARCHAR);
			stmt.setObject(39, getNbHits(), Types.BIGINT);
			stmt.setObject(40, getDiffusionPublicVise(), Types.VARCHAR);
			stmt.setObject(41, getDiffusionModeRestriction(), Types.VARCHAR);
			stmt.setObject(42, getDiffusionPublicViseRestriction(), Types.VARCHAR);
			final int rowsAffected = stmt.executeUpdate();
			if (rowsAffected == 0) {
				throw new Exception("METHOD_AFFCTD_NOROWS");
			} else if (rowsAffected > 1) {
				throw new Exception("METHOD_AFFCTD_MULTROWS");
			}
			rs = stmt.getGeneratedKeys();
			rs.next();
			setIdDocument(rs.getLong(1));
		} catch (final SQLException e) {
			throw new Exception("ERROR_IN_METHOD add()", e);
		} finally {
			if (rs != null) {
				rs.close();
			}
			if (stmt != null) {
				stmt.close();
			}
		}
	}

	/**
	 * Delete.
	 *
	 * @throws Exception
	 *             the exception
	 */
	public void delete() throws Exception {
		PreparedStatement stmt = null;
		try {
			stmt = getConnection().prepareStatement("delete from DOCUMENT " + "where ID_DOCUMENT = ?");
			// put parameters into statement
			stmt.setObject(1, getIdDocument(), Types.BIGINT);
			final int rowsAffected = stmt.executeUpdate();
			if (rowsAffected == 0) {
				throw new Exception("METHOD_AFFCTD_NOROWS");
			} else if (rowsAffected > 1) {
				throw new Exception("METHOD_AFFCTD_MULTROWS");
			}
		} catch (final SQLException e) {
			throw new Exception("ERROR_IN_METHOD delete()", e);
		} finally {
			if (stmt != null) {
				stmt.close();
			}
		}
	}

	/**
	 * Gets the sQL base query.
	 *
	 * @return the sQL base query
	 */
	public String getSQLBaseQuery() {
		final String query = "select distinct " + "T1.ID_DOCUMENT, " + "T1.TITRE, " + "T1.SOUS_TITRE, " + "T1.RESUME, " + "T1.DATE_CREATION_DOCUMENT, " + "T1.TYPE_DOCUMENT, " + "T1.SOURCE_SUPPORT, " + "T1.AUTEURS, " + "T1.EDITEUR, " + "T1.DESCRIPTION, " + "T1.REFERENCES_ISDN, " + "T1.DATE_PARUTION_DOCUMENT, " + "T1.DATE_DERNIERE_MAJ_DOCUMENT, " + "T1.DATE_ARCHIVAGE_DOCUMENT, " + "T1.PROCHAINE_MAJ_PERIODICITE, " + "T1.THEME, " + "T1.THEMATIQUE, " + "T1.COMITE_SELECTION, " + "T1.COMPLEMENTS, " + "T1.CODE, " + "T1.CODE_RUBRIQUE, " + "T1.CODE_RATTACHEMENT, " + "T1.META_KEYWORDS, " + "T1.META_DESCRIPTION, " + "T1.TITRE_ENCADRE, " + "T1.CONTENU_ENCADRE, " + "T1.ENCADRE_RECHERCHE, " + "T1.ENCADRE_RECHERCHE_BIS, " + "T1.DATE_ALERTE, " + "T1.MESSAGE_ALERTE, " + "T1.DATE_CREATION, " + "T1.DATE_PROPOSITION, " + "T1.DATE_VALIDATION, " + "T1.DATE_MODIFICATION, " + "T1.CODE_REDACTEUR, " + "T1.CODE_VALIDATION, " + "T1.LANGUE, " + "T1.ETAT_OBJET, " + "T1.NB_HITS, " + "T1.DIFFUSION_PUBLIC_VISE, " + "T1.DIFFUSION_MODE_RESTRICTION, " + "T1.DIFFUSION_PUBLIC_VISE_RESTRICTION " + "from DOCUMENT T1 ";
		return query;
	}

	/**
	 * Gets the sQL base optimized query.
	 *
	 * @return the sQL base optimized query
	 */
	public String getSQLBaseOptimizedQuery() {
		final String query = "select " + "T1.ID_DOCUMENT, " + "T1.CODE, " + "T1.LANGUE " + "from DOCUMENT T1 ";
		return query;
	}

	/**
	 * Renvoie l'element suivant du ResultSet.
	 *
	 * @return true, if next item
	 *
	 * @throws Exception
	 *             the exception
	 */
	public boolean nextItem() throws Exception {
		boolean res = false;
		try {
			if (rs.next()) {
				if (ctx.getDatas().get("optimizedSelect") != null) {
					retrieveFromOptimizedRS();
				} else {
					retrieveFromRS();
				}
				res = true;
			} else {
				try {
					rs.close();
				} finally {
					rs = null;
				}
			}
		} catch (final Exception e) {
			throw new Exception("ERROR_IN_METHOD nextItem()", e);
		}
		return res;
	}

	/**
	 * Recuperation d'une ligne de la base de donnees.
	 *
	 * @throws Exception
	 *             the exception
	 */
	public void retrieve() throws Exception {
		PreparedStatement stmt = null;
		try {
			stmt = getConnection().prepareStatement(
				"select " + "T1.ID_DOCUMENT, " + "T1.TITRE, " + "T1.SOUS_TITRE, " + "T1.RESUME, " + "T1.DATE_CREATION_DOCUMENT, " + "T1.TYPE_DOCUMENT, " + "T1.SOURCE_SUPPORT, " + "T1.AUTEURS, " + "T1.EDITEUR, " + "T1.DESCRIPTION, " + "T1.REFERENCES_ISDN, " + "T1.DATE_PARUTION_DOCUMENT, " + "T1.DATE_DERNIERE_MAJ_DOCUMENT, " + "T1.DATE_ARCHIVAGE_DOCUMENT, " + "T1.PROCHAINE_MAJ_PERIODICITE, " + "T1.THEME, " + "T1.THEMATIQUE, " + "T1.COMITE_SELECTION, " + "T1.COMPLEMENTS, " + "T1.CODE, " + "T1.CODE_RUBRIQUE, " + "T1.CODE_RATTACHEMENT, " + "T1.META_KEYWORDS, " + "T1.META_DESCRIPTION, " + "T1.TITRE_ENCADRE, " + "T1.CONTENU_ENCADRE, " + "T1.ENCADRE_RECHERCHE, " + "T1.ENCADRE_RECHERCHE_BIS, " + "T1.DATE_ALERTE, " + "T1.MESSAGE_ALERTE, " + "T1.DATE_CREATION, " + "T1.DATE_PROPOSITION, " + "T1.DATE_VALIDATION, " + "T1.DATE_MODIFICATION, " + "T1.CODE_REDACTEUR, " + "T1.CODE_VALIDATION, " + "T1.LANGUE, " + "T1.ETAT_OBJET, " + "T1.NB_HITS, " + "T1.DIFFUSION_PUBLIC_VISE, " + "T1.DIFFUSION_MODE_RESTRICTION, " + "T1.DIFFUSION_PUBLIC_VISE_RESTRICTION " + "from DOCUMENT T1 " + "where T1.ID_DOCUMENT = ?");
			stmt.setObject(1, getIdDocument(), Types.BIGINT);
			rs = stmt.executeQuery();
			if (!rs.next()) {
				throw new Exception("retrieve : METHOD_NO_RESULTS");
			}
			retrieveFromRS();
		} catch (final SQLException e) {
			throw new Exception("ERROR_IN_METHOD retrieve()", e);
		} finally {
			if (rs != null) {
				rs.close();
			}
			if (stmt != null) {
				stmt.close();
			}
		}
	}

	/**
	 * Retrieve from rs.
	 *
	 * @throws Exception
	 *             the exception
	 */
	private void retrieveFromRS() throws Exception {
		try {
			// get output from result set
			setIdDocument(new Long(rs.getLong(1)));
			setTitre(rs.getString(2));
			setSousTitre(rs.getString(3));
			setResume(rs.getString(4));
			setDateCreationDocument(rs.getDate(5));
			setTypeDocument(rs.getString(6));
			setSourceSupport(rs.getString(7));
			setAuteurs(rs.getString(8));
			setEditeur(rs.getString(9));
			setDescription(rs.getString(10));
			setReferencesIsdn(rs.getString(11));
			setDateParutionDocument(rs.getDate(12));
			setDateDerniereMajDocument(rs.getDate(13));
			setDateArchivageDocument(rs.getDate(14));
			setProchaineMajPeriodicite(rs.getString(15));
			setTheme(rs.getString(16));
			setThematique(rs.getString(17));
			setComiteSelection(rs.getString(18));
			setComplements(rs.getString(19));
			setCode(rs.getString(20));
			setCodeRubrique(rs.getString(21));
			setCodeRattachement(rs.getString(22));
			setMetaKeywords(rs.getString(23));
			setMetaDescription(rs.getString(24));
			setTitreEncadre(rs.getString(25));
			setContenuEncadre(rs.getString(26));
			setEncadreRecherche(rs.getString(27));
			setEncadreRechercheBis(rs.getString(28));
			setDateAlerte(rs.getDate(29));
			setMessageAlerte(rs.getString(30));
			setDateCreation(new Date(rs.getTimestamp(31).getTime()));
			setDateProposition(new Date(rs.getTimestamp(32).getTime()));
			setDateValidation(new Date(rs.getTimestamp(33).getTime()));
			setDateModification(new Date(rs.getTimestamp(34).getTime()));
			setCodeRedacteur(rs.getString(35));
			setCodeValidation(rs.getString(36));
			setLangue(rs.getString(37));
			setEtatObjet(rs.getString(38));
			setNbHits(new Long(rs.getLong(39)));
			setDiffusionPublicVise(rs.getString(40));
			setDiffusionModeRestriction(rs.getString(41));
			setDiffusionPublicViseRestriction(rs.getString(42));
		} catch (final SQLException e) {
			throw new Exception("ERROR_IN_METHOD retrieveFromRS()", e);
		}
	}

	/**
	 * Retrieve from optimized rs.
	 *
	 * @throws Exception
	 *             the exception
	 */
	private void retrieveFromOptimizedRS() throws Exception {
		try {
			// get output from result set
			setIdDocument(new Long(rs.getLong(1)));
			setCode(rs.getString(2));
			setLangue(rs.getString(3));
		} catch (final SQLException e) {
			throw new Exception("ERROR_IN_METHOD retrieveFromOptimizedRS()", e);
		}
	}

	/**
	 * Cette methode optimise l'execution de la requete (pas de count).
	 *
	 * @param sqlSuffix
	 *            the sql suffix
	 *
	 * @throws Exception
	 *             the exception
	 */
	public void selectNoCount(final String sqlSuffix) throws Exception {
		PreparedStatement stmt = null;
		try {
			String query = getSQLBaseQuery();
			if (sqlSuffix != null) {
				query += sqlSuffix;
			}
			stmt = getConnection().prepareStatement(query);
			rs = stmt.executeQuery();
		} catch (final SQLException e) {
			throw new Exception("SELECT_FAILED", e);
		}
	}

	/**
	 * Select.
	 *
	 * @param sqlSuffix
	 *            the sql suffix
	 *
	 * @return the int
	 *
	 * @throws Exception
	 *             the exception
	 */
	public int select(final String sqlSuffix) throws Exception {
		int count = 0;
		if (ctx.getDatas().get("optimizedObject") != null && ctx.getDatas().get("optimizedSelect") != null) {
			count = selectNoCountOptimized(sqlSuffix);
		} else {
			PreparedStatement stmt = null;
			try {
				// recuperation nombre de lignes
				String query = "select count(distinct T1.ID_DOCUMENT) from DOCUMENT T1 ";
				if (sqlSuffix != null) {
					query += sqlSuffix;
				}
				stmt = getConnection().prepareStatement(query);
				rs = stmt.executeQuery();
				rs.next();
				count = rs.getInt(1);
				// execution requete
				query = getSQLBaseQuery();
				if (sqlSuffix != null) {
					query += sqlSuffix;
				}
				stmt = getConnection().prepareStatement(query);
				rs = stmt.executeQuery();
			} catch (final SQLException e) {
				throw new Exception("SELECT_FAILED", e);
			}
		}
		return count;
	}

	/**
	 * Select no count optimized.
	 *
	 * @param sqlSuffix
	 *            the sql suffix
	 *
	 * @return the int
	 *
	 * @throws Exception
	 *             the exception
	 */
	private int selectNoCountOptimized(final String sqlSuffix) throws Exception {
		PreparedStatement stmt = null;
		final int count = -1;
		try {
			String query = getSQLBaseOptimizedQuery();
			if (sqlSuffix != null) {
				query += sqlSuffix;
			}
			if (ctx.getDatas().get("optimizedLimit") != null) {
				query += " limit 0," + (String) ctx.getDatas().get("optimizedLimit") + "0";
			}
			stmt = getConnection().prepareStatement(query);
			rs = stmt.executeQuery();
		} catch (final SQLException e) {
			throw new Exception("SELECT_FAILED", e);
		}
		return count;
	}

	/**
	 * Mise a jour d'une ligne de la base de donnees.
	 *
	 * @throws Exception
	 *             the exception
	 */
	public void update() throws Exception {
		PreparedStatement stmt = null;
		try {
			stmt = getConnection().prepareStatement(
				"update DOCUMENT set " + "ID_DOCUMENT = ?, " + "TITRE = ?, " + "SOUS_TITRE = ?, " + "RESUME = ?, " + "DATE_CREATION_DOCUMENT = ?, " + "TYPE_DOCUMENT = ?, " + "SOURCE_SUPPORT = ?, " + "AUTEURS = ?, " + "EDITEUR = ?, " + "DESCRIPTION = ?, " + "REFERENCES_ISDN = ?, " + "DATE_PARUTION_DOCUMENT = ?, " + "DATE_DERNIERE_MAJ_DOCUMENT = ?, " + "DATE_ARCHIVAGE_DOCUMENT = ?, " + "PROCHAINE_MAJ_PERIODICITE = ?, " + "THEME = ?, " + "THEMATIQUE = ?, " + "COMITE_SELECTION = ?, " + "COMPLEMENTS = ?, " + "CODE = ?, " + "CODE_RUBRIQUE = ?, " + "CODE_RATTACHEMENT = ?, " + "META_KEYWORDS = ?, " + "META_DESCRIPTION = ?, " + "TITRE_ENCADRE = ?, " + "CONTENU_ENCADRE = ?, " + "ENCADRE_RECHERCHE = ?, " + "ENCADRE_RECHERCHE_BIS = ?, " + "DATE_ALERTE = ?, " + "MESSAGE_ALERTE = ?, " + "DATE_CREATION = ?, " + "DATE_PROPOSITION = ?, " + "DATE_VALIDATION = ?, " + "DATE_MODIFICATION = ?, " + "CODE_REDACTEUR = ?, " + "CODE_VALIDATION = ?, " + "LANGUE = ?, " + "ETAT_OBJET = ?, " + "NB_HITS = ?, " + "DIFFUSION_PUBLIC_VISE = ?, " + "DIFFUSION_MODE_RESTRICTION = ?, " + "DIFFUSION_PUBLIC_VISE_RESTRICTION = ? " + "where ID_DOCUMENT = ?");
			// put parameters into statement
			stmt.setObject(1, getIdDocument(), Types.BIGINT);
			stmt.setObject(2, getTitre(), Types.VARCHAR);
			stmt.setObject(3, getSousTitre(), Types.LONGVARCHAR);
			stmt.setObject(4, getResume(), Types.LONGVARCHAR);
			stmt.setObject(5, getDateCreationDocument(), Types.DATE);
			stmt.setObject(6, getTypeDocument(), Types.VARCHAR);
			stmt.setObject(7, getSourceSupport(), Types.LONGVARCHAR);
			stmt.setObject(8, getAuteurs(), Types.LONGVARCHAR);
			stmt.setObject(9, getEditeur(), Types.LONGVARCHAR);
			stmt.setObject(10, getDescription(), Types.LONGVARCHAR);
			stmt.setObject(11, getReferencesIsdn(), Types.LONGVARCHAR);
			stmt.setObject(12, getDateParutionDocument(), Types.DATE);
			stmt.setObject(13, getDateDerniereMajDocument(), Types.DATE);
			stmt.setObject(14, getDateArchivageDocument(), Types.DATE);
			stmt.setObject(15, getProchaineMajPeriodicite(), Types.VARCHAR);
			stmt.setObject(16, getTheme(), Types.VARCHAR);
			stmt.setObject(17, getThematique(), Types.VARCHAR);
			stmt.setObject(18, getComiteSelection(), Types.LONGVARCHAR);
			stmt.setObject(19, getComplements(), Types.LONGVARCHAR);
			stmt.setObject(20, getCode(), Types.VARCHAR);
			stmt.setObject(21, getCodeRubrique(), Types.VARCHAR);
			stmt.setObject(22, getCodeRattachement(), Types.VARCHAR);
			stmt.setObject(23, getMetaKeywords(), Types.LONGVARCHAR);
			stmt.setObject(24, getMetaDescription(), Types.LONGVARCHAR);
			stmt.setObject(25, getTitreEncadre(), Types.VARCHAR);
			stmt.setObject(26, getContenuEncadre(), Types.LONGVARCHAR);
			stmt.setObject(27, getEncadreRecherche(), Types.VARCHAR);
			stmt.setObject(28, getEncadreRechercheBis(), Types.VARCHAR);
			stmt.setObject(29, getDateAlerte(), Types.DATE);
			stmt.setObject(30, getMessageAlerte(), Types.LONGVARCHAR);
			stmt.setObject(31, getDateCreation(), Types.TIMESTAMP);
			stmt.setObject(32, getDateProposition(), Types.TIMESTAMP);
			stmt.setObject(33, getDateValidation(), Types.TIMESTAMP);
			stmt.setObject(34, getDateModification(), Types.TIMESTAMP);
			stmt.setObject(35, getCodeRedacteur(), Types.VARCHAR);
			stmt.setObject(36, getCodeValidation(), Types.VARCHAR);
			stmt.setObject(37, getLangue(), Types.VARCHAR);
			stmt.setObject(38, getEtatObjet(), Types.VARCHAR);
			stmt.setObject(39, getNbHits(), Types.BIGINT);
			stmt.setObject(40, getDiffusionPublicVise(), Types.VARCHAR);
			stmt.setObject(41, getDiffusionModeRestriction(), Types.VARCHAR);
			stmt.setObject(42, getDiffusionPublicViseRestriction(), Types.VARCHAR);
			stmt.setObject(43, getIdDocument(), Types.BIGINT);
			stmt.executeUpdate();
		} catch (final SQLException e) {
			throw new Exception("ERROR_IN_METHOD update()", e);
		} finally {
			if (stmt != null) {
				stmt.close();
			}
		}
	}
}
