/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.jsbsoft.jtf.core;

import com.jsbsoft.jtf.exception.JsbException;

/**
 * Superclasse de tous les processus <BR>
 * Méthodes à écrire dans les sous-classes:
 * <UL>
 * <LI>Le constructeur avec en paramètre le composant d'information
 * <LI>traiterAction <BR>
 * (classe interne jtf).
 */
public abstract class AbstractProcessusBean implements ModuleExitProcessus {

	/**
	 * Le <B>composant information</B> auquel le composant activité s'adresse pour récupérer des données.<BR>
	 * <B>Initialisé et partagé avec le Bean PU</B>
	 */
	public InfoBean infoBean;

	/** Ecran logique du processus. */
	protected String ecranLogique;

	/** Etat initial du processus. */
	protected static final int DEBUT = 0;

	/** Etat en cours du processus. */
	protected static final int EN_COURS = 1;

	/** Etat final du processus (il peut rester un écran pour info). */
	protected static final int FIN = 2;

	/** code de l'état du processus le composant Information. */
	protected int etat = DEBUT;

	/** The gp. */
	private ProcessusManager gp = null;

	/** The id requete. */
	public String idRequete = "";

	/**
	 * Définition abstraite d'un processus.
	 * 
	 * @param _infoBean
	 *            the _info bean
	 */
	public AbstractProcessusBean(final InfoBean _infoBean) {
		infoBean = _infoBean;
		etat = DEBUT;
		ecranLogique = "";
	}

	/**
	 * Abandon du processus.
	 */
	public abstract void traiterAbandon();

	/**
	 * Permet de traiter le retour d'un sous-processus.
	 * 
	 * @param _gp
	 *            the _gp
	 * @param cloneCI
	 *            the clone ci
	 * 
	 * @return the descriptif page retour
	 * 
	 * @throws Exception
	 *             the exception
	 */
	@Override
	public DescriptifPageRetour apresProcessus(final ProcessusManager _gp, final InfoBean cloneCI) throws Exception {
		return null;
	}

	/**
	 * Renvoie la composant d'information du processus.
	 * 
	 * @return the info bean
	 */
	public InfoBean getInfoBean() {
		return infoBean;
	}

	/**
	 * Renvoie le gestionnaire de processus associé à la procédure.
	 * 
	 * @return the gp
	 */
	public ProcessusManager getGp() {
		return gp;
	}

	/**
	 * Association d'une connection JDBC au processus.
	 * 
	 * @throws JsbException
	 *             the jsb exception
	 */
	protected abstract void initConnection() throws JsbException;

	/**
	 * Libération de la connexion JDBC.
	 * 
	 * @throws JsbException
	 *             the jsb exception
	 */
	protected abstract void releaseConnection() throws JsbException;

	/**
	 * Valorisation du gestionnaire de processus.
	 * 
	 * @param newGp
	 *            the new gp
	 */
	protected void setGp(final ProcessusManager newGp) {
		gp = newGp;
	}

	/**
	 * Traite les dernières données collectées et renvoie vrai si le processus est terminé.
	 * 
	 * @return boolean
	 * 
	 * @throws Exception
	 *             the exception
	 */
	protected abstract boolean traiterAction() throws Exception;

	/**
	 * Gets the id requete.
	 * 
	 * @return the id requete
	 */
	public String getIdRequete() {
		return idRequete;
	}

	/**
	 * Sets the id requete.
	 * 
	 * @param string
	 *            the string
	 */
	public void setIdRequete(final String string) {
		idRequete = string;
	}
}
