/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.jsbsoft.jtf.core;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.type.filter.AssignableTypeFilter;

public class ClassBeanManager {

	/** The Constant LOG. */
	private static final Logger LOG = LoggerFactory.getLogger(ClassBeanManager.class);

	public static final String ID_BEAN = "classBeanManager";

	public List<String> packages;

	public List<String> classes;

	public List<String> getPackages() {
		return packages;
	}

	public void setPackages(final List<String> packages) {
		this.packages = packages;
	}

	public List<String> getClasses() {
		return classes;
	}

	public void setClasses(final List<String> classes) {
		this.classes = classes;
	}

	GenericApplicationContext contexte;

	public void refresh() {
		contexte = new GenericApplicationContext();
		try {
			final ClassPathBeanDefinitionScanner s = new ClassPathBeanDefinitionScanner(contexte, false);
			for (final String classe : classes) {
				s.addIncludeFilter(new AssignableTypeFilter(Class.forName(classe)));
			}
			s.setIncludeAnnotationConfig(false);
			s.scan(packages.toArray(new String[packages.size()]));
		} catch (final Exception e) {
			LOG.error("Erreur de chargement des beans utils", e);
		}
	}

	public <T> Collection<T> getBeanOfType(final Class<T> classe) {
		return contexte.getBeansOfType(classe).values();
	}

	public Collection<?> getBeansWithAnnotation(final Class<? extends Annotation> annotationType) {
		return contexte.getBeansWithAnnotation(annotationType).values();
	}

	public static ClassBeanManager getInstance() {
		return (ClassBeanManager) ApplicationContextManager.getCoreContextBean(ID_BEAN);
	}

}
