/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.jsbsoft.jtf.core;

/**
 * Module de traitement d'un procédure . A sous-classer (classe interne jtf)
 */
class DefaultExitModule implements ModuleExit {

	/**
	 * Commentaire relatif au constructeur DefaltExitModule.
	 */
	public DefaultExitModule() {
		super();
	}

	/**
	 * Commentaire relatif à la méthode apresCollecte.
	 *
	 * @param procedure
	 *            the procedure
	 *
	 * @return the descriptif page retour
	 *
	 */
	@Override
	public DescriptifPageRetour apresCollecte(final ProcedureBean procedure) {
		return null;
	}

	/**
	 * Commentaire relatif à la méthode apresProcessus.
	 *
	 * @param gp
	 *            the gp
	 * @param cloneCI
	 *            the clone ci
	 *
	 * @return the descriptif page retour
	 *
	 * @throws Exception
	 *             the exception
	 */
	@Override
	public DescriptifPageRetour apresProcessus(final ProcessusManager gp, final InfoBean cloneCI) throws Exception {
		return null;
	}

	/**
	 * Commentaire relatif à la méthode apresSousPU.
	 *
	 * @param procedure
	 *            the procedure
	 * @param infoBeanSousPU
	 *            the info bean sous pu
	 *
	 * @return the descriptif page retour
	 */
	@Override
	public DescriptifPageRetour apresSousPU(final ProcedureBean procedure, final InfoBean infoBeanSousPU) {
		return null;
	}

	/**
	 * Commentaire relatif à la méthode calculEcranPhysique.
	 *
	 * @param procedure
	 *            the procedure
	 *
	 * @return the descriptif page retour
	 *
	 * @throws Exception
	 *             the exception
	 */
	@Override
	public DescriptifPageRetour calculEcranPhysique(final ProcedureBean procedure) throws Exception {
		return null;
	}
}