/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.jsbsoft.jtf.core;

import com.jsbsoft.jtf.database.ProcessusBean;

public class ErrorProcessus extends ProcessusBean {

	public ErrorProcessus(final InfoBean infoBean) {
		super(infoBean);
	}

	protected static final String NOM_PROCESSUS = "ERREUR_PROCESSUS";

	protected static final String ECRAN_PRINCIPAL = "PRINCIPAL";

	@Override
	protected boolean traiterAction() throws Exception {
		ecranLogique = infoBean.getEcranLogique();
		action = infoBean.getActionUtilisateur();
		etat = EN_COURS;
		// placer l'état dans le composant d'infoBean
		infoBean.setNomProcessus(NOM_PROCESSUS);
		infoBean.setEcranLogique(ECRAN_PRINCIPAL);
		// On continue si on n'est pas à la FIN !!!
		return (etat == FIN);
	}
}
