/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.jsbsoft.jtf.core;

import org.apache.commons.lang3.StringUtils;

import com.univ.utils.EscapeString;

/**
 * Insérez la description du type à cet endroit. Date de création : (10/06/2002 18:01:01)
 * 
 * @author :
 */
public class HTMLUtil {

	/**
	 * Commentaire relatif au constructeur HTMLUtil.
	 */
	public HTMLUtil() {
		super();
	}

	/**
	 * Conversion des caractères HTML encodés - &#xxx; (encodage décimal) - <BR>
	 * en cr
	 * 
	 * 
	 * Cette conversion est utilisée à 2 endroits : - export XML - Saisie en mode HTML
	 * 
	 * Pour l'instant, les caractères encodés supérizurs à 255 sont laissés tel quel
	 * 
	 * En mode HTML ils sont affichés sous la forme &#8888; En export XML, ils sont convertis.
	 * 
	 * @param _chaine
	 *            the _chaine
	 * @param _suppressionTagsHTML
	 *            the _suppression tags html
	 * 
	 * @return the string
	 */
	@Deprecated
	public static String convertirEnASCII(String _chaine, boolean _suppressionTagsHTML) {
		StringBuilder sb = new StringBuilder();
		String curTag = "";
		String chaine = EscapeString.unescapeHtml(_chaine);
		int n = chaine.length();
		for (int i = 0; i < n; i++) {
			char c = chaine.charAt(i);
			//Détection tags HTML
			if (chaine.charAt(i) == '<') {
				curTag = extraireTagHTML(chaine, i);
				if (_suppressionTagsHTML) {
					// Certains Tags doivent être remplacés
					if ("LI".equalsIgnoreCase(curTag)) {
						sb.append("\n  -");
					}
					if ("/UL".equalsIgnoreCase(curTag)) {
						sb.append("\n");
					}
					if ("/OL".equalsIgnoreCase(curTag)) {
						sb.append("\n");
					}
					if ("BR".equalsIgnoreCase(curTag)) {
						sb.append("\n");
					}
					// JSS 20040226 : ajout paragraphes
					if ("P".equalsIgnoreCase(curTag)) {
						sb.append("\n\n");
					}
				}
			}
			//Détection caractères spéciaux
			if (chaine.charAt(i) == '&') {
				// JSSS 20020923-002
				if ((i < chaine.length() - 1) && (chaine.charAt(i + 1)) == '#') {
					String valeur = "";
					int j = 0;
					//JSS 20020710 : 				 correction strictement sup à 0
					while ((i + 2 + j < chaine.length()) && (chaine.charAt(i + 2 + j) >= '0') && (chaine.charAt(i + 2 + j) <= '9')) {
						valeur += chaine.charAt(i + 2 + j);
						j++;
					}
					try {
						if (Integer.parseInt(valeur) < 256) {
							c = (char) Integer.parseInt(valeur);
							// Repositionnement
							i = i + 2 + j;
						} else
							// JSSS 20020923-002
							// Le caractère 8217 est issu de coller à partir de Word
							if (Integer.parseInt(valeur) == 8217) {
								c = '\'';
								// Repositionnement
								i = i + 2 + j;
							} else {
								// On laisse les encodages sup à 255
								// Sinon, ils provoquent des erreurs
								// en mode HTML
								// Pour l'export XML, ces caractères devront
								// être traités à part
								c = '&';
							}
					} catch (Exception e) {}
				}
			}
			// Insertion du caractère
			switch (c) {
			default:
				if ("".equals(curTag)) {
					sb.append(c);
				} else {
					if (!_suppressionTagsHTML) {
						sb.append(c);
					}
				}
				break;
			}
			// Fin du tag
			if (chaine.charAt(i) == '>') {
				curTag = "";
			}
		}
		return sb.toString();
	}

	/**
	 * Extraction du tag HTML situé à la position courante.
	 * 
	 * @param chaine
	 *            the chaine
	 * @param i
	 *            the i
	 * 
	 * @return the string
	 */
	@Deprecated
	public static String extraireTagHTML(String chaine, int i) {
		String tagsHTML[] = { "A", "H1", "H2", "H3", "H4", "H5", "IMG", "LI", "UL", "BR", "B", "I", "STRONG", "U", "P", "EM", "OL", "DIV", "BLOCKQUOTE", "TABLE", "PRE", "TR", "TD", "TBODY", "FONT", "SUP", "TBODY", "SPAN" };
		String curTag = "";
		int n = chaine.length();
		// Détection des tags
		// Un tag est sous la forme ( "<"  ou "</" ) puis XXXX puis ( " " ou ">")
		// Soit "<XXXX> ou </XXXX> ou "<XXXX " ou "</XXXX ">
		if (chaine.charAt(i) == '<' && i + 1 < n) {
			for (String element : tagsHTML) {
				String nomTag = "";
				if (chaine.charAt(i + 1) != '/') {
					if (i + 1 + element.length() + 1 <= n) {
						nomTag = chaine.substring(i + 1, i + 1 + element.length() + 1);
					}
				} else {
					if (i + 2 + element.length() + 1 <= n) {
						nomTag = chaine.substring(i + 2, i + 2 + element.length() + 1);
					}
				}
				if ((nomTag.equalsIgnoreCase(element + " ")) || (nomTag.equalsIgnoreCase(element + ">"))) {
					curTag = nomTag.substring(0, nomTag.length() - 1).toUpperCase();
					if (chaine.charAt(i + 1) == '/') {
						curTag = "/" + curTag;
					}
				}
			}
		}
		return curTag;
	}

	/* Conversion des carcatères encodés */
	/**
	 * Unescape html.
	 * 
	 * @param s
	 *            the s
	 * 
	 * @return the string
	 * @deprecated utiliser {@link EscapeString#unescapeHtml(String)}
	 */
	@Deprecated
	public static final String unescapeHTML(String s) {
		return EscapeString.unescapeHtml(s);
	}

	public static String stripHtml(String value){
		value = StringUtils.replacePattern(value, "<(li|LI)>", "\n - ");
		value = StringUtils.replacePattern(value, "</(ul|UL)>", "\n");
		value = StringUtils.replacePattern(value, "</(ol|OL)>", "\n");
		value = StringUtils.replacePattern(value, "<(br|BR)(|\\s)(|/)>", "\n");
		value = StringUtils.replacePattern(value, "</(p|P|div|DIV)>", "\n");
		value = StringUtils.replacePattern(value, "<[^>]*>", "");
		return EscapeString.unescapeHtml(value);

	}
}