/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * Created on 30 oct. 2005
 * JSS 20051030
 *
*/
package com.jsbsoft.jtf.core;

import java.io.File;
import java.io.FilenameFilter;

/**
 * The Class InfoBeanFilter.
 * 
 * @author jean-sébastien steux
 * 
 *         Filtre des sauvegardes des InfosBean dans fichiers (pagination des listes)
 */
public class InfoBeanFilter implements FilenameFilter {

	/** The pattern. */
	String pattern = "";

	/**
	 * Instantiates a new info bean filter.
	 * 
	 * @param _ksession
	 *            the _ksession
	 * @param _type
	 *            the _type
	 */
	public InfoBeanFilter(String _ksession, String _type) {
		super();
		pattern = "datas_";
		if (_ksession != null && _ksession.length() > 0) {
			pattern += _ksession + "_" + _type;
		}
	}

	/* (non-Javadoc)
	 * @see java.io.FilenameFilter#accept(java.io.File, java.lang.String)
	 */
	@Override
	public boolean accept(File dir, String name) {
		return (name.indexOf(pattern) == 0);
	}
}