/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.jsbsoft.jtf.core;

import org.apache.commons.lang3.StringUtils;

/**
 * Classe de stockage de la page à afficher.
 */
public class InfosEnchainementProcessus {

	/** The TYP e_ aucune. */
	public static int TYPE_AUCUNE = 0;

	/** The TYP e_ jsp. */
	public static int TYPE_JSP = 1;

	/** The TYPE URL. */
	public static int TYPE_URL_REDIRECTION = 3;

	/** The type action. */
	public int type = 0;

	/** The nom action. */
	public String retour = StringUtils.EMPTY;

	public String conteneur = StringUtils.EMPTY;

	/**
	 * Commentaire relatif au constructeur InfosEnchainementProcessus.
	 */
	public InfosEnchainementProcessus() {}

	/**
	 * Commentaire relatif au constructeur InfosEnchainementProcessus.
	 * 
	 * @param type
	 *            the _type action
	 * @param retour
	 *            the _nom action
	 */
	public InfosEnchainementProcessus(final int type, final String retour) {
		this.type = type;
		this.retour = retour;
	}

	public InfosEnchainementProcessus(final int type, final String retour, final String conteneur) {
		this.type = type;
		this.retour = retour;
		this.conteneur = conteneur;
	}
}