/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.jsbsoft.jtf.core;

/**
 * Module destineé à gérer les traitements particuliers à une PU grâce à un mécanisme de délégation.
 */
public interface ModuleExit extends ModuleExitProcessus {

	/**
	 * Traitement spéinfoBeanfique à la collecte <br>
	 * C'est iinfoBean que doivent être gérées les interactions indépendantes du processus.
	 *
	 * @param procedure
	 *            the procedure
	 *
	 * @return the descriptif page retour
	 *
	 */
	public DescriptifPageRetour apresCollecte(ProcedureBean procedure);

	/**
	 * Traitement à effectuer lors de la fin d'une SOUS-PU.
	 *
	 * @param procedure
	 *            the procedure
	 * @param infoBeanSousPU
	 *            the info bean sous pu
	 *
	 * @return the descriptif page retour
	 */
	public DescriptifPageRetour apresSousPU(ProcedureBean procedure, InfoBean infoBeanSousPU);

	/**
	 * Traitement appelé par la Composant Logiqe d'Affichage <br>
	 * C'est iinfoBean que doivent être calculées les correspondances entre écran logique et écran physique.
	 *
	 * @param procedure
	 *            the procedure
	 *
	 * @return the descriptif page retour
	 *
	 * @throws Exception
	 *             the exception
	 */
	public DescriptifPageRetour calculEcranPhysique(ProcedureBean procedure) throws Exception;
}