/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.jsbsoft.jtf.core;

/**
 * Module destineé à gérer les traitements à effectuer au retour d(un processus <br>
 * . Il peut être implémenté dans une procédure (processus de 1er niveau) ou dans un processus (retour du sous-processus)
 */
public interface ModuleExitProcessus {

	/**
	 * Apres processus.
	 * 
	 * @param gp
	 *            the gp
	 * @param cloneCI
	 *            the clone ci
	 * 
	 * @return the descriptif page retour
	 * 
	 * @throws Exception
	 *             the exception
	 */
	public DescriptifPageRetour apresProcessus(ProcessusManager gp, InfoBean cloneCI) throws Exception;
}