/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.jsbsoft.jtf.core;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * Servlet générique du framework.
 */
public class SG extends HttpServlet {

	/**
	 *
	 */
	private static final long serialVersionUID = -8108206932575170795L;

	/**
	 * Méthode standard, sous-classée si besoin.
	 *
	 * @param req
	 *            la requete http en GET
	 * @param res
	 *            la réponse à renvoyer
	 *
	 * @throws ServletException
	 *             the servlet exception
	 * @throws IOException
	 *             Signals that an I/O exception has occurred.
	 */
	@Override
	public void doGet(final HttpServletRequest req, final HttpServletResponse res) throws ServletException, IOException {
		(new TraitementRequeteHTTP()).traiterRequeteHTTP(this, req, res);
	}

	/**
	 * Méthode standard, sous-classée si besoin (forcement on fait comme ne get...)
	 *
	 * @param req
	 *            la requete http en post
	 * @param res
	 *            la réponse à renvoyer
	 *
	 * @throws ServletException
	 *             the servlet exception
	 * @throws IOException
	 *             Signals that an I/O exception has occurred.
	 */
	@Override
	public void doPost(final HttpServletRequest req, final HttpServletResponse res) throws ServletException, IOException {
		doGet(req, res);
	}
}
