/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * Created on 22 févr. 2004
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package com.jsbsoft.jtf.database;

import java.util.Vector;

/**
 * The Class EtatRequete.
 * 
 * @author jean-sébastien steux
 * 
 * 
 * 
 *         Modif le 22 févr. 2004
 */
public class EtatRequete {

	/** The is termine. */
	private boolean isTermine = false;

	/** The timestamp debut. */
	private long timestampDebut = System.currentTimeMillis();

	/** The timestamp fin. */
	private long timestampFin = 0;

	/** The evenements. */
	private Vector<String> evenements = new Vector<String>();

	/**
	 * Ajouter evenement.
	 * 
	 * @param evenement
	 *            the evenement
	 */
	public void ajouterEvenement(String evenement) {
		evenements.add(evenement);
	}

	/**
	 * Terminer.
	 */
	public void terminer() {
		timestampFin = System.currentTimeMillis();
		isTermine = true;
	}

	/**
	 * Checks if is terminee.
	 * 
	 * @return true, if is terminee
	 */
	public boolean isTerminee() {
		return isTermine;
	}

	/**
	 * Gets the evenements.
	 * 
	 * @return the evenements
	 */
	public Vector<String> getEvenements() {
		return evenements;
	}

	/**
	 * Gets the timestamp debut.
	 * 
	 * @return the timestamp debut
	 */
	public long getTimestampDebut() {
		return timestampDebut;
	}

	/**
	 * Sets the evenements.
	 * 
	 * @param vector
	 *            the vector
	 */
	public void setEvenements(Vector<String> vector) {
		evenements = vector;
	}

	/**
	 * Sets the timestamp debut.
	 * 
	 * @param l
	 *            the l
	 */
	public void setTimestampDebut(long l) {
		timestampDebut = l;
	}

	/**
	 * Gets the timestamp fin.
	 * 
	 * @return the timestamp fin
	 */
	public long getTimestampFin() {
		return timestampFin;
	}

	/**
	 * Sets the timestamp fin.
	 * 
	 * @param l
	 *            the l
	 */
	public void setTimestampFin(long l) {
		timestampFin = l;
	}
}