/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.jsbsoft.jtf.database;

import java.sql.Connection;
import java.util.Locale;
import java.util.Map;

import com.univ.multisites.InfosSite;

/**
 * Le contexte métier (propagé entre processus et objets métiers).
 */
public interface OMContext {

	/** nom du paramètre représentant la servletConfig dans la table du contexte. */
	public String CLE_SERVLET_CONFIG = "_servlet_config";

	/** The CL e_ servle t_ s g_ requet e_ http. */
	public String CLE_SERVLET_SG_REQUETE_HTTP = "_sg_requete_http";

	/**
	 * Gets the connection.
	 * 
	 * @return the connection
	 */
	public Connection getConnection();

	/**
	 * Gets the locale.
	 * 
	 * @return the locale
	 */
	public Locale getLocale();

	/**
	 * Gets the id requete.
	 * 
	 * @return the id requete
	 */
	public String getIdRequete();

	/**
	 * Gets the datas.
	 * 
	 * @return the datas
	 */
	public Map<String, Object> getDatas();

	/**
	 * Sets the infos site.
	 * 
	 * @param infosSite
	 *            the new infos site
	 */
	public void setInfosSite(InfosSite infosSite);

	/**
	 * Gets the infos site.
	 * 
	 * @return the infos site
	 */
	public InfosSite getInfosSite();

	/**
	 * Sets the secure.
	 * 
	 * @param secure
	 *            the new secure
	 */
	public void setSecure(boolean secure);

	/**
	 * Checks if is secure.
	 * 
	 * @return true, if is secure
	 */
	public boolean isSecure();
}
