/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.jsbsoft.jtf.database;

import java.util.List;

/**
 * Cette interface contient toutes les méthodes qu'il est possible d'appeler directement sur un SOSJDBCProxy.
 * 
 * @author IBM
 * 
 */
public interface SOSJDBCProxyInterface {

	/**
	 * @return Cette méthode retourne l'interface implémentée par le proxy.
	 */
	public abstract Class<?> getClazz();

	/**
	 * @return cetter méthode retourne l'objet original wrappé par le proxy.
	 */
	public abstract Object getWrapped();

	/**
	 * Cette méthode ajoute des ressources (statement, resultset) à la connexion associé au proxy.
	 * 
	 * @param orginal
	 *            l'objet original de la ressource à ajouter.
	 * @param proxy
	 *            le proxy de la ressource à ajouter.
	 */
	public abstract void addResource(Object orginal, Object proxy);

	/**
	 * Cette méthode retire de la liste des ressources l'objet passé en paramètre. Cette méthode est appelé après un close d'une ressource.
	 * 
	 * @param obj
	 *            l'objet a retirer de la liste des ressources, cela peut être un objet original ou un proxy?
	 */
	public abstract void removeResource(Object obj);

	/**
	 * Cette méthode retourne la liste des proxys des ressources associées au proxy courant. Tuojours null sauf si l'objet courant est une connexion.
	 * 
	 * @return la liste des proxy de ressources.
	 */
	public List<Object> getResourcesProxy();

	/**
	 * Cette méthode retourne la liste des originaux (non proxy) des ressources associées au proxy courant. Tuojours null sauf si l'objet courant est une connexion.
	 * 
	 * @return la liste des proxy de ressources.
	 */
	public List<Object> getResourcesOriginales();
}