/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * Created on 22 févr. 2005
 *
 * To change the template for this generated file go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
package com.jsbsoft.jtf.database;

/**
 * The Class SQLServerDatabaseManager.
 * 
 * @author administrateur
 * 
 *         To change the template for this generated type comment go to Window - Preferences - Java - Code Generation - Code and Comments
 */
public class SQLServerDatabaseManager extends DatabaseServerManager {

	/* (non-Javadoc)
	 * @see com.jsbsoft.jtf.database.DatabaseServerManager#genererObjectId()
	 */
	@Override
	public Long genererObjectId() {
		return new Long(System.currentTimeMillis());
	}

	/* (non-Javadoc)
	 * @see com.jsbsoft.jtf.database.DatabaseServerManager#genererRequeteClauseLimit(java.lang.String, java.lang.String, java.lang.String, int, int)
	 */
	@Override
	public String genererRequeteClauseLimit(String table, String baseQuery, String sqlSuffix, int debut, int increment) {
		String requete = "select * from (select top " + increment + " * from (select top " + (debut + increment) + " * from " + table + " " + sqlSuffix + ") as T2 " + sqlSuffix + " DESC) as T1 " + sqlSuffix + "";
		return requete;
	}

	/* (non-Javadoc)
	 * @see com.jsbsoft.jtf.database.DatabaseServerManager#genererRequeteSelectCount(java.lang.String, java.lang.String, java.lang.String)
	 */
	@Override
	public String genererRequeteSelectCount(String table, String qualifier, String sqlSuffix) {
		String sqlCount = "";
		if (sqlSuffix.indexOf("ORDER BY") != -1) {
			sqlCount = sqlSuffix.substring(0, sqlSuffix.indexOf("ORDER BY"));
		} else {
			sqlCount = sqlSuffix;
		}
		return "SELECT COUNT(*) FROM " + qualifier + table + " T1 " + sqlCount;
	}

	/* (non-Javadoc)
	 * @see com.jsbsoft.jtf.database.DatabaseServerManager#genererRequeteSelectDistinctCount(java.lang.String, java.lang.String, java.lang.String)
	 */
	@Override
	public String genererRequeteSelectDistinctCount(String table, String qualifier, String sqlSuffix) {
		String sqlCount = "";
		if (sqlSuffix.indexOf("ORDER BY") != -1) {
			sqlCount = sqlSuffix.substring(0, sqlSuffix.indexOf("ORDER BY"));
		} else {
			sqlCount = sqlSuffix;
		}
		return "SELECT COUNT(DISTINCT T1.ID_" + table + ") FROM " + qualifier + table + " T1 " + sqlCount;
	}
}
