/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.jsbsoft.jtf.database;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import com.kportal.scheduling.spring.quartz.LogReportJob;
import com.univ.objetspartages.om.DiffusionSelective;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.ReferentielObjets;
import com.univ.utils.ClassMetaUtil;
import com.univ.utils.ContexteDao;

public class UpdateIndexDBJob extends LogReportJob {

	@Override
	public void perform() {
		final ContexteDao ctx = new ContexteDao();
		try {
			JDBCUtils.setTempLogger(logger);
			// Boucle sur les fiches
			for (final String codeObjet : ReferentielObjets.getListeCodesObjet()) {
				final FicheUniv fiche = ReferentielObjets.instancierFiche(codeObjet);
				if (fiche != null) {
					final List<String> listeIndexs = new ArrayList<String>();
					listeIndexs.add("CODE");
					listeIndexs.add("ETAT_OBJET");
					listeIndexs.add(ClassMetaUtil.getClassMetaValue(fiche, "NOM_CODE_RATTACHEMENT"));
					listeIndexs.add("CODE_REDACTEUR");
					listeIndexs.add(ClassMetaUtil.getClassMetaValue(fiche, "NOM_CODE_RUBRIQUE"));
					if (fiche instanceof DiffusionSelective) {
						listeIndexs.add("DIFFUSION_PUBLIC_VISE*100");
						listeIndexs.add("DIFFUSION_MODE_RESTRICTION");
						listeIndexs.add("DIFFUSION_PUBLIC_VISE_RESTRICTION*100");
					}
					JDBCUtils.mettreAJourIndexsTable(ctx.getConnection(), ReferentielObjets.getNomTableSql(codeObjet), listeIndexs);
				}
			}
			JDBCUtils.mettreAJourIndexsTable(ctx.getConnection(), "UTILISATEUR", Arrays.asList(new String[] { "CODE", "CODE_LDAP", "CODE_RATTACHEMENT" }));
			JDBCUtils.mettreAJourIndexsTable(ctx.getConnection(), "ENCADRE", Arrays.asList(new String[] { "OBJETS*100", "ACTIF" }));
			JDBCUtils.mettreAJourIndexsTable(ctx.getConnection(), "ESPACECOLLABORATIF", Arrays.asList(new String[] { "CODE", "CODE_RUBRIQUE", "CODE_STRUCTURE", "THEME" }));
			JDBCUtils.mettreAJourIndexsTable(ctx.getConnection(), "RESSOURCE", Arrays.asList(new String[] { "CODE_PARENT" }));
			JDBCUtils.mettreAJourIndexsTable(ctx.getConnection(), "GROUPEDSI", Arrays.asList(new String[] { "CODE", "GESTION_CACHE", "ROLES*100" }));
			JDBCUtils.mettreAJourIndexsTable(ctx.getConnection(), "GROUPEUTILISATEUR", Arrays.asList(new String[] { "CODE_GROUPE", "CODE_UTILISATEUR", "SOURCE_IMPORT" }));
			JDBCUtils.mettreAJourIndexsTable(ctx.getConnection(), "LIBELLE", Arrays.asList(new String[] { "TYPE", "CODE", "LIBELLE", "LANGUE" }));
			JDBCUtils.mettreAJourIndexsTable(
				ctx.getConnection(),
				"METATAG",
				Arrays.asList(new String[] { "META_CODE", "META_CODE_OBJET", "META_CODE_RATTACHEMENT", "META_CODE_RUBRIQUE", "META_CODE_REDACTEUR", "META_LANGUE", "META_ETAT_OBJET", "META_DIFFUSION_PUBLIC_VISE*100", "META_DIFFUSION_MODE_RESTRICTION", "META_DIFFUSION_PUBLIC_VISE_RESTRICTION*100", "META_RUBRIQUES_PUBLICATION*100", "META_CODE_RATTACHEMENT_AUTRES*100", "META_ID_FICHE", "META_DATE_MISE_EN_LIGNE", "META_DATE_MODIFICATION" }));
			JDBCUtils.mettreAJourIndexsTable(ctx.getConnection(), "MEDIA", Arrays.asList(new String[] { "TITRE", "TYPE_RESSOURCE", "CODE_RUBRIQUE", "CODE_RATTACHEMENT" }));
			JDBCUtils.mettreAJourIndexsTable(ctx.getConnection(), "PREFERENCES", Arrays.asList(new String[] { "CODE_UTILISATEUR", "TYPE", "NOM", "SERVICE" }));
			JDBCUtils.mettreAJourIndexsTable(ctx.getConnection(), "ROLE", Arrays.asList(new String[] { "CODE" }));
			JDBCUtils.mettreAJourIndexsTable(ctx.getConnection(), "RUBRIQUE", Arrays.asList(new String[] { "CODE", "LANGUE" }));
			JDBCUtils.mettreAJourIndexsTable(ctx.getConnection(), "RUBRIQUEPUBLICATION",
				Arrays.asList(new String[] { "TYPE_FICHE_ORIG", "CODE_FICHE_ORIG", "LANGUE_FICHE_ORIG", "RUBRIQUE_DEST", "SOURCE_REQUETE*100" }));
			JDBCUtils.mettreAJourIndexsTable(ctx.getConnection(), "SERVICE", Arrays.asList(new String[] { "CODE" }));
			JDBCUtils.mettreAJourIndexsTable(ctx.getConnection(), "UTILISATEUR", Arrays.asList(new String[] { "CODE", "NOM", "CODE_LDAP", "CODE_RATTACHEMENT", "ROLES*100" }));
			JDBCUtils.setTempLogger(null);
		} catch (final Exception e) {
			logger.error("erreur lors de la mise à jour des indexs ", e);
		} finally {
			ctx.close();
		}
	}
}
