/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.jsbsoft.jtf.exception;

/**
 * 
 * Exception levée lorsqu'une données à récupérée n'est pas trouvée. <br/>
 * <br/>
 * <strong>REMARQUE : </strong> permet d'éviter de revoyer des valeurs <code>null</code> et de créer de possible {@link NullPointerException} dans le reste de l'application. Avec
 * cette exception, l'anomalie remonte jusqu'à temps qu'elle soit gérée. De plus, héritant de {@link ErreurApplicative} elle est gérée par le produit.
 * 
 * @author pierre.cosson
 * 
 */
public class ErreurDonneeNonTrouve extends ErreurApplicative {

	/**
	 * ID
	 */
	private static final long serialVersionUID = -4192935337733417145L;

	public ErreurDonneeNonTrouve(int num, String mes) {
		super(num, mes);
	}

	public ErreurDonneeNonTrouve(String mes) {
		super(mes);
	}
}
