/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.jsbsoft.jtf.exception;

/**
 * This type was created in VisualAge.
 */
public class JsbException extends Exception {

	/**
	 * 
	 */
	private static final long serialVersionUID = 8251246964936754932L;

	/**
	 * JsbException constructor comment.
	 */
	public JsbException() {
		super();
	}

	/**
	 * JsbException constructor comment.
	 * 
	 * @param num
	 *            the num
	 */
	public JsbException(int num) {
		super("[" + num + "]");
	}

	/**
	 * JsbException constructor comment.
	 * 
	 * @param num
	 *            the num
	 * @param mes
	 *            the mes
	 */
	public JsbException(int num, String mes) {
		super("[" + num + "] : " + mes);
	}

	/**
	 * Instantiates a new jsb exception.
	 * 
	 * @param num
	 *            the num
	 * @param mes
	 *            the mes
	 * @param t
	 *            the t
	 */
	public JsbException(int num, String mes, Throwable t) {
		super("[" + num + "] : " + mes, t);
	}

	/**
	 * Instantiates a new jsb exception.
	 * 
	 * @param mes
	 *            the mes
	 * @param cause
	 *            the cause
	 */
	public JsbException(String mes, Throwable cause) {
		super(mes, cause);
	}

	/**
	 * Instantiates a new jsb exception.
	 * 
	 * @param cause
	 *            the cause
	 */
	public JsbException(Throwable cause) {
		super(cause);
	}

	/**
	 * Instantiates a new jsb exception.
	 * 
	 * @param mes
	 *            the mes
	 */
	public JsbException(String mes) {
		super(mes);
	}

	/* (non-Javadoc)
	 * @see java.lang.Throwable#toString()
	 */
	@Override
	public String toString() {
		return getMessage();
	}
}