/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.jsbsoft.jtf.identification;

import com.jsbsoft.jtf.database.OMContext;

/**
 * Interface permettant l'implémentation d'une source d'authentification.
 * 
 * @author jbiard
 */
public interface ISourceAuth {

	/**
	 * Authentifie un utilisateur et renvoie un objet Utilisateur associé.
	 * 
	 * @param codeUtilisateur
	 *            login
	 * @param mdp
	 *            mode de passe
	 * @param ctx
	 *            contexte pour récupération de l'utilisateur K-Portal
	 * 
	 * @return utilisateur K-Portal
	 * 
	 * @throws Exception
	 *             the exception
	 */
	boolean connecte(String codeUtilisateur, String mdp, OMContext ctx) throws Exception;

	/**
	 * Appelée avant destruction des infos de session.
	 * 
	 * @param codeUtilisateur
	 *            code de l'utilisateur à déconnecter
	 * @param ctx
	 *            contexte
	 * 
	 * @throws Exception
	 */
	void deconnecte(String codeUtilisateur, OMContext ctx);

	/**
	 * Renvoie le code associé à la source. Doit avoir pour valeur celle déclarée dans le jtf, soit authentification.code_source.classe.
	 * 
	 * @return code
	 */
	String getCodeSource();

	/**
	 * Renvoie le libellé associée à la source.
	 * 
	 * @return libellé
	 */
	String getLibelleSource();

	/**
	 * Renvoie sous forme d'une chaîne le paramétrage chargé par la source.
	 * 
	 * @return paramétrage
	 */
	String parametrageCharge();
}
