/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.jsbsoft.jtf.identification;

import com.jsbsoft.jtf.database.OMContext;
import com.kportal.core.security.MySQLHelper;
import com.univ.objetspartages.om.Utilisateur;
import com.univ.utils.sql.clause.ClauseWhere;
import com.univ.utils.sql.criterespecifique.ConditionHelper;

/**
 * Prend en charge l'authentification sur la BD K-Portal. C'est le mode d'authentification par défaut.
 * 
 * @author jbiard
 */
public class SourceAuthDefautKbd implements ISourceAuth {

	/** The Constant SOURCE_LIBELLE_KBD. */
	public final static String SOURCE_LIBELLE_KBD = "kbd";

	/** The Constant SOURCE_LIBELLE_AFFICHABLE. */
	public final static String SOURCE_LIBELLE_AFFICHABLE = "Base de données K-Portal";

	/* (non-Javadoc)
	 * @see com.jsbsoft.jtf.identification.ISourceAuth#connecte(java.lang.String, java.lang.String, com.jsbsoft.jtf.database.OMContext)
	 */
	@Override
	public boolean connecte(String codeUtilisateur, String mdp, OMContext ctx) throws Exception {
		//le mot de passe ne peut pas être vide
		if (mdp.trim().length() == 0) {
			return false;
		}
		Utilisateur utilisateur = new Utilisateur();
		utilisateur.init();
		utilisateur.setCtx(ctx);
		String passwordEncode = MySQLHelper.encodePassword(mdp);
		ClauseWhere whereCodeEtPass = new ClauseWhere(ConditionHelper.egalVarchar("CODE", codeUtilisateur));
		whereCodeEtPass.and(ConditionHelper.egalVarchar("MOT_DE_PASSE", passwordEncode));
		return (utilisateur.select(whereCodeEtPass.formaterSQL()) != 0);
	}

	/* (non-Javadoc)
	 * @see com.jsbsoft.jtf.identification.ISourceAuth#deconnecte(java.lang.String, com.jsbsoft.jtf.database.OMContext)
	 */
	@Override
	public void deconnecte(String codeUtilisateur, OMContext ctx) {}

	/* (non-Javadoc)
	 * @see com.jsbsoft.jtf.identification.ISourceAuth#getCodeSource()
	 */
	@Override
	public String getCodeSource() {
		return SOURCE_LIBELLE_KBD;
	}

	/**
	 * Gets the libelle source.
	 * 
	 * @return the libelle source
	 * 
	 * @see ISourceAuth
	 */
	@Override
	public String getLibelleSource() {
		return SOURCE_LIBELLE_AFFICHABLE;
	}

	/* (non-Javadoc)
	 * @see com.jsbsoft.jtf.identification.ISourceAuth#parametrageCharge()
	 */
	@Override
	public String parametrageCharge() {
		return "";
	}
}
