/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.jsbsoft.jtf.identification;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

import com.jsbsoft.jtf.core.InfoBean;
import com.kportal.core.config.PropertyHelper;

public class SourceAuthHelper {

	private static final String PROP_AUTHENTIFICATION_KUSER_CONNECTOR = "authentification.kuser_connector";
	public static final String KUSER_CONNECTOR = "KUSER_CONNECTOR";

	public static boolean isDoubleSourceAuthActif(HttpServletRequest request, InfoBean infoBean) {
		// activation de l'option
		if (!"1".equals(PropertyHelper.getCoreProperty(PROP_AUTHENTIFICATION_KUSER_CONNECTOR))) {
			return false;
		}
		// récupération du cookie KUSER_CONNECTOR
		boolean cookieKUserConnector = false;
		Cookie[] cookies = request.getCookies();
		if (cookies != null) {
			for (Cookie cookie : cookies) {
				cookieKUserConnector |= KUSER_CONNECTOR.equals(cookie.getName()) && "ok".equals(cookie.getValue());
			}
		}
		// OU presence du parametre dans l'url du processus d'identification
		return "1".equals(infoBean.getString(KUSER_CONNECTOR)) || cookieKUserConnector;
	}
}
