/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.jsbsoft.jtf.ldap;

import javax.naming.NamingException;

/**
 * The Interface IConnexionLdap.
 */
public interface IConnexionLdap {

	/**
	 * Gets the unique id.
	 * 
	 * @param valueAttributeLogin
	 *            the value attribute login
	 * @param nameAttributeLogin
	 *            the name attribute login
	 * @param nameAnnuaireAttribute
	 *            the name annuaire attribute
	 * @param nameEtuAttribute
	 *            the name etu attribute
	 * @param critereEtudiant
	 *            the critere etudiant
	 * @param valueCritereEtudiant
	 *            the value critere etudiant
	 * 
	 * @return the unique id
	 * 
	 * @throws NamingException
	 *             the naming exception
	 * @throws NullPointerException
	 *             the null pointer exception
	 * @throws Exception
	 *             the exception
	 */
	String getUniqueId(String valueAttributeLogin, String nameAttributeLogin, String nameAnnuaireAttribute, String nameEtuAttribute, String critereEtudiant,
		String valueCritereEtudiant) throws NamingException, NullPointerException, Exception;

	/**
	 * Gets the liste alias.
	 * 
	 * @return the liste alias
	 */
	String[] getListeAlias();

	/**
	 * Release context.
	 * 
	 * @throws NamingException
	 *             the naming exception
	 * @throws Exception
	 *             the exception
	 */
	void releaseContext() throws NamingException, Exception;
}
