/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.jsbsoft.jtf.ldap;

import java.util.HashMap;
import java.util.Vector;

import javax.naming.NamingException;

/**
 * The Interface IRequeteurLdapGroupeDynamique.
 */
public interface IRequeteurLdapGroupeDynamique {

	/** The REQUETEU r_ lda p_ class e_ libell e_ jtf. */
	String REQUETEUR_LDAP_CLASSE_LIBELLE_JTF = "requeteurGroupeDynamiqueExterne.classe";

	/**
	 * Checks if is valid requete.
	 * 
	 * @param _s
	 *            the _s
	 * 
	 * @return true, if is valid requete
	 * 
	 * @throws NamingException
	 *             the naming exception
	 * @throws Exception
	 *             the exception
	 */
	public boolean isValidRequete(String _s) throws NamingException, Exception;

	/**
	 * Gets the utilisteur.
	 * 
	 * @param codeUtilisateur
	 *            the code utilisateur
	 * 
	 * @return the utilisteur
	 * 
	 * @throws NamingException
	 *             the naming exception
	 * @throws Exception
	 *             the exception
	 */
	public HashMap getUtilisteur(String codeUtilisateur) throws NamingException, Exception;

	/**
	 * Gets the resultat requete.
	 * 
	 * @param _requete
	 *            the _requete
	 * @param _codeUtilisateur
	 *            the _code utilisateur
	 * 
	 * @return the resultat requete
	 * 
	 * @throws NamingException
	 *             the naming exception
	 * @throws Exception
	 *             the exception
	 */
	public Vector getResultatRequete(String _requete, String _codeUtilisateur) throws NamingException, Exception;

	/**
	 * Gets the list utilisateur.
	 * 
	 * @param request
	 *            the request
	 * 
	 * @return the list utilisateur
	 * 
	 * @throws NamingException
	 *             the naming exception
	 * @throws Exception
	 *             the exception
	 */
	public Vector getListUtilisateur(String request) throws NamingException, Exception;
}
