/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.jsbsoft.jtf.monitoring;

import javax.servlet.http.HttpServletRequest;

import com.jsbsoft.jtf.database.OMContext;
import com.kportal.core.config.PropertyHelper;

/**
 * Modelise un scenario de monitoring. Un scenario est caracterise par un code (unique) permettant la remontee de proprietes et d'un intitule. Il execute des modules qui remontent
 * des resultats, qui sont communiques au gestionnaire de scenarios. Les parametres du scenario sont lus a partir du fichier de proprietes, les clefs de celles-ci sont prefixees
 * par PARAM_SCENARIO_MONITORING + ".".
 * 
 * @see com.jsbsoft.jtf.monitoring.GestionnaireScenarios
 * @see com.jsbsoft.jtf.monitoring.AbsModuleMonitoring
 * @author jbiard
 */
public abstract class AbsScenario {

	/** The Constant PARAM_SCENARIO_MONITORING. */
	public final static String PARAM_SCENARIO_MONITORING = "monitoring.scenario";

	/** The intitule. */
	private final String code, intitule;

	/**
	 * Instantiates a new abs scenario.
	 * 
	 * @param code
	 *            the code
	 * @param intitule
	 *            the intitule
	 */
	public AbsScenario(final String code, final String intitule) {
		this.code = code;
		this.intitule = intitule;
	}

	/**
	 * Gets the intitule.
	 * 
	 * @return the intitule
	 */
	public String getIntitule() {
		return intitule;
	}

	/**
	 * Gets the code.
	 * 
	 * @return the code
	 */
	public String getCode() {
		return code;
	}

	/**
	 * Lance l'execution des modules.
	 * 
	 * @param ctx
	 *            contexte
	 * @param req
	 *            requete recue par la jsp de monitoring
	 * 
	 * @return resultats des modules
	 */
	public abstract AbsModuleMonitoring.ResExec[] executer(OMContext ctx, HttpServletRequest req);

	/**
	 * Renvoie la valeur d'une propriete definie pour le scenario.
	 * 
	 * @param param
	 *            parametre permettant de constituer la clef dans le fichier de proprietes
	 * 
	 * @return valeur sous forme de chaine
	 */
	protected String getParametre(final String param) {
		return PropertyHelper.getCoreProperty(PARAM_SCENARIO_MONITORING + "." + code + "." + param);
	}
}